{$V-} { $V- = Turn strict string checking off }
UNIT KeyInput;

(* 
    KeyInput keyboard entry unit.

    MSCOMMON is Copyright (C) 1993-2004 by Lars Hellsten, Jeff Fanjoy,
    and MatrixSoft(tm).

    This file is part of the MSCOMMON library.

    MSCOMMON is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    MSCOMMON is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MSCOMMON; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)


INTERFACE

USES  CRT,           { TP's CRT Unit }
      MISC1,         { MatrixSoft miscellaneous unit }
      MSTRINGS,      { MatrixSoft strings unit }
      CURSOR;        { Cursor Manipulation Unit }

CONST Standard = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUV'+
                 'WXYZ1234567890~!@#$%^&*()-+\[]{};:`''".,/<> =_?|';
      Alpha    = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
      HighBit  = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUV'+
                 'WXYZ1234567890~!@#$%^&*()-+\[]{};:`''".,/<> =_?|'+
                 ''+
                 ''+
                 '';
      Filename = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUV'+
                 'WXYZ1234567890~!@#$%^&()-_{}.';
      Filespec = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUV'+
                 'WXYZ1234567890~!@#$%^&()-_{}.?*';
      Filepath = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUV'+
                 'WXYZ1234567890~!@#$%^&()-_{}.?*:\';
      Number   = '1234567890';


TYPE  KeyInputConfigRec = RECORD
         MaskCh       : Char;          { Mask input - #0=No }
         Attr         : Byte;          { Attribute - normal editing }
         HighAttr     : Byte;          { Attribute - highlighted text }
         BackGroundCh : Char;          { Background character }
         LeftCh       : Char;          { More to the left indicator }
         RightCh      : Char;          { More to the right indicator }
         AllowMore    : Boolean;       { Allow more to left/right }
      END;

CONST KeyInputConfig   : KeyInputConfigRec =
         (MaskCh       : #0;
          Attr         : $1B;
          HighAttr     : $1B;
          BackgroundCh : '';
          LeftCh       : #17;
          RightCh      : #16);


PROCEDURE GetInput(VAR NewString : String;   { Variable being edited }
                   WhatWas       : String;   { "Old" Value -- being edited }
                   InputType     : String;   { Input type -- from TInput }
                   Len           : Byte;     { Maximum Characters f/string }
                   XPos,                     { X Start Position }
                   YPos          : Byte;     { Y Start Position }
                   FieldLen      : Byte;     { Input space avail (0=unlimited) }
                   Caps          : Boolean); { Force CAPS? }


IMPLEMENTATION


PROCEDURE GetInput(VAR NewString : String;   { Variable being edited          }
                   WhatWas       : String;   { "Old" Value -- being edited    }
                   InputType     : String;   { Input type -- from TInput      }
                   Len           : Byte;     { Maximum Characters f/string }
                   XPos,                     { X Start Position               }
                   YPos          : Byte;     { Y Start Position               }
                   FieldLen      : Byte;     { Input space avail (0=unlimited) }
                   Caps          : Boolean); { Force CAPS? }

VAR  Ch         : Char;       { Reads Characters }
     StrPos     : Byte;       { Position where cursor is in string }
     FirstChar,               { Whether is first char entered }
     InsertOn,                { Insert or overstrike mode }
     NoAdd      : Boolean;    { Whether to add key to string }

     FieldStart : Byte;
     FieldEnd   : Byte;


   PROCEDURE Ding;
   { Makes sound to tell user invalid key was pressed }
   BEGIN
      {$IFDEF OS2}
      PlaySound(300,30);
      {$ELSE}
      Sound(300);
      RealDelay(30);
      NoSound;
      {$ENDIF}
   END;

   PROCEDURE ToggleInsert(Ins:Boolean);
   BEGIN
      InsertOn := Ins;
      IF InsertOn
         THEN SetCursor(cmUnderline)
         ELSE SetCursor(cmBlock);
   END;

   PROCEDURE FlushKBuff;
   BEGIN
      WHILE KeyPressed DO Readkey;
   END;

   FUNCTION PosInField:Byte;
   BEGIN
      PosInField := Length(NewString)-FieldStart+1;
   END;

   PROCEDURE WriteBackground(ToPos:Byte);
   BEGIN
      IF Length(NewString) >= FieldEnd THEN Exit; { Max length }
      IF (ToPos <= Length(NewString)) OR (ToPos >= Len) THEN ToPos := Len;
      IF ToPos > FieldEnd THEN ToPos := FieldEnd;
      GotoXY(XPos+PosInField,YPos);
      TextAttr := KeyInputConfig.Attr;
      Write(RepChar(KeyInputConfig.BackgroundCh,ToPos-Length(NewString)));
   END;

   PROCEDURE WriteString(FromPos,ToPos:Byte);
   BEGIN
      IF FromPos > ToPos THEN Exit;
      {...}
      IF FromPos < FieldStart THEN FromPos := FieldStart;
      IF ToPos > FieldEnd THEN ToPos := FieldEnd;
      {...}
      GotoXY(XPos+(FromPos-FieldStart),YPos);
      TextAttr := KeyInputConfig.HighAttr;
      IF KeyInputConfig.MaskCh <> #0
         THEN Write(RepChar(KeyInputConfig.MaskCh,ToPos-FromPos+1))
         ELSE Write(Copy(NewString,FromPos,ToPos-FromPos+1));
   END;

   PROCEDURE MoveFieldLeft;
   BEGIN
      IF StrPos < FieldStart THEN
         BEGIN
            FieldStart := StrPos;
            FieldEnd := FieldStart+FieldLen-1;
            WriteBackground(Len);
            WriteString(StrPos,Length(NewString));
         END;
   END;

   PROCEDURE MoveFieldRight;
   BEGIN
      IF (StrPos > FieldEnd) THEN
         BEGIN
            IF StrPos <= Len THEN FieldEnd := StrPos ELSE FieldEnd := StrPos-1;
            IF FieldEnd < FieldLen THEN FieldEnd := FieldLen;
            FieldStart := FieldEnd-FieldLen+1;
            WriteBackground(Len);
            WriteString(FieldStart,Length(NewString));
         END;
   END;

   PROCEDURE DeleteChar;
   BEGIN
      IF (StrPos <= Length(NewString)) AND (StrPos > 0) THEN
         BEGIN
            Delete(NewString,StrPos,1);
            WriteString(StrPos,Length(NewString));
            WriteBackground(Length(NewString)+1);
            GotoXY(XPos+(StrPos-FieldStart),YPos);
         END;
   END;

   PROCEDURE Init;
   BEGIN
      SetCursor(cmOn);
      InsertOn := TRUE;
      FirstChar := TRUE;
      NewString := '';
      FlushKBuff;
      Ch := #0;
      NewString := WhatWas;
      StrPos := Length(WhatWas)+1;

      IF FieldLen = 0 THEN FieldLen := Len;
      FieldEnd := Length(NewString);
      IF FieldEnd < FieldLen THEN FieldEnd := FieldLen;
      FieldStart := FieldEnd-FieldLen+1;

      WriteBackground(Len);
      WriteString(1,Length(NewString));
   END;

   PROCEDURE Handle_Backspace;
   BEGIN
      IF StrPos <= 1
         THEN Ding
         ELSE BEGIN
               IF FirstChar THEN FirstChar := FALSE;
               Dec(StrPos);
               Delete(NewString,StrPos,1);
               MoveFieldLeft;
               WriteString(StrPos,Length(NewString));
               WriteBackground(Length(NewString)+1);
               NoAdd := TRUE;
            END;
   END;

   PROCEDURE ProcFuncKey;
   BEGIN
      NoAdd := TRUE;
      IF FirstChar THEN FirstChar := FALSE;
      ch := Upcase(ReadKey);
      CASE ch OF
{ -> }   #77 : IF StrPos <= Length(NewString) THEN Inc(StrPos) ELSE Ding;
{ <- }   #75 : IF StrPos > 1 THEN Dec(StrPos) ELSE Ding;
{ Home } #71 : StrPos := 1;
{ End }  #79 : StrPos := Length(NewString)+1;
{ INS }  #82 : ToggleInsert(NOT InsertOn);
{ DEL }  #83 : DeleteChar;
         ELSE Ding;
      END;
      FlushKBuff;
   END;

   PROCEDURE ProcKey;
   BEGIN
      CASE Ch OF
         #0 : ProcFuncKey;
{ BKSP } #8 : Handle_Backspace;
{ ESC } #27 : BEGIN
                 NoAdd := TRUE;
                 NewString := WhatWas;
              END;
{ ^Y }  #25 : BEGIN
                 FirstChar := FALSE;
                 NoAdd := TRUE;
                 NewString := '';
                 StrPos := 1;
                 FieldEnd := FieldLen;
                 FieldStart := 1;
                 WriteBackground(Len);
              END;
        #13 : NoAdd := TRUE;
      END;
      { Can characters be added?
        Yes - Is the character a backspace?
              No - Is there room for more chars or is it the first char?
                   Yes - Add character }

      IF (NoAdd=FALSE) AND (ch <> #8) THEN
         IF ((Length(NewString) < Len) OR ((Length(NewString) <= Len) AND (InsertOn=FALSE))) OR FirstChar THEN BEGIN
            IF FirstChar THEN
               BEGIN
                  FirstChar := FALSE;
                  NewString := '';
                  FieldEnd := FieldLen;
                  FieldStart := 1;
                  StrPos := 1;
                  WriteBackground(Len);
               END;
            IF InsertOn
               THEN BEGIN
                     Insert(Ch,NewString,StrPos);
                     WriteString(StrPos,Length(NewString));
                     Inc(StrPos);
                  END
               ELSE IF (Length(NewString) < Len) OR ((Length(NewString)=Len) AND (StrPos <= Len)) THEN
                  BEGIN
                     IF Length(NewString) < StrPos THEN NewString[0] := Chr(StrPos);
                     NewString[StrPos] := ch;
                     WriteString(StrPos,StrPos);
                     Inc(StrPos);
                  END
         END;
   END;

BEGIN
   Init;
   WHILE (Ch <> #13) AND (Ch <> #27) DO
      BEGIN
         MoveFieldLeft;  { Check whether input field needs to be moved }
         MoveFieldRight; { left or right, relative to the string }

         GotoXY(XPos+(StrPos-FieldStart),YPos);
         NoAdd := FALSE;
         ch := ReadKey;
         IF Caps THEN ch := Upcase(ch);
         IF (Pos(Ch,InputType) > 0) OR (Ch IN [#13,#27,#0,#8,#25]) THEN ProcKey ELSE Ding;
      END;
   FlushKBuff;
   SetCursor(cmUnderline);
   SetCursor(cmOn);
END;


END.

