(* 

    FASTWOS2 - OS/2 Screen Save/Restore Routines 

    MSCOMMON is Copyright (C) 1993-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of the MSCOMMON library.

    MSCOMMON is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    MSCOMMON is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MSCOMMON; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)


USES OS2BASE,CRT;


PROCEDURE WriteFast(x,y:Byte; s:String; Attr:Byte);
BEGIN
   VioWrtCharStrAtt(@s[1],Length(s),y-1,x-1,Attr,0);
END;
{
VAR Screen:^ScreenType; i:Byte;

   New(Screen);
   ReadScreen(Screen^);
   FOR i := 1 TO Length(s) DO
      BEGIN
         Screen^.Pos[y,x+i-1].Ch := s[i];
         Screen^.Pos[y,x+i-1].Attr := Attr;
      END;
   WriteScreen(Screen^);
   Dispose(Screen);
END;
}

PROCEDURE WriteScreen(VAR s:ScreenType);
VAR TMin,TMax:Word;
BEGIN
   TMin := WindMin; WindMin := 0;
   TMax := WindMax; WindMax := (24 SHL 8)+79;

   VioWrtCellStr(@s.Pos,4000,0,0,0);

   WindMin := TMin;
   WindMax := TMax;
END;


PROCEDURE ReadScreen(VAR s:ScreenType);
VAR k,TMin,TMax:Word;
BEGIN
   TMin := WindMin; WindMin := 0;
   TMax := WindMax; WindMax := (24 SHL 8)+79;

   k := 1920;
   VioReadCellStr(s.Pos,k,0,0,0);
   k:=2180;
   VioReadCellStr(s.Pos[13,1],k,12,0,0);

   WindMin := TMin;
   WindMax := TMax;
END;


PROCEDURE FastClr(ch:Char; x1,y1,x2,y2,Attr:Byte);
VAR s:String; lnum:Byte;
BEGIN
   IF x2 < x1 THEN Exit;
   IF Y2 < y1 THEN Exit;
   s := '';
   FOR LNum := x1 TO x2 DO
      s := s+ch;
   FOR LNum := y1 TO y2 DO
      WriteFast(x1,LNum,s,Attr);
END;


PROCEDURE HighIntensity(State:Boolean);
VAR Intensity:VioIntensity;
BEGIN
   Intensity.cb := 6; { Structure size }
   Intensity.rType := 2; { 2 = set intensity/blink }
   IF State THEN Intensity.fs := 1 ELSE Intensity.fs := 0;
   VioSetState(Intensity,0);
END;


PROCEDURE ScreenScroll(Direction:ScrollType; Lines,Top,Bot,SCol,FCol,FillAttr: Byte);
VAR i:Byte; w:Word;
BEGIN
   w := 0;
   IF (Direction=Up)
      THEN VioScrollUp(Top,SCol,Bot,FCol,Lines,w,0)
      ELSE VioScrollDn(Top,SCol,Bot,FCol,Lines,w,0);
END;
