{$R-,S+,I+,D-,F-,V-,B-,N-,L+ }
{$M 65520,0,655360 }

UNIT TPansi;
INTERFACE
USES Crt, Dos;

CONST
   ansi_on: BOOLEAN = TRUE;
   ansi_wrap_on: BOOLEAN = TRUE;

 VAR
   ANSI: TEXT;

PROCEDURE AssignANSI(VAR f: TEXT);

IMPLEMENTATION

CONST
   savedcp: BOOLEAN = FALSE;

VAR
   r: Registers;
   savedx,
   savedy: BYTE;

PROCEDURE GetXY(VAR x, y: INTEGER);
BEGIN
Inline($B8/$00/$03/ { mov ax,$0300  }
       $31/$DB/     { xor bx,bx     }
       $CD/$10/     { int $10       }
       $31/$C0/     { xor ax,ax     }
       $88/$D0/     { mov al,dl     }
       $C4/$BE/>X/  { les di,>x[bp] }
       $AB/         { stosw         }
       $88/$F0/     { mov al,dh     }
       $C4/$BE/>Y/  { les di,>y[bp] }
       $AB)         { stosw         }
END;

PROCEDURE SetXY(x, y: INTEGER);
BEGIN
  Inline($8B/$9E/>X/            {   mov       bx,>x[bp]             }
         $8B/$86/>Y/            {   mov       ax,>y[bp]             }
         $3E/$8B/$0E/>WINDMIN/  {ds:mov       cx,WORD PTR[>WindMin] }
         $3E/$8B/$16/>WINDMAX/  {ds:mov       dx,WORD PTR[>WindMax] }
         $88/$C7/               {   mov       bh,al                 }
         $38/$CB/               {   cmp       bl,cl                 }
         $73/$04/               {   jae       C0                    }
         $88/$CB/               {   mov       bl,cl                 }
         $EB/$06/               {   jmp short C1                    }
         $38/$D3/               {C0:cmp       bl,dl                 }
         $76/$02/               {   jbe       C1                    }
         $88/$D3/               {   mov       bl,dl                 }
         $38/$EF/               {C1:cmp       bh,ch                 }
         $73/$04/               {   jae       C2                    }
         $88/$EF/               {   mov       bh,ch                 }
         $EB/$06/               {   jmp short C3                    }
         $38/$F7/               {C2:cmp       bh,dh                 }
         $76/$02/               {   jbe       C3                    }
         $88/$F7/               {   mov       bh,dh                 }
         $89/$DA/               {C3:mov       dx,bx                 }
         $31/$DB/               {   xor       bx,bx                 }
         $B8/$00/$02/           {   mov       ax,$0200              }
         $CD/$10)               {   int       $10                   }
END;


PROCEDURE PutC(c: CHAR);
BEGIN
Inline($3E/$A0/>DIRECTVIDEO/   {     ds:mov   al,BYTE PTR[>DirectVideo] }
       $3C/$01/                {        cmp   al,1                      }
       $75/$5B/                {        jne   BIOS                      }
       $B8/$40/$00/            {        mov   ax,$0040                  }
       $8E/$C0/                {        mov   es,ax                     }
       $26/$8B/$1E/$50/$00/    {     es:mov   bx,WORD PTR[$0050]        }
       $26/$A1/$4A/$00/        {     es:mov   ax,WORD PTR[$004A]        }
       $31/$C9/                {        xor   cx,cx                     }
       $88/$F9/                {        mov   cl,bh                     }
       $F7/$E1/                {        mul   cx                        }
       $30/$FF/                {        xor   bh,bh                     }
       $01/$D8/                {        add   ax,bx                     }
       $D1/$E0/                {        shl   ax,1                      }
       $89/$C7/                {        mov   di,ax                     }
       $26/$A0/$49/$00/        {     es:mov   al,BYTE PTR[$0049]        }
       $3C/$07/                {        cmp   al,7                      }
       $75/$05/                {        jne   COLO                      }
       $B8/$00/$B0/            {        mov   ax,$B000                  }
       $EB/$03/                {        jmp   short MONO                }
       $B8/$00/$B8/            {COLO:   mov   ax,$B800                  }
       $8E/$C0/                {MONO:   mov   es,ax                     }
       $8A/$46/<C/             {        mov   al,<c[bp]                 }
       $3E/$8A/$26/>TEXTATTR/  {     ds:mov   ah,BYTE PTR[>TextAttr]    }
       $3E/$8A/$1E/>CHECKSNOW/ {     ds:mov   bl,BYTE PTR[>CheckSnow]   }
       $80/$FB/$01/            {        cmp   bl,1                      }
       $74/$04/                {        je    SLOW                      }
       $AB/                    {        stosw                           }
       $E9/$28/$00/            {        jmp   EXIT                      }
       $89/$C3/                {SLOW:   mov   bx,ax                     }
       $BA/$DA/$03/            {        mov   dx,$03DA                  }
       $EC/                    {HORZ:   in    al,dx                     }
       $D0/$D8/                {        rcr   al,1                      }
       $72/$FB/                {        jc    HORZ                      }
       $FA/                    {        cli                             }
       $EC/                    {VERT:   in    al,dx                     }
       $24/$09/                {        and   al,9                      }
       $75/$FB/                {        jnz   VERT                      }
       $89/$D8/                {        mov   ax,bx                     }
       $AB/                    {        stosw                           }
       $FB/                    {        sti                             }
       $E9/$11/$00/            {        jmp   EXIT                      }
       $B4/$09/                {BIOS:   mov   ah,$09                    }
       $8A/$46/<C/             {        mov   al,<c[bp]                 }
       $B7/$00/                {        mov   bh,0                      }
       $3E/$8A/$1E/>TEXTATTR/  {     ds:mov   bl,BYTE PTR[>TextAttr]    }
       $B9/$01/$00/            {        mov   cx,$0001                  }
       $CD/$10)                {        int   $10                       }
                               {EXIT:                                   }
END;

PROCEDURE Scroll;
BEGIN
Inline($3E/$A0/>DIRECTVIDEO/   {      ds:mov       al,BYTE PTR[>DirectVideo] }
       $3E/$8B/$0E/>WINDMIN/   {      ds:mov       cx,WORD PTR[>WindMin]     }
       $3E/$8B/$16/>WINDMAX/   {      ds:mov       dx,WORD PTR[>WindMax]     }
       $3C/$01/                {         cmp       al,1                      }
       $74/$03/                {         je        DIRECT                    }
       $E9/$A4/$00/            {         jmp       BIOS                      }
       $1E/                    {DIRECT:  push      ds                        }
       $31/$C0/                {         xor       ax,ax                     }
       $8E/$C0/                {         mov       es,ax                     }
       $26/$8B/$1E/$4A/$04/    {      es:mov       bx,WORD PTR[$044A]        }
       $88/$F0/                {         mov       al,dh                     }
       $28/$E8/                {         sub       al,ch                     }
       $50/                    {         push      ax                        }
       $88/$D0/                {         mov       al,dl                     }
       $28/$C8/                {         sub       al,cl                     }
       $FE/$C0/                {         inc       al                        }
       $50/                    {         push      ax                        }
       $88/$E8/                {         mov       al,ch                     }
       $F7/$E3/                {         mul       bx                        }
       $30/$ED/                {         xor       ch,ch                     }
       $01/$C8/                {         add       ax,cx                     }
       $D1/$E0/                {         shl       ax,1                      }
       $89/$C7/                {         mov       di,ax                     }
       $D1/$E3/                {         shl       bx,1                      }
       $01/$D8/                {         add       ax,bx                     }
       $89/$C6/                {         mov       si,ax                     }
       $B9/$00/$B0/            {         mov       cx,$B000                  }
       $26/$A0/$49/$04/        {      es:mov       al,BYTE PTR[$0449]        }
       $3C/$07/                {         cmp       al,7                      }
       $74/$04/                {         je        MONO                      }
       $81/$C1/$00/$08/        {         add       cx,$0800                  }
       $8E/$C1/                {MONO:    mov       es,cx                     }
       $FC/                    {         cld                                 }
       $59/                    {         pop       cx                        }
       $5A/                    {         pop       dx                        }
       $D1/$EB/                {         shr       bx,1                      }
       $29/$CB/                {         sub       bx,cx                     }
       $D1/$E3/                {         shl       bx,1                      }
       $3E/$A0/>CHECKSNOW/     {      ds:mov       al,BYTE PTR[>CheckSnow]   }
       $8C/$C0/                {         mov       ax,es                     }
       $8E/$D8/                {         mov       ds,ax                     }
       $3C/$01/                {         cmp       al,1                      }
       $75/$1F/                {         jne       FAST                      }
       $52/                    {SLOW0:   push      dx                        }
       $51/                    {         push      cx                        }
       $BA/$DA/$03/            {SLOW1:   mov       dx,$03DA                  }
       $EC/                    {HORZ:    in        al,dx                     }
       $D0/$D8/                {         rcr       al,1                      }
       $72/$FB/                {         jc        HORZ                      }
       $FA/                    {         cli                                 }
       $EC/                    {VERT:    in        al,dx                     }
       $24/$09/                {         and       al,9                      }
       $75/$FB/                {         jnz       VERT                      }
       $A5/                    {         movsw                               }
       $FB/                    {         sti                                 }
       $E2/$EE/                {         loop      SLOW1                     }
       $59/                    {         pop       cx                        }
       $5A/                    {         pop       dx                        }
       $01/$DE/                {         add       si,bx                     }
       $01/$DF/                {         add       di,bx                     }
       $4A/                    {         dec       dx                        }
       $74/$0D/                {         jz        FILL                      }
       $EB/$E1/                {         jmp short SLOW0                     }
       $51/                    {FAST:    push      cx                        }
       $F2/$A5/                {         rep movsw                           }
       $59/                    {         pop       cx                        }
       $01/$DF/                {         add       di,bx                     }
       $01/$DE/                {         add       si,bx                     }
       $4A/                    {         dec       dx                        }
       $75/$F5/                {         jnz       FAST                      }
       $1F/                    {FILL:    pop       ds                        }
       $3E/$8A/$26/>TEXTATTR/  {      ds:mov       ah,BYTE PTR[>TextAttr]    }
       $B0/$20/                {         mov       al,' '                    }
       $3E/$8A/$1E/>CHECKSNOW/ {      ds:mov       bl,BYTE PTR[>CheckSnow]   }
       $80/$FB/$01/            {         cmp       bl,1                      }
       $75/$16/                {         jne       FAST1                     }
       $89/$C3/                {         mov       bx,ax                     }
       $BA/$DA/$03/            {         mov       dx,$03DA                  }
       $EC/                    {HORZ1:   in        al,dx                     }
       $D0/$D8/                {         rcr       al,1                      }
       $72/$FB/                {         jc        HORZ1                     }
       $FA/                    {         cli                                 }
       $EC/                    {VERT1:   in        al,dx                     }
       $24/$09/                {         and       al,9                      }
       $75/$FB/                {         jnz       VERT1                     }
       $AB/                    {         stosw                               }
       $FB/                    {         sti                                 }
       $E2/$F1/                {         loop      HORZ1                     }
       $EB/$0E/                {         jmp short DONE                      }
       $F2/$AB/                {FAST1:   rep stosw                           }
       $EB/$0A/                {         jmp short DONE                      }
       $B8/$01/$06/            {BIOS:    mov       ax,$0601                  }
       $3E/$8A/$3E/>TEXTATTR/  {      ds:mov       bh,BYTE PTR[>TextAttr]    }
       $CD/$10)                {         int            $10                  }
                               {DONE:                                        }
END;

PROCEDURE CarriageReturn;
(* Moves cursor to the left window border of the current row *)
VAR
   x, y: INTEGER;
BEGIN
   GetXY(x,y);
   IF (x > Lo(WindMin)) THEN
      SetXY(Lo(WindMin),y)
END;


PROCEDURE LineFeed;
(* If above the last window row, moves the cursor down one line *)
(* else stays on bottom line and scrolls the window up one line *)
VAR
   x, y: INTEGER;
BEGIN
   GetXY(x,y);
   IF (y < Hi(WindMax)) THEN
      SetXY(x,Succ(y))
   ELSE
      Scroll
END;

PROCEDURE Bell;
(* Sounds the speaker *)
BEGIN
   Sound(440);
   Delay(100);
   NoSound
END;

PROCEDURE BackSpace;
(* Moves the cursor back one space, if not already at left border *)
VAR
   x, y: INTEGER;
BEGIN
   GetXY(x,y);
   IF (x > Lo(WindMin)) THEN
      SetXY(Pred(x),y)
END;


PROCEDURE Character(c: CHAR);
(* Outputs a character at the current cursor position. If at the right  *)
(* window border, and WRAP IS ON (default), it will generate a carriage *)
(* return and linefeed.                                                 *)
VAR
   x, y: INTEGER;
BEGIN
   GetXY(x,y);
   PutC(c);
   IF (x < Lo(WindMax)) THEN
      SetXY(Succ(x),y)
   ELSE IF (ansi_wrap_on) THEN
      IF (y < Hi(WindMax)) THEN
         SetXY(Lo(WindMin),Succ(y))
      ELSE
      BEGIN
         Scroll;
         SetXY(Lo(WindMin),y)
      END
END;

FUNCTION GetNumber(VAR s: STRING): BYTE;
VAR
   b: BYTE;
BEGIN
   IF (Length(s) > 0) THEN
   BEGIN
      b := BYTE(s[1]);
      Delete(s,1,1)
   END
   ELSE
      b := 0;
{$IFDEF DEBUG }
   Character(Chr(b DIV 10 + $30));
   Character(Chr(b MOD 10 + $30));
   Character(' ');
{$ENDIF}
   GetNumber := b
END;

PROCEDURE AnsiCUP(VAR s: STRING);
VAR
   x, y: BYTE;
BEGIN
   y := GetNumber(s);
   x := GetNumber(s);
   IF (y = 0) THEN
      y := 1
   ELSE IF (y > (Hi(WindMax) - Hi(WindMin) + 1)) THEN
   BEGIN
      Character('H');
      Exit
   END;
   IF (x = 0) THEN
      x := 1
   ELSE IF (x > (Lo(WindMax) - Lo(WindMin) + 1)) THEN
   BEGIN
      Character('H');
      Exit
   END;
   GotoXY(x,y)
END;

PROCEDURE AnsiHVP(VAR s: STRING);
VAR
   x, y: BYTE;
BEGIN
   IF (Length(s) < 2) THEN
      Exit;
   y := GetNumber(s);
   x := GetNumber(s);
   IF (y = 0) THEN
      y := 1
   ELSE IF (y > (Hi(WindMax) - Hi(WindMin) + 1)) THEN
   BEGIN
      Character('F');
      Exit
   END;
   IF (x = 0) THEN
      x := 1
   ELSE IF (x > (Lo(WindMax) - Lo(WindMin) + 1)) THEN
   BEGIN
      Character('F');
      Exit
   END;
   GotoXY(x,y)
END;

PROCEDURE AnsiCUU(VAR s: STRING);
VAR
   x, y, b: BYTE;
BEGIN
   x := WhereX;
   y := WhereY;
   b := GetNumber(s);
   IF (b = 0) THEN
      b := 1;
   IF (b >= y) THEN
      y := 1
   ELSE
      y := y - b;
   GotoXY(x,y)
END;

PROCEDURE AnsiCUD(VAR s: STRING);
VAR
   x, y, b: BYTE;
BEGIN
   x := WhereX;
   y := WhereY;
   b := GetNumber(s);
   IF (b = 0) THEN
      b := 1;
   IF (b >= (Hi(WindMax) - Hi(WindMin) + 1 - y)) THEN
      y := (Hi(WindMax) - Hi(WindMin) + 1)
   ELSE
      y := y + b;
   GotoXY(x,y)
END;

PROCEDURE AnsiCUB(VAR s: STRING);
VAR
   x, y, b: BYTE;
BEGIN
   x := WhereX;
   y := WhereY;
   b := GetNumber(s);
   IF (b = 0) THEN
      b := 1;
   IF (b >= x) THEN
      x := 1
   ELSE
      x := x - b;
   GotoXY(x,y)
END;

PROCEDURE AnsiCUF(VAR s: STRING);
VAR
   x, y, b: BYTE;
BEGIN
   x := WhereX;
   y := WhereY;
   b := GetNumber(s);
   IF (b = 0) THEN
      b := 1;
   IF (b >= (Lo(WindMax) - Lo(WindMin) + 1 - x)) THEN
      x := (Lo(WindMax) - Lo(WindMin) + 1)
   ELSE
      x := x + b;
   GotoXY(x,y)
END;

PROCEDURE AnsiSCP(VAR s: STRING);
BEGIN
   savedx := WhereX;
   savedy := WhereY;
   savedcp := TRUE
END;

PROCEDURE AnsiRCP(VAR s: STRING);
BEGIN
   IF (savedcp) THEN
      GotoXY(savedx,savedy)
END;

PROCEDURE AnsiDSR(VAR s: STRING);
BEGIN
   AnsiRCP(s)
END;

PROCEDURE AnsiED(VAR s: STRING);
BEGIN
   IF (GetNumber(s) = 2) THEN
      ClrScr
   ELSE
      Character('J')
END;

PROCEDURE AnsiEL(VAR s: STRING);
BEGIN
   ClrEol
END;

PROCEDURE AnsiSM(VAR s: STRING);
VAR
   b: BYTE;
BEGIN
   b := GetNumber(s);
   IF (b = 7) THEN
      ansi_wrap_on := TRUE
   ELSE
      Character('h')
END;

PROCEDURE AnsiRM(VAR s: STRING);
VAR
   b: BYTE;
BEGIN
   b := GetNumber(s);

   IF (b = 7) THEN
      ansi_wrap_on := FALSE
   ELSE
      Character('l')
END;

PROCEDURE AnsiSGR(VAR s: STRING);
VAR
   n: BYTE;
BEGIN
   REPEAT
      n := GetNumber(s);
      CASE n OF
         0 : TextAttr := $07;
         1 : TextAttr := TextAttr OR 8;
         2 : TextAttr := TextAttr AND (NOT 8);
         5 : TextAttr := TextAttr OR 128;
         6 : TextAttr := TextAttr OR 128;
         7 : TextAttr := (TextAttr AND 136 OR $70);
         8 : TextAttr := (TextAttr AND 136);
         30: TextAttr := TextAttr AND 248 OR Black;
         31: TextAttr := TextAttr AND 248 OR Red;
         32: TextAttr := TextAttr AND 248 OR Green;
         33: TextAttr := TextAttr AND 248 OR Brown;
         34: TextAttr := TextAttr AND 248 OR Blue;
         35: TextAttr := TextAttr AND 248 OR Magenta;
         36: TextAttr := TextAttr AND 248 OR Cyan;
         37: TextAttr := TextAttr AND 248 OR LightGray;
         40: TextAttr := TextAttr AND 143 OR (Black SHL 4);
         41: TextAttr := TextAttr AND 143 OR (Red SHL 4);
         42: TextAttr := TextAttr AND 143 OR (Green SHL 4);
         43: TextAttr := TextAttr AND 143 OR (Brown SHL 4);
         44: TextAttr := TextAttr AND 143 OR (Blue SHL 4);
         45: TextAttr := TextAttr AND 143 OR (Magenta SHL 4);
         46: TextAttr := TextAttr AND 143 OR (Cyan SHL 4);
         47: TextAttr := TextAttr AND 143 OR (LightGray SHL 4)
      END
   UNTIL (Length(s) = 0)
END;


PROCEDURE AnsiOutput(c: CHAR);
CONST
   times10: BOOLEAN = FALSE;
   isansi: BOOLEAN = FALSE;
   ansis: STRING = '';
   lastc: CHAR = #0;
   ansic: BYTE = 0;
BEGIN
   IF (isansi) AND (ansi_on) THEN
   BEGIN
      IF (c IN ['H','F','A'..'D','s','u','J','K','m','h','l']) THEN
      BEGIN
         IF (Length(ansis) < 255) THEN
            ansis := ansis + CHAR(ansic);
         CASE c OF
            'H': AnsiCUP(ansis);
            'F': AnsiHVP(ansis);
            'A': AnsiCUU(ansis);
            'B': AnsiCUD(ansis);
            'C': AnsiCUF(ansis);
            'D': AnsiCUB(ansis);
            's': AnsiSCP(ansis);
            'u': AnsiRCP(ansis);
            'J': AnsiED (ansis);
            'K': AnsiEL (ansis);
            'm': AnsiSGR(ansis);
            'h': AnsiSM (ansis);
            'l': AnsiRM (ansis)
         END;
         ansis := '';
         ansic := 0;
         times10 := FALSE;
         isansi := FALSE
      END
      ELSE IF (c IN ['0'..'9']) THEN
      BEGIN
         IF (times10) THEN
         BEGIN
            ansic := (ansic * 10) + (BYTE(c) - $30);
            times10 := FALSE
         END
         ELSE
         BEGIN
            times10 := TRUE;
            ansic := BYTE(c) - $30
         END
      END
      ELSE IF (c = ';') THEN
      BEGIN
         IF (Length(ansis) < 255) THEN
            ansis := ansis + CHAR(ansic);
         ansic := 0;
         times10 := FALSE
      END
      ELSE
      BEGIN
         ansis := '';
         ansic := 0;
         times10 := FALSE;
         isansi := FALSE
      END;
      lastc := c
   END
   ELSE
   BEGIN
      IF (c < ' ') THEN
      CASE c OF
         #7 : Bell;
         #8 : BackSpace;
         #10: LineFeed;
         #13: CarriageReturn;
         #27: IF (lastc = c) THEN
                 Character(^[)
      END
      ELSE IF (lastc = ^[) THEN
         IF (c = '[') and (ansi_on) THEN
         BEGIN
            isansi := TRUE;
            ansis := '';
            times10 := FALSE;
            ansic := 0
         END
         ELSE
         BEGIN
            Character(^[);
            Character(c)
         END
      ELSE
         Character(c)
   END;
   lastc := c
END;


PROCEDURE SetSnow;
BEGIN
Inline($3E/$A0/>DIRECTVIDEO/ {      ds:mov       al,BYTE PTR[>DirectVideo] }
       $3C/$01/              {         cmp       al,1                      }
       $74/$07/              {         jz        DIRECT                    }
       $B8/$00/$0F/          {         mov       ax,$0F00                  }
       $CD/$10/              {         int            $10                  }
       $EB/$08/              {         jmp short CHKMODE                   }
       $31/$C0/              {DIRECT:  xor       ax,ax                     }
       $8E/$C0/              {         mov       es,ax                     }
       $26/$A0/$49/$04/      {      es:mov       al,BYTE PTR[$0449]        }
       $3C/$07/              {CHKMODE: cmp       al,7                      }
       $74/$0C/              {         je        SETFAST                   }
       $B4/$12/              {         mov       ah,$12                    }
       $BB/$10/$FF/          {         mov       bx,$FF10                  }
       $CD/$10/              {         int            $10                  }
       $80/$EF/$FF/          {         sub       bh,$FF                    }
       $74/$04/              {         jz        NOTFAST                   }
       $31/$C0/              {SETFAST: xor       ax,ax                     }
       $EB/$02/              {         jmp short SET                       }
       $B0/$01/              {NOTFAST: mov       al,$01                    }
       $3E/$A2/>CHECKSNOW)   {SET:  ds:mov       BYTE PTR[>CheckSnow],al   }
END;


{$F+}

FUNCTION CloseANSI(VAR t: TextRec): INTEGER;
BEGIN
   t.Mode := fmClosed;
   CloseANSI := 0
END;


FUNCTION SendANSI(VAR t: TextRec): INTEGER;
VAR
   p: WORD;
BEGIN
   WITH t DO
   BEGIN
      IF (Mode = fmOutput) THEN
      BEGIN
         p := 0;
         WHILE (p < BufPos) DO
         BEGIN
            AnsiOutput(BufPtr^[p]);
            Inc(p)
         END;
         BufPos := 0;
         SendANSI := 0
      END
      ELSE IF (Mode = fmClosed) THEN
         SendANSI := 103
      ELSE
         SendANSI := 104
   END
END;

FUNCTION OpenANSI(VAR t: TextRec): INTEGER;
BEGIN
   WITH t DO
   BEGIN
      Mode := fmOutput;
      BufPos := 0;
      InOutFunc := @SendANSI;
      FlushFunc := @SendANSI;
      CloseFunc := @CloseANSI;
      OpenANSI := 0
   END
END;


PROCEDURE AssignANSI(VAR f: TEXT);
BEGIN
   FillChar(f,SizeOf(TextRec),0);
   WITH TextRec(f) DO
   BEGIN
      Handle := $FFFF;
      Mode := fmClosed;
      BufPtr := @Buffer;
      BufSize := SizeOf(Buffer);
      OpenFunc := @OpenANSI
   END
END;

{$F-}

BEGIN
   AssignANSI(ANSI);
   ReSET(ANSI);
   SetSnow
END.


