Unit Genstr;

Interface
 Function  Valu(q:string):Integer;
 Procedure ClearString(Var s:String);
 Procedure DisplayADF(Filename : String);
 Function  Uppercase(Str : String) : String;
 Function  Match(Str1, Str2 : String) : Boolean;
 Function  Strr (N : LongInt) : string;
 Function  FileExist(FileName : String) : Boolean;
 Function  DeleteFile(FileName : string) : integer;
 Procedure Make_Directory (Directory: String);
 function  Direxist(d:string): boolean;
 Procedure VGA_SetBlink(BlinkMode : Boolean);
 Function  AltKey: Boolean;
 Function  LeadingZero(W : Word) : String;
 Procedure Set8x16Font;
 Function  Time: string; (* Returns the current Time *)
 Function  Date: string; (* Returns the current Date *)
 Function  Timer: word;  (* Returns the time (in minutes since midnight) *)
 Function  TimeTill(Time: word): word; (* Finds the amount of time until Time *)
 Function  TimeBetween(Time1, Time2: word): word;(* Finds the amount of time between Time1 and Time2 *)
 Function  Padstring(Outp : String;Number : Byte): String;

Implementation
uses crt,dos,io,protcomm;

Function Padstring(Outp : String;Number : Byte): String;
Var X : Byte;
Begin
 For X := 1 to (Number - Length(Outp)) do Outp := Outp + ' ';
 Padstring := Outp;
End;

Function ShiftState: Byte;
Var Regs: Registers;
Begin
  Regs.Ah:=2;
  Intr($16, Regs);
  ShiftState:=Regs.Al;
End;

Function AltKey: Boolean;
Begin
 AltKey := (ShiftState and 8)<>0;
End;

Function LeadingZero(W : Word) : String;
Var S : String;
Begin
 Str(w:0,S);
 If Length(s) = 1 then S := '0'+S;
 LeadingZero := S;
End;

PROCEDURE VGA_SetBlink      (BlinkMode : BOOLEAN); ASSEMBLER;
ASM
 MOV    DX,$03DA
 IN     AL,DX
 MOV    DX,$03C0
 MOV    AL,10h+20h
 OUT    DX,AL
 MOV    DX,$03C1
 IN     AL,DX
 MOV    DX,$03C0
 CMP    [BlinkMode],TRUE
 JE     @SetBlinkBit
@BlinkOff:
 AND    AL,NOT 008h
 JMP    @SetBlinkBit
@BlinkOn:
 OR     AL,008h
@SetBlinkBit:
 OUT    DX,AL
END;

Procedure Set8x16Font;assembler;
Asm
 mov dx,03c4h;mov ax,0100h;out dx,ax;mov dx,03c4h;mov ax,0301h;out dx,ax
 mov dx,03c2h;mov al,063h;out dx,al;mov dx,03c4h;mov ax,0300h;out dx,ax
 mov dx,03d4h;mov ax,4f09h;out dx,ax;
end;

Procedure DisplayADF(Filename : String);
Var    X : word;
 NumRead : Integer;
       F : File;
 ADF_Version  : Char;
 ADF_Pallette : Array[0..63,1..3] of Byte;
 ADF_Font     : Array[1..4096] of Char;
 ADF_Handle   : File;
 Regs : Registers;
Begin
 VGA_Setblink(False);
 Set8x16Font;
 asm mov ah,1;mov cx,2000h; int 10h end;  { No Cursor }
 Assign(F,Filename);
 Reset(F,1);
 Seek(F,0);
 BlockRead(F,ADF_Version,1);
 BlockRead(F,ADF_Pallette,Sizeof(ADF_Pallette));
 BlockRead(F,ADF_Font[1],4096);
 For X := 0 to 63 do
  Begin
   Port[$3c8] := X;
   Port[$3c9] := ADF_Pallette[X,1];
   Port[$3c9] := ADF_Pallette[X,2];
   Port[$3c9] := ADF_Pallette[X,3];
  End;
 Seek(F,4289);
 regs.bx:= 4096;
 regs.es:= seg(ADF_Font);
 regs.bp:= ofs(ADF_Font);
 regs.ax:= 4368;
 regs.cx:= 256;
 regs.dx:= 0;
 Intr(16, Regs);
 asm mov ah,1;mov cx,2000h; int 10h end;  { No Cursor }
 BlockRead(F,Mem[$b800:0000],Filesize(F)-4289);
 Close(F);
End;


Function valu(q:string):Integer;
Var i,s,pu:Integer;
    r:Real;
Begin
 valu:=0;
 If Length(q)=0 Then exit;
 If Not(q[1] In ['0'..'9','-']) Then exit;
 If Length(q)>5 Then exit;
 Val(q,r,s);
 If s<>0 Then exit;
 If (r<=32767.0) And (r>=-32767.0) Then valu:=Round(r)
End;

Procedure ClearString(Var s:String);
Begin
 FillChar(s,sizeof(s),0);
End;

Function Uppercase(Str : String) : String;
Var X : Byte;
Begin
 For X := 1 to Length(Str) do Str[X] := Upcase(Str[X]);
 Uppercase := Str;
End;

Function match(Str1, Str2 : String) : Boolean;
begin
 uppercase(str1);
 uppercase(str2);
 match := (Str1 = Str2);{CompareStr(Str1,Str2);}
end;

function Time: string;
var H, M, S, Hund: word;
    PM: char;
    Min: string;
begin
  PM:='a';
  GetTime(h,m,s,hund);
  if h > 12 then begin h := h - 12; PM:='p'; end;
  if h = 0 then h := 12;
  if m < 10 then min := '0'+Strr(m) else min := strr(m);
  Time:=Strr(h)+':'+min+pm;
end;

function Date: string;
var Day, Month, Year, DOW: word;
    temp, temp2: string;
begin
  GetDate(Year, Month, Day, DOW);
  temp2:=Strr(year);
  temp[1]:=temp2[3];
  temp[2]:=temp2[4];
  temp[0]:=chr(2);
  Date:=Strr(month)+'/'+Strr(Day)+'/'+temp;
end;

function Timer: word; assembler;
asm
 mov ah, 2Ch
 int 21h
 mov ax, cx
 mov bx, ax
 mov cl, 8
 shr ax, cl
 mov cx, 60
 mul cx
 xor bh, bh
 add ax, bx
end;

function TimeTill(Time: word): word;
var w: word;
begin
  w := timer;
  if time < w then
    time := time + 1440;
  TimeTill := time - w;
end;

function TimeBetween(Time1, Time2: word): word;
begin
  if Time2 < Time1 then
    Time2 := Time2 + 1440;
  TimeBetween := Time2 - Time1;
end;


{PROCEDURE AddStr(VAR STR : OpenString ; CONST ADD : STRING); ASSEMBLER;
ASM
  PUSH    DS
  LDS     SI,ADD
  LES     DI,STR
  CLD
  XOR     BH,BH
  MOV     BL,ES:[DI]
  LODSB
  MOV     AH,BYTE PTR STR-2
  ADD     AL,BL
  JC      @OVF
  CMP     AL,AH
  JBE     @OK
 @OVF:
  MOV     AL,AH
 @OK:
  STOSB
  XOR     CH,CH
  MOV     CL,AL
  SUB     CL,BL
  ADD     DI,BX
  REP     MOVSB
  POP     DS
END;

PROCEDURE AddChar(VAR STR : OpenString ; C : CHAR); ASSEMBLER;
ASM
  LES     DI,STR
  XOR     AH,AH
  MOV     AL,ES:[DI]
  CMP     AX,WORD PTR STR-2
  JAE     @OUT
  INC     AL
  JZ      @OUT
  MOV     ES:[DI],AL
  ADD     DI,AX
  MOV     AL,C
  STOSB
 @OUT:
END;}

Function Strr (N : LongInt) : string;
Var Q : string;
Begin
  Str (N, Q);
  Strr := Q;
End;

Function DeleteFile(FileName : string) : integer; assembler;
Asm
  push ds
  lds si,FileName
  inc byte ptr [si]
  mov bl,byte ptr [si]
  xor bh,bh
  mov dx,si
  inc dx
  mov byte ptr [si+bx],0
  mov ah,41h
  int 21h
  jc  @error
  xor ax,ax
@error:
  dec byte ptr [si]
  pop ds
End; { DeleteFile }

Function FileExist(FileName : String) : Boolean; ASSEMBLER;
Asm
  PUSH DS          {Save DS                         }
  LDS  SI,Filename {DS:SI => Filename               }
  XOR  BX,BX       {Clear BX                        }
  MOV  BL,[SI]     {BX = Length(Filename)           }
  INC  SI          {DS:SI => Filename[1]            }
  MOV  DX,SI       {DS:DX => Filename[1]            }
  MOV  [SI+BX],BH  {Append Ascii 0 to Filename      }
  MOV  AX,4300h    {Get Attribute Function Code     }
  INT  21h         {Get File Attributes             }
  MOV  AL,BH       {Default Result = FALSE          }
  ADC  CL,CL       {Attribute * 2 + Carry Flag      }
  AND  CL,31h      {Directory or VolumeID or Failed }
  JNZ  @@Done      {Yes - Exit                      }
  INC  AL          {No - Change Result to TRUE      }
@@Done:
  POP  DS          {Restore DS                      }
End; {FileExists}


Procedure Make_Directory (Directory: String);
Var
    Regs: Registers;
begin
  With Regs do
  begin
    Directory := Directory + chr(0);
    AX := $3900;
    DS := Seg(Directory[1]);
    DX := ofs(Directory[1]);
    MSDos(Dos.Registers(Regs));
  end;
end;

function direxist(d:string): boolean;
  var
    f   : file;
    attr: word;
    len : byte;
  begin
    len:= length(d);
    if (d[len] = '\') then         {if d has a trailing slash...         }
      dec(d[0]);                   {remove the trailing slash.           }
    d:= d + '\.';                  {add '\.' to d                        }
    assign(f,d);                   {assign d to f                        }
    getfattr(f,attr);              {get the attribute word               }
    direxist := ((attr and directory)=directory);
                                   {return true if attr is directory     }
  end;

end.

