Unit DataArea;

Interface

Uses Records;

 Type QuestionRec = Record
                     Desc   : String[15];
                     MCI    : String[2];
                     Length : 0..80;
                    End;
      AnswerRec = Record
                   Answer : String[80];
                   Length : 0..80;
                  End;
      DataAreaRec = Record
                     AreaName    : String[20];
                     Filename    : String[12]; { *.DAQ *.DAA}
                     ACS,AddACS  : String[20];
                     ListPrefix  : String[8]; { *.TOP, *.MID, *.END }
                     ShowAnsi    : String[12]; { *.SHW }
                     AddAnsi     : String[12]; { *.ADD }
                     AllowAnon   : Boolean;
                     StorMessage : Boolean;
                    End;

 Var AnswerF   : File of AnswerRec;   { DataAreaRec.Filename, Holds answers }
     QuestionF : File of QuestionRec;
     AreaF     : File of DataAreaRec; { Holds info on Data Areas }
     DAreaVar  : DataAreaRec;
     Answers   : Array[1..50] of AnswerRec;
     Questions : Array[1..50] of QuestionRec;

 Procedure MakeArea;
 Procedure KillArea(Number : Byte);
 Procedure EditArea(Number : Byte);
 Procedure ListAreas;
 Procedure InitArea(Number : Byte);

Implementation

Uses Crt,IO,GenStr;

Procedure AreaEditor(DArea : DataAreaRec;ANumber : Byte);
Const Lengths : Array[1..9] of Byte = (20,12,20,20,8,12,12,3,3);
Var CH : Char;
    X : Byte;
   Temp : Byte;
Begin
 AnsiClr;
 Multicolor('|08ķ'#13#10);
 Multicolor('|08 (|05A|08) |07Description     |08:                                                       '#13#10);
 Multicolor('|08 (|05B|08) |07Filename        |08:                                                       '#13#10);
 Multicolor('|08 (|05C|08) |07Area Access     |08:                                                       '#13#10);
 Multicolor('|08 (|05D|08) |07Add Access      |08:                                                       '#13#10);
 Multicolor('|08 (|05E|08) |07Listing Prefix  |08:                                                       '#13#10);
 Multicolor('|08 (|05F|08) |07Showing Ansi    |08:                                                       '#13#10);
 Multicolor('|08 (|05G|08) |07Adding Ansi     |08:                                                       '#13#10);
 Multicolor('|08 (|05H|08) |07Allow Anonymous |08:                                                       '#13#10);
 Multicolor('|08 (|05I|08) |07Store Message   |08:                                                       '#13#10);
 Multicolor('|08Ľ'#13#10);
 Ansicolor(7);
 GoXy(25,2);SWrite(Padstring(Darea.AreaName,20));
 GoXy(25,3);SWrite(Padstring(Darea.Filename,12));
 GoXy(25,4);SWrite(Padstring(Darea.ACS,20));
 GoXy(25,5);SWrite(Padstring(DArea.AddACS,20));
 GoXy(25,6);SWrite(Padstring(DArea.ListPrefix,8));
 GoXy(25,7);SWrite(Padstring(DArea.ShowAnsi,12));
 GoXy(25,8);SWrite(Padstring(DArea.AddAnsi,12));
 GoXy(25,9);If DArea.AllowAnon then SWrite('Yes') else SWRite('No ');
 GoXy(25,10);If DArea.StorMessage then SWrite('Yes') else SWRite('No ');
 GoXy(1,12);
 Multicolor('|15Se|07lec|08tion |07: ');
 Repeat
  GoXy(13,12);CH := Upcase(SReadKey);
  Temp := Ord(CH)-64;
  GoXy(25,1+temp);
  For X := 1 to Lengths[Temp] do SWrite(' ');
  GoXy(25,1+temp);
  Case Temp of
   1 : Begin
        SInput(DArea.AreaName,20,False,False,False,0);
        GoXy(25,2);SWrite(DArea.AreaName);
       End;
   2 : Begin
        SInput(DArea.Filename,12,True,True,False,0);
        GoXy(25,3);SWrite(DArea.FileName);
       End;
   3 : Begin
        SInput(DArea.ACS,20,False,False,False,0);
        GoXy(25,4);SWrite(DArea.ACS);
       End;
   4 : Begin
        SInput(DArea.AddACS,20,False,False,False,0);
        GoXy(25,5);SWrite(DArea.AddACS);
       End;
   5 : Begin
        SInput(DArea.ListPrefix,8,True,True,False,0);
        GoXy(25,6);SWrite(DArea.ListPrefix);
       End;
   6 : Begin
        SInput(DArea.ShowAnsi,12,True,True,False,0);
        GoXy(25,7);SWrite(DArea.ShowAnsi);
       End;
   7 : Begin
        SInput(DArea.AddAnsi,12,True,True,False,0);
        GoXy(25,8);SWrite(DArea.AddAnsi);
       End;
   8 : Begin
        asm xor DArea.AllowAnon,1 end;
        GoXy(25,9);If DArea.AllowAnon then SWrite('Yes') else SWRite('No ');
       End;
   9 : Begin
        asm xor DArea.StorMessage,1 end;
        GoXy(25,10);If DArea.StorMessage then SWrite('Yes') else SWRite('No ');
       End;
  End;
 Until Upcase(CH) = 'Q';
 GoXy(1,14);Multicolor('|15Sa|07ve D|08ata Area? ');
 If AnsiYn('|15|17 Yes ','|16|07 Yes ','|15|17 No ','|16|07 No ') then
  Begin
   Assign(AreaF,'DATAAREA.DAT');
   {$I-} Reset(AreaF); {$I+}
   If IOResult <> 0 then Rewrite(AreaF);
   Seek(AreaF,ANumber-1);
   Write(AreaF,DArea);
   Close(AreaF);
  End;
 SWriteln('');
 AnsiColor(7);
End;

Procedure Killarea(Number : Byte);
Begin
End;

Procedure MakeArea;
Var S : LongInt;
Begin
 FillChar(DareaVar,SizeOf(DareaVar),#0);
 Assign(AreaF,'DATAAREA.DAT');
 {$I-} Reset(AreaF); {$I+}
 If (IOResult <> 0) then Rewrite(AreaF);
 S := Filesize(AreaF);
 Close(AreaF);
 AreaEditor(DareaVar,S);
End;

Procedure EditArea(Number : Byte);
Var CH : Char;Num : String[2];Area : Byte;
Begin
 If Number = 0 then
  Begin
   Multicolor(#13#10'|07Area Number to Edit : ');
   Num := '';
   Repeat
    CH := SReadkey;
    If Ch in['0'..'9'] then If Length(Num) < 2 then
     Begin
      Num := Num + Ch;
      SWrite(CH);
     End;
    If Ch = #8 then If Length(Num) > 0 then
     Begin
      Delete(Num,Length(Num),1);
      SWrite(^H+' '+^H);
     End;
   Until CH = #13;
   Area := Valu(Num);
  End else Area := Number;
 if Area = 0 then Exit;
 Assign(AreaF,'DATAAREA.DAT');
 {$I-} Reset(AreaF); {$I+}
 If (IOResult <> 0) then EXit;
 If (Area > Filesize(AreaF)) then Begin Close(AreaF);Exit; End;
 Seek(AreaF,Area-1);
 Read(AreaF,DAreaVar);
 Close(AreaF);
 AreaEditor(DAreaVar,Area);
End;

Procedure ListAreas;
Var X : Byte;
Begin
 Assign(AreaF,'DATAAREA.DAT');
 {$I-} Reset(AreaF); {$I+}
 If IOResult <> 0 then
  Begin
   Multicolor('No Data Areas Exist!'#10#13);
   Exit;                                     {3}
  End;
 Swriteln(''#13#10);
 Multicolor('|07 #     Area Name                 Access               Filename '#10#13);
 Multicolor('|07'#10#13);
 For X := 1 to Filesize(AreaF) do
  Begin
   Seek(AreaF,X-1);
   Read(AreaF,DAreaVar);
   GoXy(2,WhereY);SWrite(Strr(X));
   GoXy(8,WhereY);SWrite(DAreaVar.AreaName);
   GoXy(34,WhereY);SWrite(DAreaVar.ACS);
   GoXy(55,WhereY);SWriteln(DAreaVar.Filename);
  End;
 Close(AreaF);
 Multicolor('|07'#10#13);
 SWriteln('');
 Animated_Holdscreen;
End;

Procedure InitArea(Number : Byte);
Begin
End;


End.