Unit Door;

Interface

uses records,io,genstr,execswap;

{Procedure Write_Dorinfo_Def(Realname : Boolean);
Procedure Write_PCboard_Sys(Realname : Boolean);}
Procedure Write_Tribbs_Sys(Path : String;Realname : Boolean);
Procedure Run_Door(Filename : String;DoorType : Byte;Realnames : Boolean);
Procedure Write_Door_Sys(Path : string;Realname : Boolean);    (* GAP's DOOR.SYS *)

Implementation

Uses Dos;

Procedure Write_Tribbs_Sys(Path : String;Realname : Boolean);
Var FP : Text;
Begin
 Assign(FP,Path+'TRIBBS.SYS');
 Rewrite(FP);
 Writeln(FP,Strr(User.ID));
 If Realname then Writeln(FP,User.RealName) else Writeln(FP,User.Alias);
 Writeln(FP,User.Password);
 Writeln(FP,User.MainLev);
 If User.XPerMode then Writeln(FP,'Y') else Writeln(FP,'N');
 If User.Ansi then Writeln(FP,'Y') else Writeln(FP,'N');
 Writeln(FP,Strr(User.TimeLeft));
 Writeln(FP,User.Phone);
 Writeln(FP,User.UserNote);
 Writeln(FP,User.BirthDate);
 Writeln(FP,Strr(Config.Nodenumber));
 Writeln(FP,Strr(Config.Comport));
 If Local then Writeln(FP,'0') else Writeln(FP,Stat.Baud_Rate);
 If Local then Writeln(FP,'0') else Writeln(FP,Config.Lockbaud);
 Writeln(FP,'Y');
 Writeln(FP,'Y');
 Writeln(FP,Config.LongName);
 Writeln(FP,'SysOp');
 Close(FP);
End;

Procedure Write_Door_Sys(Path : string;Realname : Boolean);    (* GAP's DOOR.SYS *)
Var FP : Text;
    I  : Integer;
    S  : String;
begin
 assign(fp,Path+'DOOR.SYS');
 rewrite(fp);
 if Local then writeln(fp,'COM'+strr(config.comport)+':') else writeln(fp,'COM0:');
 writeln(fp,stat.baud_rate);   { Baud }
 writeln(fp,' 8');  { Data Bits}
 writeln(fp,' 1');  { Stop Bits }
 writeln(fp,' N');  { Parity }
 writeln(fp,' Y');  { Y = Want Output to Screen }
 writeln(fp,' Y');
 writeln(fp,' Y');  { Able to Page? }
 writeln(fp,' N');  { Y = Alert SysOp }
 if (realname) then writeln(fp,user.realname) else writeln(fp,user.alias);
 writeln(fp,user.usernote);
 writeln(fp,copy(user.phone,1,3)+' '+copy(user.phone,5,8));
 writeln(fp,copy(user.phone,1,3)+' '+copy(user.phone,5,8));
 writeln(fp,user.password);
 writeln(fp,strr(user.mainlev));
 writeln(fp,strr(user.calls));
 writeln(fp,user.lastcall);
 writeln(fp,strr(trunc(user.timeleft*60)));
 writeln(fp,strr(trunc(user.timeleft)));
 if user.ansi then writeln(fp,'GR') else writeln(fp,'NG');
 writeln(fp,24);   { Page Length }
 writeln(fp,' N'); { Y = Advanced?? is door.sys for telegard only??!? :) }
 writeln(fp,user.flags);
 writeln(fp,'7');
 writeln(fp,'12/31/99');
 writeln(fp,' '+strr(user.id));
 writeln(fp,' X');
 writeln(fp,' '+strr(user.uploads));
 writeln(fp,' '+strr(user.downloads));
 writeln(fp,' '+strr(trunc(user.bytesdown/1024)));
 writeln(fp,' 999999');
 close(fp);
End;

Procedure Run_Door(Filename : String;DoorType : Byte;Realnames : Boolean);
Begin
 Case DoorType of
  1 : Write_Door_Sys(Config.Door_Dir,Realnames);
  2 : Write_TriBBS_Sys(Config.Door_dir,Realnames);
 End;
 SwapVectors;
 Execwithswap(GetEnv('COMSPEC'),'/C '+Filename);
 SwapVectors;
End;

End.