{$A+,B-,D-,E-,F+,I-,L-,N-,O+,R-,S-,V-}
(* Com Routines *added by chris hoppman* *)
unit common4;

interface

uses crt, dos, myio, common, timefunc;

procedure com_flush_recv;
procedure com_flush_send;
procedure com_purge_send;
function com_carrier:boolean;
function com_recv:char;
function com_isrecv_empty:boolean;
function com_issend_empty:boolean;
procedure com_send(c:char);
procedure com_set_speed(speed:longint);
procedure com_deinstall;
procedure com_install;
procedure CheckHangup;
procedure SerialOut(s:string);
function empty:boolean;
procedure dtr(status:boolean);

implementation

uses
  common1, common2, common3;

procedure com_flush_recv;
begin
  if not LocalIOOnly then begin
     asm
        cmp InWfcMenu,1
       je @TheEnd
        mov ah,0ah
        mov dx,FossilPort
        int 14h
       @TheEnd:
     end;
  end
  else while not (com_isrecv_empty) do WriteWFC(cinkey);
end;

procedure com_flush_send;
var
  r:longint;
begin
  r := timer + 5;
  while (r > timer) and (outcom and com_carrier) and (not com_issend_empty) do;
end;

procedure com_purge_send;
begin
   asm
      cmp LocalIOOnly,1
     je @TheEnd

      mov ah,09h
      mov dx,FossilPort
      int 14h

     @TheEnd:
   end;

end;

function com_carrier:boolean;
var dummy : byte;
begin
    asm
       cmp LocalIOOnly,1
      je  @TheEnd

       mov ah,03h
       mov dx,FossilPort
       int 14h
       mov dummy,al
      @TheEnd:
    end;
    com_carrier := ( Dummy and $80) = $80;
end;

function com_recv:char;
const notavil = $FFFF;
var
  dummy: byte;
  t_recvchar: boolean;
begin
  com_recv := #0;
  t_recvchar := false;
  asm
    cmp localioonly,1
    je @theend

    mov ah,0ch
    mov dx,FossilPort
    int 14h
    cmp ax,notavil
    je @theend

    mov ah,02h
    mov dx,FossilPort
    int 14h
    mov dummy,al
    mov t_recvchar,1
    @theend:
  end;

  if t_recvchar then com_recv := char(dummy);
end;


function com_isrecv_empty:boolean;
var dummy : byte;
begin
  {com_isrecv_empty := true;}
  asm
     cmp LocalIOOnly, 1
    je @TheEnd

     mov ah,03h
     mov dx,FossilPort
     int 14h
     mov dummy,ah

    @TheEnd:
  end;
  com_isrecv_empty := not ( (dummy and $01 ) = $01 );
end;


function com_issend_empty:boolean;
const TSRE=$40;
var dummy: byte;
begin
  {com_issend_empty := true;}
  asm
    cmp LocalIOOnly, 1
   je @TheEnd

    mov ah,03h
    mov dx, FossilPort
    int 14h
    mov dummy,ah
   @TheEnd:
  end;
  com_issend_empty := (( dummy and $40 ) = $40);
end;

{03h 061604 chris hoppman}
{0bh is a no wait send ;) faster }
{it was accepted go to the end}
{if char wasn't accepted go ahead and send with the}
      { send with wait wait }
procedure com_send(c:char);
begin
  asm
    cmp LocalIOOnly,1
   je @TheEnd

    mov ah,0Bh
    mov dx,FossilPort
    mov al,c
    int 14h
{   cmp ax,0001h
   je @theend

    mov ah,01h
    mov dx,FossilPort
    mov al,c
    int 14h}
   @TheEnd:
  end;
end;

procedure com_set_speed(speed:longint);
var t_al : byte;
begin
  if not LocalIOOnly then begin
     case Speed of
          300  :t_al :=  64;
          600  :t_al :=  96;
          1200 :t_al := 128;
          2400 :t_al := 160;
          4800 :t_al := 192;
          9600 :t_al := 224;
          19200:t_al :=  0;
     else
          t_al := 32;
     end;

     inc(t_al, 3);

     asm
       mov ah,00h
       mov al,t_al
       mov dx,FossilPort
       int 14h
     end;
  end;
end;

procedure com_deinstall;
begin
  if not LocalIOOnly then begin
    asm
      mov ah,05h
      mov dx,FossilPort
      int 14h
    end;
  end;
end;

procedure com_install;

  function driverinstalled:word; assembler;
  asm
    mov ah, 5
    mov dx, FossilPort
    pushf
    call interrupt14
    mov ah, 4
    pushf
    call interrupt14
  end;

begin
  FossilPort := liner.comport - 1;
  if localioonly then exit;

  if (driverinstalled <> $1954) then
      begin
        clrscr;
        writeln('Renegade requires a FOSSIL driver.');
        halt;
      end
    else
      asm
        xor al, al
        mov bl, liner.mflags
        and bl, 00000100b
        jz @label1
        mov al, 2
        @label1:
        and bl, 00000010b
        jz @label2
        add al, 9
        @label2:
        mov dx, FossilPort
        mov ah, $F
        pushf
        call interrupt14
      end;
  com_set_speed(Liner.InitBaud);
end;

procedure CheckHangup; assembler;
asm
  cmp localioonly, 1
  je @getout
  cmp outcom, 1
  jne @getout
  mov dx, Fossilport
  mov ah, 3
  pushf
  call interrupt14
  and al, 10000000b {test}
  jnz @getout
  mov Hangup, 1
  @getout:
end;

procedure SerialOut(s:string);
var
  t_di : word;
  t_cx : word;
  t_es : word;
  t_ax : word;
begin
  if outcom then begin
      repeat
         t_di := ofs(s[1]);
         t_cx := length(s);
         t_es := Seg(s[1]);
        asm
          mov ah,19h
          mov di,t_di
          mov cx,t_cx
          mov dx,FossilPort
          mov es,t_es
          int 14h
          mov t_ax,ax
        end;
        move(s[t_ax + 1], s[1],length(s) - t_ax);
        dec(s[0], t_ax);
      until (s='');
  end;
end;


function empty:boolean;
var t_ah : byte;
begin
  Empty := not keypressed;
  if (Incom) and (not keypressed) then begin
    asm
      mov dx,FossilPort
      mov ah,03h
      int 14h
      mov t_ah,ah
    end;
    Empty := not (t_ah and 1 = 1);
  end;
end;

procedure dtr(status:boolean);{true=raise,false=lower}
var t_al : byte;
begin

  if not LocalIOOnly then begin
    t_al := byte(status);
    asm
      mov ah,06h
      mov dx,FossilPort
      mov al,t_al
      int 14h
    end;
  end;

end;

end.
