Program Extended_Dat_Update;
{$M $4000,0,0}
Uses Dos, Crt;

{$I RECORDS.PAS}

Const
  MaxArray = 2000;

TYPE
  OldDescRec = record
    Descr : array[1..9] of string[50];
  end;

Var

 { Renegade Main .dat file }
  RenegadeDat               : GeneralRec;
  RenegadeDatF              : File of Generalrec;

 { File Bases }
  FBase                     : ulrec;
  FBaseF                    : File of ulrec;
  FBaseDirNames             : Array[0..MaxArray] of String[13];
  FBaseLoop                 : LongInt;

 { *.dir files }
  FDirs                     : ulfrec;
  FDirsf                    : File of ulfrec;
  FDirsLoop                 : LongInt;
  DirCount                  : LongInt;

 {Extended.dat Descriptions Old one and a New One}
  OldDesc                   : OldDescRec;
  OldDescF                  : File of OldDescRec;
  OldDescLoop               : LongInt;

  NewDesc                   : VerbRec;
  NewDescF                  : File of VerbRec;
  NewDescLoop               : LongInt;

 {Misc}
  DatFilePath    : String;
  TrashCount     : LongInt;
  BlankRecords   : array[1..2000] of String[5];
  WorkDir        : String;
  WorkingOnFile  : String;
  CmdLine        : String;

procedure gotoxyb(x,y:byte);
   begin
      gotoxy(x,y);
      write('                                                         ');
      gotoxy(x,y);
   end;

procedure gw(ch : char; str: string);
   begin
      case ch of
       '1' : begin
              gotoxyb(16,4);
              write(str);
           end;
       '2' : begin
              gotoxyb(16,6);
              write(str);
           end;
      '3' : begin
              gotoxyb(16,7);
              write(str);
           end;
      '4' : begin
              gotoxyb(16,8);
              write(str);
           end;
      end;
   end;

procedure showdesc(y : byte; str : string; new : boolean);
 var a : byte;

   procedure makespace;
      begin
        writeln('                                                                            ');
      end;
 begin
    if new then begin
       gotoxy(6,9);
       writeln('------------------------------------------------------------------------');
       for a := 0 to 9 do makespace;
    end
    else begin
       gotoxy(16,10+y);
       writeln(str);
    end;
 end;

function IntToStr( i : integer) : string;
 var s : string;
 begin
    s:='';
    Str(I, S);
    IntToStr := s;
 end;

procedure takeoutblanks(var str : string);
   var
   t : string;
   a : byte;
   ch : char;
   begin
      t := '';
      for a := 1 to length(str) do begin
          ch := str[a];
          if ch <> ' ' then T := T + Ch;
      end;
      str := t;
   end;

function DirExists(stDir : dirstr) : boolean;
   var
     woFattr : word;
     fiTemp  : file;
   begin
     assign(fiTemp, (stDir + '.'));
     getfattr(fiTemp, woFattr);
     if (doserror <> 0) then DirExists := false
     else DirExists := ((woFattr and directory) <> 0)
   end;


function FileExists( astr : string) : Boolean;
  var f : file;
  begin
    assign(f,astr);
    {$I-}reset(f);{$I+}
    if ioresult = 0 then FileExists := True
    else FileExists := False;
  end;

procedure SetupWorkDirectory( Var WorkDir : String);
  Var CurrentDir   : String;
  begin
    GetDir(0,CurrentDir);
    WorkDir := CurrentDir+'\work';
    if not DirExists( WorkDir ) then {$I-}MkDir(WorkDir);{$I+}

  end;

procedure  GetPathToRenegadeDat(Var DatFilePath : String; Par : String);
  begin
     If Par <> '' then DatFilePath := Par
     else DatFilePath := Getenv('RENEGADE');
     If DatFilePath = '' then
     begin
       writeln('Renegade y2ka2 -> v11-26D');
       writeln('-Error Renegade.dat isn''t found.');
       writeln('--Examples:');
       writeln('--update.exe Path_To_Renegade');
       writeln('--update.exe c:\rg');
       halt;
     end;
     if DatFilePath[Length(DatFilePath)] <> '\' then DatFilePath := DatFilePath + '\';
  end;

  Procedure Err( Reason : String);
     begin
        Writeln(Reason);
        Halt;
     end;

Procedure DrawScr;
  begin
    writeln;
    writeln('    Renegade y2ka2 File Base Updater -> 11-26.3 DOS');
    writeln('--------------------------------------------------------');
    writeln(' Progress    :');{4,16}
    writeln;
    writeln(' FBase       :');{6,16}
    writeln(' File Name   :');{7,16}
    writeln(' Ext Pointer :');{8,16}
  end;

Begin

  clrscr;
  GetPathToRenegadeDat(DatFilePath,ParamStr(1));
  SetupWorkDirectory(WorkDir);

 {Load Rengade.dat}
  Assign(RenegadeDatF,DatFilePath + 'renegade.dat');
   {$I-}reset(RenegadeDatF);{$I+}
   if ioresult <> 0 then Err('Error reading Renegade.dat');
   read(RenegadeDatF,RenegadeDat);
  close(RenegadeDatF);

  {Load the FBase}
   Assign(FBaseF,RenegadeDat.DataPath+'fbases.dat');
    {$I-}Reset(FBaseF);{$I+}
     if ioresult <> 0 then Err('Error reading fbases.dat');

   {Read all the *.dir into an array}
    for DirCount := 0 to (FileSize(FBaseF)-1) do
       begin
         Seek(FBaseF,TrashCount);
         Read(FBaseF,FBase);
         FBaseDirNames[TrashCount] := FBase.FileName+'.DIR';
       end;

  {Load Extended.dat}
   Assign(OldDescF,RenegadeDat.DataPath+'extended.dat');
   {$I-}Reset(OldDescF);{$I+}
     if ioresult <> 0 then Err('Error reading extended.dat');

  {Load a New Extended.dat}
   Assign(NewDescF,RenegadeDat.DataPath+'extended.new');
   Rewrite(NewDescF);

 {*Draw Screen *}
  DrawScr;

 {*Start the loop to read in the files in the *.dir files}
  gw('1','Startting loop for packing file bases.');
  NewDescLoop:=0;

  for FBaseLoop := 0 to (FileSize(FBaseF)-1) do
  begin

    gotoxy(28,6);write(IntToStr(FBaseLoop)+' of '+IntToStr((FileSize(FBaseF)-1)));
    gw('2',FBaseDirNames[FBaseLoop]);

    Assign(FDirsF,RenegadeDat.DataPath+FBaseDirNames[FBaseLoop]);
    Reset(FDirsF);

    {loop to read all the files}
    for FDirsLoop := 0 to (FileSize(FDirsF)-1) do
    begin

      Seek(FDirsF,FDirsLoop);
      Read(FDirsF,FDirs);

      gw('3',FDirs.FileName);

      If FDirs.vpointer <> -1 then
      begin

        gw( '4' , IntToStr( fdirs.vpointer ) );

        WorkingOnFile := FDirs.filename;
        TakeOutBlanks(WorkingOnFile);

        {This is where we should unzip the file_id.diz}
        {*unzip /o zipfile destpath files files}
        if not fileexists('unzip.exe') then Err('Error loading unzip.exe');
        CmdLine := FBase.dlpath+WorkingOnFile + ' ' + WorkDir + ' file_id.diz desc.sdi > nul';
        writeln(cmdline);
        SwapVectors;
         Exec('unzip.exe', CmdLine);
        SwapVectors;

        WhichDesc(FID);
        FiD := WorkDir+'\'+FiD
        assign(df,FiD);
        reset(df);
        LineCount := 0;
        while (not eof(df)) and (LineCount > 20) do
        begin
           if linecount > 0 then
           begin
              read(df,uhm);
              NewDesc
           end;
           inc(linecount);
        end;

        {read in the old description}
        Seek( OldDescF , FDirs.vpointer );
        Read( OldDescF , OldDesc );

        {make sure it isn't a blank extended.dat}
        If OldDesc.Descr[1] <> '' then
        begin

          {loop to add the stuff to the}
          gw('1','Transfering Description to the New Extended.dat');
          showdesc(0,'',true);
          gotoxy(16,10);writeln(FDirs.description);

          for OldDescLoop := 1 to 9 do
          begin
            NewDesc.Descr[OldDescLoop] := OldDesc.Descr[OldDescLoop];
            showdesc(OldDescLoop,OldDesc.Descr[OldDescLoop],False);
          end;

          for OldDescLoop := 10 to 19 do NewDesc.Descr[OldDescLoop] := '';

          gw('1','Pointting the file to the new extended.dat rec');

          {writting the new file pointer to the *.dir record}
          gw('4',IntToStr(FDirs.vpointer)+' -> '+IntToStr(NewDescLoop));

          FDirs.vpointer := NewDescLoop;
          seek(FDirsF,FDirsLoop);
          write(FDirsF,FDirs);

          {making new extended.dat}
          Seek(NewDescF,NewDescLoop);
          Write(NewDescF,NewDesc);
          Inc(NewDescLoop);

        end
        else begin

          {did find a blank lets skip this entry}
          gw('1','Found Blank Entry! Blanking vpointer..');
          FDirs.vpointer := -1;
          seek(FDirsF,FDirsLoop);
          write(FDirsF,FDirs);

        end;

      end
      else gw('4','-1');

    readln;

    end;

  end;
  Close(FDirsF);
  Close(OldDescF);
  Close(NewDescF);
  Close(FBaseF);

  Rename(OldDescF,RenegadeDat.DataPath+'extended.old');
  Rename(NewDescF,RenegadeDat.DataPath+'extended.dat');

  clrscr;
  writeln('Done sortting records.');
  writeln('Make sure you (R)echeck the files back into the file base');
  writeln('I need this to be done :(');

End.