Program Test_Both;
Uses Crt;

Const
  MaxExtDesc = 19;

Type

  filstat=
   (notval,                       { if file is NOT validated }
    isrequest,                    { if file is REQUEST }
    resumelater,                  { if file is RESUME-LATER }
    hatched);                     { has file been hatched? }

  ulfrec=                         { *.DIR : File records }
  record
    filename:string[12];          { Filename }
    description:string[60];       { File description }
    credits:integer;              { File points }
    downloaded:word;              { Number DLs }
    sizemod:byte;                 { # chars over last 128 byte block }
    blocks:word;                  { # 128 byte blks }
    owner:word;                   { ULer of file }
    stowner:string[36];           { ULer's name }
    date:string[10];              { Date ULed }
    daten:word;                   { Numeric date ULed }
    vpointer:longint;             { Pointer to verbose descr, -1 if none }
    filestat:set of filstat;      { File status }
    res:array[1..10] of byte;     { RESERVED }
  end;

  DescrRec = record
    DescrLines : array[1..MaxExtDesc] of string[50];
  end;

Var
  ulf  : ulfrec;
  ulff : file of ulfrec;

  Descr  : DescrRec;
  DescrF : File of DescrRec;

  OnRec : LongInt;
  Count : LongInt;
  ch    : char;

Begin

 { Setup the data files to be read in. }
 (* open the *.dir        *)
  assign(ulff,'sunrise.dir');
  reset(ulff);

 (* open the extended.dat *)
  assign(DescrF,'extended.dat');
  reset(DescrF);

  for OnRec := 0 to (FileSize(ulff)-1) do
      begin

        Seek(ulff,OnRec);
        Read(ulff,ulf);
        if ulf.vpointer <> -1 then
           begin
             Seek(DescrF,ulf.vpointer);
             Read(DescrF,Descr);
             writeln('Up Rec #: ',OnRec,' of ',(FileSize(ulff)-1));
             writeln('Rec -> to Ext Rec #: ',ulf.vpointer);
             writeln('File Name: ',ulf.filename);
             writeln('--------------------------');
             writeln('1 ',ulf.description);
             for Count := 1 to 9 do
                 begin
                    If Descr.DescrLines[Count] = '' then break;
                     Writeln(Count+1,' ',Descr.DescrLines[Count]);
                 end;
             writeln('--------------------------');

             {readln}
             ch := readkey;
             if upcase(ch) = 'Q' then break;
           end
           else begin
             writeln('Up Rec #: ',OnRec,' of ',(FileSize(ulff)-1));
             writeln('Rec -> to Ext Rec #: ',ulf.vpointer);
             writeln('File Name: ',ulf.filename);
             writeln('--------------------------');
             if ulf.description = '' then writeln('No Description')
             else writeln(ulf.description);
             writeln('--------------------------');
             {readln}
             ch := readkey;
             if upcase(ch) = 'Q' then break;
           end;
      end;
      Close(ulff);
      Close(DescrF);
  end.