UNIT tpzvideo;
(* Status window routines for Turbo Pascal Zmodem *)
(* (c)1988 by J.R.Louvau                          *)

INTERFACE
USES crt;

  PROCEDURE z_openwindow(title : string);  
  (* Setup the area of the screen for transfer status window *)

  PROCEDURE z_closewindow;  
  (* Restore the original window *)

  PROCEDURE z_showname(filename : string);  
  (* Display the file name *)

  PROCEDURE z_showsize(l : longint);  
  (* Display the file size in blocks and bytes *)

  PROCEDURE z_showcheck(is32 : boolean);  
  (* Display CRC16 or CRC32 block checking *)

  PROCEDURE z_showtransfertime(fsize, zbaud : longint);  
  (* Show estimated transfer time in minutes *)

  PROCEDURE z_message(s : string);  
  (* Show miscelaneous messages *)

  PROCEDURE z_frame(n : integer);  
  (* Show current ZMODEM frame type *)

  PROCEDURE z_showloc(l : longint);  
  (* Show byte position of file in blocks and bytes *)

  PROCEDURE z_errors(w : word);  
  (* Show total error count *)

IMPLEMENTATION

  CONST
    x1             : byte = 20;
    x2             : byte = 59;
    y1             : byte = 5;
    y2             : byte = 17;
    fore           : byte = lightgray;
    back           : byte = black;
    bfore          : byte = black;
    bback          : byte = green;

{$F+}
{$L mcmvsmem.obj }   (* was \pascal\screen\.. *)
  PROCEDURE movetoscreen(VAR source, dest; len : word); EXTERNAL; 
  PROCEDURE movefromscreen(VAR source, dest; len : word); EXTERNAL;
{$F-}

  VAR
    vmode          : byte absolute $0040 : $0049;
    vcols          : word absolute $0040 : $004a;
    oldx, oldy,
    oldattr        : byte;
    oldmin, oldmax,
    cols, rows,
    size,
    vseg, vofs     : word;
    buffer         : pointer;

  (* 1---------------1 *)

  FUNCTION rtos(r : real; width, decimals : word) : string;

    VAR
      s              : string;

    BEGIN (* rtos *)
{$I-}
    str(r : width : decimals, s); {$I+}
    IF (ioresult <> 0) THEN s := ''
    ELSE
      WHILE (length(s) > 0) AND (s[1] = ' ') DO delete(s, 1, 1);
    rtos := s;
    END; (* rtos *)

  (* 1---------------1 *)

  FUNCTION itos(r : longint; width : word) : string;

    VAR
      s              : string;

    BEGIN (* itos *)
{$I-}
    str(r : width, s); {$I+}
    IF (ioresult <> 0) THEN s := ''
    ELSE
      WHILE (length(s) > 0) AND (s[1] = ' ') DO delete(s, 1, 1);
    itos := s;
    END; (* itos *)

  (* 1---------------1 *)

  PROCEDURE z_openwindow(title : string);

    VAR
      p, q           : pointer;
      n, pads, bytes : word;

    BEGIN (* z_openwindow *)
    directvideo := true; checksnow := false;
    oldx := wherex; oldy := wherey;
    oldattr := textattr;
    oldmin := windmin; oldmax := windmax;
    window(x1, y1, x2, y2);
    textcolor(bfore); textbackground(bback);
    cols := lo(windmax) - lo(windmin) + 1;
    rows := hi(windmax) - hi(windmin) + 1;
    IF vmode = 7 THEN vseg := $b000
    ELSE vseg := $b800;
    vofs := ((hi(windmin) * vcols) + lo(windmin)) * 2;
    size := (rows * cols) * 2;
    bytes := cols * 2; pads := (vcols * 2) - bytes;
    getmem(buffer, size);
    p := ptr(vseg, vofs); q := buffer;
    FOR n := 1 TO rows DO BEGIN
      movefromscreen(p^, q^, cols * 2);
      inc(longint(p), vcols * 2); inc(longint(q), cols * 2); END;
    clrscr;
    IF (length(title) > (cols - 2)) THEN title[0] := chr(cols-2);
    gotoxy((cols - length(title) - 2) DIV 2 + 1, 1);
    write(title); title := ' ESCape to abort';
    gotoxy((cols - length(title) - 2) DIV 2 + 1, rows); write(title);
    window(x1+1, y1+1, x2-1, y2-1);
    textcolor(fore); textbackground(back);
    clrscr; gotoxy(1, 1);
    writeln(' File name.....:');
    writeln(' File size.....:');
    writeln(' File blocks...:');
    writeln(' Block check...:');
    writeln(' Transfer time.:');
    writeln(' Current BYTE..:');
    writeln(' Current BLOCK.:');
    writeln(' Error count...:');
    writeln(' Last frame....:');
    textcolor(bfore); textbackground(bback);
    gotoxy(1, 10); clreol;
    title := #$19 + 'Last Message' + #$19;
    gotoxy((cols - length(title) - 2) DIV 2 + 1, 10);
    write(title);
    textcolor(white); textbackground(back);
    END; (* z_openwindow *)

  (* 1---------------1 *)

  PROCEDURE z_closewindow;

    VAR
      p, q           : pointer;
      n              : word;

    BEGIN (* z_closewindow *)
    textattr := oldattr; windmax := oldmax;
    windmin := oldmin; gotoxy(oldx, oldy);
    q := buffer; p := ptr(vseg, vofs);
    FOR n := 1 TO rows DO BEGIN
      movetoscreen(q^, p^, cols * 2);
      inc(longint(p), vcols * 2);
      inc(longint(q), cols * 2); END;
    freemem(buffer, size);
    END; (* z_closewindow *)

  (* 1---------------1 *)

  PROCEDURE z_showname(filename : string);

    BEGIN (* z_showname *)
    IF (length(filename) > 14) THEN filename[0] := #14;
    gotoxy(18, 1); write(filename);
    gotoxy(1, 11);
    END; (* z_showname *)

  (* 1---------------1 *)

  PROCEDURE z_showsize(l : longint);

    BEGIN (* z_showsize *)
    gotoxy(18, 2); write(itos(l, 14));
    IF (l MOD 128 <> 0) THEN l := (l DIV 128) + 1
    ELSE l := (l DIV 128);
    gotoxy(18, 3); write(itos(l, 14));
    gotoxy(1, 11);
    END; (* z_showsize *)

  (* 1---------------1 *)

  PROCEDURE z_showcheck(is32 : boolean);

    BEGIN (* z_showcheck *)
    gotoxy(18, 4);
    IF (is32) THEN write('CRC32')
    ELSE write('CRC16');
    gotoxy(1, 11);
    END; (* z_showcheck *)

  (* 1---------------1 *)

  PROCEDURE z_showtransfertime(fsize, zbaud : longint);

    VAR
      bits           : real;

    BEGIN (* z_showtransfertime *)
    bits := fsize * 10.0;
    gotoxy(18, 5);
    IF (bits <> 0.0) THEN
      write(rtos(((bits / zbaud) / 60), 10, 2), 'min.')
    ELSE write('0min.');
    gotoxy(1, 11);
    END; (* z_showtransfertime *)

  (* 1---------------1 *)

  PROCEDURE z_message(s : string);

    BEGIN (* z_message *)
    IF (length(s) > 31) THEN s[0] := #31;
    gotoxy(1, 11); write(s, #13);
    END; (* z_message *)

  (* 1---------------1 *)

  PROCEDURE z_frame(n : integer);

    BEGIN (* z_frame *)
    IF (n < -3) OR (n > 20) THEN n := 20;
    gotoxy(18, 9);
    CASE lo(n) OF
 {
 -3 : write('ZNOCARRIER');
 -2 : write('ZTIMEOUT  ');
 -1 : write('ZERROR    ');
  0 : write('ZRQINIT   ');}
  1 : write('ZRINIT    ');
  2 : write('ZSINIT    ');
  3 : write('ZACK      ');
  4 : write('ZFILE     ');
  5 : write('ZSKIP     ');
  6 : write('ZNAK      ');
  7 : write('ZABORT    ');
  8 : write('ZFIN      ');
  9 : write('ZRPOS     ');
 10 : write('ZDATA     ');
 11 : write('ZEOF      ');
 12 : write('ZFERR     ');
 13 : write('ZCRC      ');
 14 : write('ZCHALLENGE');
 15 : write('ZCOMPL    ');
 16 : write('ZCAN      ');
 17 : write('ZFREECNT  ');
 18 : write('ZCOMMAND  ');
 19 : write('ZSTDERR   ');
 20 : write('ZUNKNOWN  ')
      END; (* case *)
    gotoxy(1, 11);
    END; (* z_frame *)

  (* 1---------------1 *)

  PROCEDURE z_showloc(l : longint);

    BEGIN (* z_showloc *)
    gotoxy(18, 6); write(itos(l, 14));
    IF (l MOD 128 <> 0) THEN l := (l DIV 128) + 1
    ELSE l := (l DIV 128);
    gotoxy(18, 7); write(itos(l, 14));
    gotoxy(1, 11);
    END; (* z_showloc *)

  (* 1---------------1 *)

  PROCEDURE z_errors(w : word);

    BEGIN (* z_errors *)
    gotoxy(18, 8); write(itos(w, 14));
    gotoxy(1, 11);
    END; (* z_errors *)

  (* 1---------------1 *)

  END.
