UNIT tpzfiles;
(* File manipulation routines for Turbo Pascal Zmodem *)
(* (c)1988 by J.R.Louvau                              *)

INTERFACE
  USES DOS;

  FUNCTION z_openfile(VAR f : FILE; pathname : string) : boolean;
  (* Return true if able to open an existing file *)

  FUNCTION z_makefile(VAR f : FILE; pathname : string) : boolean;
  (* Return true if able to create a file *)

  PROCEDURE z_closefile(VAR f : FILE);
  (* Closes a file and ignores errors *)

  FUNCTION z_seekfile(VAR f : FILE; fpos : longint) : boolean;  
  (* Find a byte position within a file *)

  FUNCTION z_writefile(VAR f : FILE; VAR buff; bytes : word) : boolean;

  FUNCTION z_readfile(VAR f : FILE; VAR buff; btoread : word;
                      VAR bread : word) : boolean;  
  (* Read a specified number of bytes from a file *)

  FUNCTION z_findfile(pathname : string; VAR name : string;
                      VAR size, time : longint) : boolean;  
  (* Search for a named file *)

  PROCEDURE z_setftime(VAR f : FILE; time : longint);  
  (* Set time and date of a file *)

IMPLEMENTATION

  FUNCTION z_openfile(VAR f : FILE; pathname : string) : boolean;

    BEGIN (* z_openfile *)
{$I-}
    assign(f, pathname); reset(f, 1); {$I+}
    z_openfile := (ioresult = 0);
    END; (* z_openfile *)

  (* 1---------------1 *)

  FUNCTION z_makefile(VAR f : FILE; pathname : string) : boolean;

    BEGIN (* z_makefile *)
{$I-}
    assign(f, pathname); rewrite(f, 1); {$I+}
    z_makefile := (ioresult = 0);
    END; (* z_makefile *)

  (* 1---------------1 *)

  PROCEDURE z_closefile(VAR f : FILE);

    BEGIN  (* z_closefile *)
{$I-}
    close(f);
    IF (ioresult <> 0) THEN { ignore this error }; {$I+}
    END; (* z_closefile *)

  (* 1---------------1 *)

  FUNCTION z_seekfile(VAR f : FILE; fpos : longint) : boolean;

    BEGIN  (* z_seekfile *)
{$I-}
    seek(f, fpos); z_seekfile := (ioresult = 0); {$I+}
    END; (* z_seekfile *)

  (* 1---------------1 *)

  FUNCTION z_writefile(VAR f : FILE; VAR buff; bytes : word) : boolean;

    BEGIN  (* z_writefile *)
{$I-}
    blockwrite(f, buff, bytes); {$I+}
    z_writefile := (ioresult = 0);
    END; (* z_writefile *)

  (* 1---------------1 *)

  FUNCTION z_readfile(VAR f : FILE; VAR buff; btoread : word;
                      VAR bread: word) : boolean;

    BEGIN (* z_readfile *)
{$I-}
    blockread(f, buff, btoread, bread); {$I+}
    z_readfile := (ioresult = 0);
    END; (* z_readfile *)

  (* 1---------------1 *)

  FUNCTION z_findfile(pathname : string; VAR name : string;
                      VAR size, time : longint) : boolean;
    VAR
      sr              : searchrec;

    BEGIN (* z_findfile *)
{$I-}
    findfirst(pathname, archive, sr);  {$I+}
    IF (doserror <> 0) OR (ioresult <> 0) THEN BEGIN
      z_findfile := false; exit; END;                 (* <<== EXIT *)
    name := sr.name; size := sr.size;
    time := sr.time; z_findfile := true;
    END; (* z_findfile *)

  (* 1---------------1 *)

  PROCEDURE z_setftime(VAR f : FILE; time : longint);

    BEGIN (* z_setftime *)
{$I-}
    setftime(f, time); {$I+}
    IF (ioresult <> 0) THEN {null}
    END; (* z_setftime *)

  (* 1---------------1 *)

  END.
