{$R+,S+,I+,D+,T+,F-,V+,B-,N-,L+ }
{$M 16384,0,8000 }
PROGRAM testfos(input, output);

  USES crt, fossil;

  CONST
    f1        = -59;
    f2        = -60;
    f10       = -68;
    cr        = 13;
    lf        = 10;

  VAR
    prevch,
    lastch    : integer;
    echo,
    addlf     : boolean;

  (* 1---------------1 *)

  FUNCTION getkey : integer;

    VAR
      ch    : char;

    BEGIN (* getkey *)
    ch := readkey;
    IF ch = chr(0) THEN getkey := - ord(readkey)
    ELSE getkey := ord(ch);
    END; (* getkey *)

  (* 1---------------1 *)

  PROCEDURE specialkey(k : integer);

    VAR
      x, y    : integer;

    (* 2---------------2 *)

    PROCEDURE onoff(b : boolean);

      BEGIN (* onoff *)
      IF b THEN write('on. ')
      ELSE write('off.');
      END; (* onoff *)

    (* 2---------------2 *)

    BEGIN (* specialkey *)
    x := wherex; y := wherey;
    window(1, 1, 80, 1);
    CASE k OF
f1:   echo := NOT echo;
f2:   addlf := NOT addlf;
 (* ELSE donothing *)
      END;
    gotoxy(1, 1); clreol;
    write('<', -ord(k) : 3, '> F10 exits.  Echo '); onoff(echo);
    write(' Addlf '); onoff(addlf);
    window(1, 2, 80, 25); gotoxy(x, y);
    END; (* specialkey *)

  (* 1---------------1 *)

  BEGIN (* testfos *)
  lowvideo; echo := false; addlf := false;
  IF NOT openfossil(0) THEN writeln('No fossil driver available')
  ELSE BEGIN
    window(1, 2, 80, 25);
    specialkey(0);
    lastch := 0; setbaudrate(1200);
    REPEAT
      IF keypressed THEN BEGIN
        prevch := lastch; lastch := getkey;
        IF lastch > 0 THEN BEGIN
          sendchar(chr(lastch));
          IF echo THEN BEGIN
            IF addlf AND (prevch = cr) AND (lastch <> lf) THEN
              write(chr(lf));
            write(chr(lastch)); END;
          END
        ELSE IF lastch < 0 THEN specialkey(lastch); END;
      IF rcvready THEN write(rcvchar);
    UNTIL lastch = f10;
    closefossil; END;
  END. (* testfos *)