UNIT pibasync; (* A dummy only *)

INTERFACE

  CONST
    uart_lcr           = 0;
    uart_lsr           = 1;
    uart_rbr           = 2;
    uart_mcr           = 3;
    uart_ier           = 4;
    i8088_imr          = 32;


  VAR
    async_save_iaddr   : pointer;
    async_obuffer_tail,
    async_obuffer_head : integer;
    async_do_cts,
    async_do_dsr,
    async_do_xonxoff,
    async_hard_wired_on,
    async_xoff_sent,
    async_open_flag    : boolean;
    async_break_length,
    async_base         : integer;
    async_irq          : integer;

  FUNCTION async_buffer_check : boolean;
  FUNCTION async_carrier_detect : boolean;
  PROCEDURE async_receive_with_timeout(timeout : integer; VAR n : integer);
  PROCEDURE async_flush_output_buffer;
  PROCEDURE async_send_break;
  PROCEDURE async_send(ch : char);
  PROCEDURE async_init(i1, i2, i3, i4, i5 : integer);
  FUNCTION async_open(zport : word; zbaud : longint; parity : char;
                      bits, stopbits : integer) : boolean;

IMPLEMENTATION

  FUNCTION async_buffer_check : boolean; BEGIN END;
  FUNCTION async_carrier_detect : boolean; BEGIN END;
  PROCEDURE async_receive_with_timeout(timeout : integer; VAR n : integer);
    BEGIN END;
  PROCEDURE async_flush_output_buffer; BEGIN END;
  PROCEDURE async_send_break; BEGIN END;
  PROCEDURE async_send(ch : char); BEGIN END;
  PROCEDURE async_init(i1, i2, i3, i4, i5 : integer); BEGIN END;
  FUNCTION async_open(zport : word; zbaud : longint; parity : char;
           bits, stopbits : integer) : boolean;
    BEGIN END;

  END.