unit litebox2;

interface
uses crt;

type

  mrec  =  Record
              Skip   : Boolean;
              Name   : String;
              Letter : Char;
              x,y    : Byte;
           End;

 literec = Record   {Litebar config rec}
              choices: Integer;
              menu: Array [1..25] Of mrec;
              keycolor,othercolor, barcolor: Integer;
              usehotkeys:boolean;
           End;

const on:integer=1;
      lastone:integer=1;
function litebar (var ff): integer;

implementation

Procedure HideCursor; Assembler;
Asm
  MOV   AX, $0100         {Hides cursor}
  MOV   CX, $2607
  Int   $10
End;
Procedure ShowCursor; Assembler;
Asm
  MOV   AX, $0100
  MOV   CX, $0506         {Unhides cursor}
  Int   $10
End;

Function litebar (var ff): Integer;
Label ack, stop;
Var
  key: Char;          {Various vars}
  okey: Byte;
  litesize: Integer;
  goodkey:boolean;
  fkey:boolean;
  lite: literec absolute ff;

Begin
  hidecursor;
  TextBackground (0);            {Change background}
  litesize := 0;
  For on := 1 To lite. choices Do Begin  {This for loop writes the options.}
    if lite.menu[on].skip=false then
    begin
    GotoXY (lite.menu[on].X, lite.menu[on].Y + on - 1);
    if lite.usehotkeys=true then
    begin
    textcolor(lite.keycolor);
    write('(');
    textcolor(15);
    write(lite.menu[on].letter);
    textcolor(lite.keycolor);
    write(')'+' ');
    end;
    TextColor (lite. othercolor);  {Change color}
    WriteLn (lite. menu[on].name );
    If Length (lite. menu [on].name ) > litesize Then litesize := Length(lite. menu [on].name );
    end;
  End;

  For on := 1 To lite. choices Do Begin  {This for loop makes the >lightbar}
    if lite.menu[on].skip=false then
    begin
    If Length (lite. menu [on].name ) < litesize Then Begin {the same >length}
      Repeat
        lite. menu [on].name := lite. menu [on].name + ' ';
      Until Length (lite. menu [on].name ) >= litesize;
    end;
    End;
  End;
  Repeat   {Main loop}
    If lastone <> 999 Then Begin  {redraw last option (reset background}
    if lite.usehotkeys=true then GotoXY (lite.menu[lastone].X+4, lite.menu[lastone].Y + lastone - 1)
    else gotoxy(lite.menu[lastone].x,lite.menu[lastone].y+lastone-1);
      TextBackground (0);
      WriteLn (lite. menu [lastone].name );
    End;
    if lite.usehotkeys=true then GotoXY (lite.menu[on].X+4, lite.menu[on].Y + on - 1)  {go to option}
    else GotoXY (lite.menu[on].X, lite.menu[on].Y + on - 1);
    TextBackground (lite. barcolor); {change color}
    WriteLn (lite. menu [on].name );  {rewrite current option (background)}
    ack:
    goodkey:=false;
    fkey:=false;
    Repeat  {gets up/down/enter/esc/function or hotkey}
     key := ReadKey;
     if key=#0 then
     begin
     fkey:=true;
     key:=readkey;
     end else key:=upcase(key);
     if (fkey=true) and (key in [#75,#77,#72,#80,#59..#68]) {arrows and Fkeys}
          then goodkey:=true else
     if key In [#27,#13] then goodkey:=true else {ESC and enter}
     if lite.usehotkeys=true then
     for okey:= 1 to lite.choices do
      if (key=lite.menu[okey].letter) and (lite.menu[okey].skip=false) then
       begin
        on:=okey;
        goodkey:=true; {a hotkey was hit}
        goto stop;
       end;
    until goodkey=true;
    case key of
    #72:  Begin  {up}
          lastone:=on;
        If on = 1 Then  on := lite. choices
         Else
        If on <> 1 Then
         begin
         goodkey:=false;
         repeat
         dec(on);
         if lite.menu[on].skip=false then goodkey:=true;
         until goodkey=true;
         end;
       End;

    #80: Begin {down}
         lastone:=on;
         If on = lite. choices Then
          Begin
           on := 1
          End Else
         If (on < lite. choices) Then
          begin
          goodkey:=false;
          repeat
           Inc (on);
           if lite.menu[on].skip=false then goodkey:=true;
          until goodkey=true;
          end;
        End;
     #13 : goto stop;
     #27: begin   lastone:=on;on:=lite.choices; goto stop; end;
     #59: begin   lastone:=on;on:=-1; goto stop; end;
     #60: begin   lastone:=on;on:=-2; goto stop; end;
     #61: begin   lastone:=on;on:=-3; goto stop; end;
     #62: begin   lastone:=on;on:=-4; goto stop; end;
     #63: begin   lastone:=on;on:=-5; goto stop; end;
     #64: begin   lastone:=on;on:=-6; goto stop; end;
     #65: begin   lastone:=on;on:=-7; goto stop; end;
     #66: begin   lastone:=on;on:=-8; goto stop; end;
     #67: begin   lastone:=on;on:=-9; goto stop; end;
     #68: begin   lastone:=on;on:=-10; goto stop; end;
     #75: begin   lastone:=on;on:=-11; goto stop; end;
     #77: begin   lastone:=on;on:=-12; goto stop; end;
      end;{case}


  Until 5 < 4; {loop.}
  stop:  {end it}
  litebar := on;  {tell us what they picked}
  ShowCursor;  {turn cursor back on}
End;

BEGIN

END.