{$A-,B-,S-,R-}

{--------------------------------------------------------------------}
{-                        LFNLIST.PAS v1.00                         -}
{-        A singlelist used by a demo for LFN v1.06 or later        -}
{-             Written by Andreas Killer, Germany, NRW              -}
{-      homepage: http://home.t-online.de/home/andreas.killer       -}
{--------------------------------------------------------------------}

unit
  LFNList;

interface

type
  AssignNodePtr = ^AssignNode;
  AssignNode =
    object
      anNext : AssignNodePtr;

      constructor Init;
        {-Initialize an empty node}
      destructor Done; virtual;
        {-Does nothing, but makes shure we can call descentants}
    end;

type
  AssignListPtr = ^AssignList;
  AssignList =
    object
      alFirst, alLast : AssignNodePtr;

      constructor Init;
        {-Initialize an empty list}
      destructor Done; virtual;
        {-Destroy list}
      procedure RemoveAll;
        {-Remove all nodes from list}
      function First : AssignNodePtr;
        {-Returns the first node in list}
      function Last : AssignNodePtr;
        {-Returns the last node in list}
      function Next(P : AssignNodePtr) : AssignNodePtr;
        {-Returns the next node after P}

      procedure Insert(P : AssignNodePtr);
        {-Insert P at the start of the list}
      procedure Place(P, AfterP : AssignNodePtr);
        {-Place P into list after existing node AfterP}
      procedure PlaceBefore(P, BeforeP : AssignNodePtr);
        {-Place P into list before existing node BeforeP}
      procedure Append(P : AssignNodePtr);
        {-Adds P to the end of the list}
      procedure Remove(P : AssignNodePtr);
        {-Remove P from list and dispose its contents}
      procedure Delete(P : AssignNodePtr);
        {-Remove P from list}

        {---------------------------------------------------}
      private procedure RemovePrim(P : AssignNodePtr; DisposeIt : Boolean);
        {-Remove P from list and dispose its contents}
    end;

implementation

  constructor AssignNode.Init;
    {-Initialize an empty node}
  begin
    anNext := nil;
  end;

  destructor AssignNode.Done;
    {-Does nothing, but makes shure we can call descentants}
  begin
  end;

  constructor AssignList.Init;
    {-Initialize an empty list}
  begin
    alFirst := nil;
    alLast := nil;
  end;

  destructor AssignList.Done;
    {-Destroy list}
  begin
    RemoveAll;
  end;

  procedure AssignList.RemoveAll;
    {-Remove all nodes from list}
  var
    T, N : AssignNodePtr;
  begin
    T := alFirst;
    while T <> nil do begin
      N := T^.anNext;
      Dispose(T, Done);
      T := N;
    end;
  end;

  function AssignList.First : AssignNodePtr;
    {-Returns the first node in list}
  begin
    First := alFirst;
  end;

  function AssignList.Last : AssignNodePtr;
    {-Returns the last node in list}
  begin
    Last := alLast;
  end;

  function AssignList.Next(P : AssignNodePtr) : AssignNodePtr;
    {-Returns the next node after P}
  begin
    if P = nil then
      Next := nil
    else
      Next := P^.anNext;
  end;

  procedure AssignList.Insert(P : AssignNodePtr);
    {-Insert P at the start of the list}
  begin
    P^.anNext := alFirst;
    alFirst := P;
    if alLast = nil then
      alLast := P;
  end;

  procedure AssignList.Place(P, AfterP : AssignNodePtr);
    {-Place P into list after existing node AfterP}
  begin
    if AfterP = nil then
      Insert(P)
    else begin
      if AfterP = alLast then
        Append(P)
      else begin
        P^.anNext := AfterP^.anNext;
        AfterP^.anNext := P;
      end;
    end;
  end;

  procedure AssignList.PlaceBefore(P, BeforeP : AssignNodePtr);
    {-Place P into list before existing node BeforeP}
  var
    T : AssignNodePtr;
  begin
    T := alFirst;
    while (T <> nil) and (T^.anNext <> BeforeP) do
      T := T^.anNext;
    if (T = nil) or (T = alFirst) then
      Insert(P)
    else begin
      P^.anNext := T^.anNext;
      T^.anNext := P;
    end;
  end;

  procedure AssignList.Append(P : AssignNodePtr);
    {-Adds P to the end of the list}
  begin
    if alFirst = nil then
      alFirst := P
    else
      alLast^.anNext := P;
    alLast := P;
  end;

  procedure AssignList.RemovePrim(P : AssignNodePtr; DisposeIt : Boolean);
    {-Remove P from list and dispose its contents}
  var
    L, T : AssignNodePtr;
  begin
    T := alFirst;
    L := nil;
    while T <> nil do begin
      if T = P then begin
        if L = nil then
          alFirst := T^.anNext
        else
          L^.anNext := T^.anNext;
        if T = alLast then
          alLast := L;
        if DisposeIt then
          Dispose(T, Done);
        Exit;
      end;
      L := T;
      T := T^.anNext;
    end;
  end;

  procedure AssignList.Remove(P : AssignNodePtr);
    {-Remove P from list and dispose its contents}
  begin
    RemovePrim(P, True);
  end;

  procedure AssignList.Delete(P : AssignNodePtr);
    {-Remove P from list}
  begin
    RemovePrim(P, False);
  end;

end.
