{$S-,R-,V-,I-,B-,F+,O+,A-}
unit
  LFNError;

  {--------------------------------------------------------------------}
  {-                        LFNERROR.PAS v1.00                        -}
  {-  Erweiterte DOS-Fehlermeldungen, primr fr den Einsatz mit LFN  -}
  {-             fr TP6, TP/BP7 und kompatible Compiler.             -}
  {-             Written by Andreas Killer, Germany, NRW              -}
  {-      homepage: http://home.t-online.de/home/andreas.killer       -}
  {--------------------------------------------------------------------}

interface
uses
  Dos;

function ExtendedErrorStr(Error : Byte) : String;
  {-Liefert fr ExtendedError den entsprechenden String zurck}
function ErrorClassStr(Error : Byte) : String;
  {-Liefert fr ErrorClass den entsprechenden String zurck}
function RecommendedActionStr(Error : Byte) : String;
  {-Liefert fr RecommendedAction den entsprechenden String zurck}
function ErrorLocusStr(Error : Byte) : String;
  {-Liefert fr ErrorLocus den entsprechenden String zurck}

procedure GetExtendedError(var ExtendedError, ErrorClass,
                           RecommendedAction, ErrorLocus : Byte);
  {-Fordert vom Betriebssystem den erweiterten Fehlercode an}

  {========================================================================}

implementation

  procedure GetExtendedError(var ExtendedError, ErrorClass,
                             RecommendedAction, ErrorLocus : Byte);
    {-Fordert vom Betriebssystem den erweiterten Fehlercode an}
  var
    Regs : Registers;
  begin
    with Regs do begin
      AH := $59;
      BX := 0;
      MsDos(Regs);
      ExtendedError := AX;
      ErrorClass := BH;
      RecommendedAction := BL;
      ErrorLocus := CH;
    end;
  end;

  function ExtendedErrorStr(Error : Byte) : String;
    {-Liefert fr einen extended error den entsprechenden String zurck}
  begin
    case Error of
      $00 : {0  } ExtendedErrorStr := 'no error';
      $01 : {1  } ExtendedErrorStr := 'function number invalid';
      $02 : {2  } ExtendedErrorStr := 'file not found';
      $03 : {3  } ExtendedErrorStr := 'path not found';
      $04 : {4  } ExtendedErrorStr := 'too many open files (no handles available)';
      $05 : {5  } ExtendedErrorStr := 'access denied';
      $06 : {6  } ExtendedErrorStr := 'invalid handle';
      $07 : {7  } ExtendedErrorStr := 'memory control block destroyed';
      $08 : {8  } ExtendedErrorStr := 'insufficient memory';
      $09 : {9  } ExtendedErrorStr := 'memory block address invalid';
      $0A : {10 } ExtendedErrorStr := 'environment invalid (usually >32K in length)';
      $0B : {11 } ExtendedErrorStr := 'format invalid';
      $0C : {12 } ExtendedErrorStr := 'access code invalid';
      $0D : {13 } ExtendedErrorStr := 'data invalid';
      $0E : {14 } ExtendedErrorStr := 'reserved';
      $0F : {15 } ExtendedErrorStr := 'invalid drive';
      $10 : {16 } ExtendedErrorStr := 'attempted to remove current directory';
      $11 : {17 } ExtendedErrorStr := 'not same device';
      $12 : {18 } ExtendedErrorStr := 'no more files';
      {--- DOS 3.0+ ---}
      $13 : {19 } ExtendedErrorStr := 'disk write-protected';
      $14 : {20 } ExtendedErrorStr := 'unknown unit';
      $15 : {21 } ExtendedErrorStr := 'drive not ready';
      $16 : {22 } ExtendedErrorStr := 'unknown command';
      $17 : {23 } ExtendedErrorStr := 'data error (CRC)';
      $18 : {24 } ExtendedErrorStr := 'bad request structure length';
      $19 : {25 } ExtendedErrorStr := 'seek error';
      $1A : {26 } ExtendedErrorStr := 'unknown media type (non-DOS disk)';
      $1B : {27 } ExtendedErrorStr := 'sector not found';
      $1C : {28 } ExtendedErrorStr := 'printer out of paper';
      $1D : {29 } ExtendedErrorStr := 'write fault';
      $1E : {30 } ExtendedErrorStr := 'read fault';
      $1F : {31 } ExtendedErrorStr := 'general failure';
      $20 : {32 } ExtendedErrorStr := 'sharing violation';
      $21 : {33 } ExtendedErrorStr := 'lock violation';
      $22 : {34 } ExtendedErrorStr := 'disk change invalid (ES:DI -> media ID structure)(see #0981)';
      $23 : {35 } ExtendedErrorStr := 'FCB unavailable';
      $24 : {36 } ExtendedErrorStr := 'sharing buffer overflow';
      $25 : {37 } ExtendedErrorStr := '(DOS 4.0+) code page mismatch';
      $26 : {38 } ExtendedErrorStr := '(DOS 4.0+) cannot complete file operation (out of input)';
      $27 : {39 } ExtendedErrorStr := '(DOS 4.0+) insufficient disk space';
      $32 : {50 } ExtendedErrorStr := 'network request not supported';
      $33 : {51 } ExtendedErrorStr := 'remote computer not listening';
      $34 : {52 } ExtendedErrorStr := 'duplicate name on network';
      $35 : {53 } ExtendedErrorStr := 'network name not found';
      $36 : {54 } ExtendedErrorStr := 'network busy';
      $37 : {55 } ExtendedErrorStr := 'network device no longer exists';
      $38 : {56 } ExtendedErrorStr := 'network BIOS command limit exceeded';
      $39 : {57 } ExtendedErrorStr := 'network adapter hardware error';
      $3A : {58 } ExtendedErrorStr := 'incorrect response from network';
      $3B : {59 } ExtendedErrorStr := 'unexpected network error';
      $3C : {60 } ExtendedErrorStr := 'incompatible remote adapter';
      $3D : {61 } ExtendedErrorStr := 'print queue full';
      $3E : {62 } ExtendedErrorStr := 'queue not full';
      $3F : {63 } ExtendedErrorStr := 'not enough space to print file';
      $40 : {64 } ExtendedErrorStr := 'network name was deleted';
      $41 : {65 } ExtendedErrorStr := 'network: Access denied';
      $42 : {66 } ExtendedErrorStr := 'network device type incorrect';
      $43 : {67 } ExtendedErrorStr := 'network name not found';
      $44 : {68 } ExtendedErrorStr := 'network name limit exceeded';
      $45 : {69 } ExtendedErrorStr := 'network BIOS session limit exceeded';
      $46 : {70 } ExtendedErrorStr := 'temporarily paused';
      $47 : {71 } ExtendedErrorStr := 'network request not accepted';
      $48 : {72 } ExtendedErrorStr := 'network print/disk redirection paused';
      $49 : {73 } ExtendedErrorStr := 'network software not installed (LANtastic) invalid network version';
      $4A : {74 } ExtendedErrorStr := 'unexpected adapter close (LANtastic) account expired';
      $4B : {75 } ExtendedErrorStr := '(LANtastic) password expired';
      $4C : {76 } ExtendedErrorStr := '(LANtastic) login attempt invalid at this time';
      $4D : {77 } ExtendedErrorStr := '(LANtastic v3+) disk limit exceeded on network node';
      $4E : {78 } ExtendedErrorStr := '(LANtastic v3+) not logged in to network node';
      $50 : {80 } ExtendedErrorStr := 'file exists';
      $52 : {82 } ExtendedErrorStr := 'cannot make directory';
      $53 : {83 } ExtendedErrorStr := 'fail on INT 24h';
      $54 : {84 } ExtendedErrorStr := '(DOS 3.3+) too many redirections';
      $55 : {85 } ExtendedErrorStr := '(DOS 3.3+) duplicate redirection';
      $56 : {86 } ExtendedErrorStr := '(DOS 3.3+) invalid password';
      $57 : {87 } ExtendedErrorStr := '(DOS 3.3+) invalid parameter';
      $58 : {88 } ExtendedErrorStr := '(DOS 3.3+) network write fault';
      $59 : {89 } ExtendedErrorStr := '(DOS 4.0+) function not supported on network';
      $5A : {90 } ExtendedErrorStr := '(DOS 4.0+) required system component not installed';
      $64 : {100} ExtendedErrorStr := '(MSCDEX) unknown error';
      $65 : {101} ExtendedErrorStr := '(MSCDEX) not ready';
      $66 : {102} ExtendedErrorStr := '(MSCDEX) EMS memory no longer valid';
      $67 : {103} ExtendedErrorStr := '(MSCDEX) not High Sierra or ISO-9660 format';
      $68 : {104} ExtendedErrorStr := '(MSCDEX) door open';
      $B0 : {176} ExtendedErrorStr := '(MS-DOS 7.0) volume is not locked';
      $B1 : {177} ExtendedErrorStr := '(MS-DOS 7.0) volume is locked in drive';
      $B2 : {178} ExtendedErrorStr := '(MS-DOS 7.0) volume is not removable';
      $B4 : {180} ExtendedErrorStr := '(MS-DOS 7.0) lock count has been exceeded';
      $B5 : {181} ExtendedErrorStr := '(MS-DOS 7.0) a valid eject request failed';
    else
      ExtendedErrorStr := 'unkown error';
    end;
  end;

  function ErrorClassStr(Error : Byte) : String;
    {-Liefert fr ErrorClass den entsprechenden String zurck}
  begin
    case Error of
      $01 : ErrorClassStr := 'out of resource (storage space or I/O channels)';
      $02 : ErrorClassStr := 'temporary situation (file or record lock)';
      $03 : ErrorClassStr := 'authorization (denied access)';
      $04 : ErrorClassStr := 'internal (system software bug)';
      $05 : ErrorClassStr := 'hardware failure';
      $06 : ErrorClassStr := 'system failure (configuration file missing or incorrect)';
      $07 : ErrorClassStr := 'application program error';
      $08 : ErrorClassStr := 'not found';
      $09 : ErrorClassStr := 'bad format';
      $0A : ErrorClassStr := 'locked';
      $0B : ErrorClassStr := 'media error';
      $0C : ErrorClassStr := 'already exists';
    else
      ErrorClassStr := 'unknown';
    end;
  end;

  function RecommendedActionStr(Error : Byte) : String;
    {-Liefert fr RecommendedAction den entsprechenden String zurck}
  begin
    case Error of
      $01 : RecommendedActionStr := 'retry';
      $02 : RecommendedActionStr := 'delayed retry';
      $03 : RecommendedActionStr := 'prompt user to reenter input';
      $04 : RecommendedActionStr := 'abort after cleanup';
      $05 : RecommendedActionStr := 'immediate abort';
      $06 : RecommendedActionStr := 'ignore';
      $07 : RecommendedActionStr := 'retry after user intervention';
    else
      RecommendedActionStr := 'unkown';
    end;
  end;

  function ErrorLocusStr(Error : Byte) : String;
    {-Liefert fr ErrorLocus den entsprechenden String zurck}
  begin
    case Error of
      $01 : ErrorLocusStr := 'unknown or not appropriate';
      $02 : ErrorLocusStr := 'block device (disk error)';
      $03 : ErrorLocusStr := 'network related';
      $04 : ErrorLocusStr := 'serial device (timeout)';
      $05 : ErrorLocusStr := 'memory related';
    else
      ErrorLocusStr := 'unkown';
    end;
  end;

end.
