uses dos,hexadec;
type
  nodeadress=array [0..5] of byte;
  ipxadress=record
              ntw: longint;
              node: nodeadress;
              sckt: word;
            end;
  ipxheader=record
              chksum: word;
              len: word;
              tc: byte;
              typ: byte;
              dest,src: ipxadress;
            end;

  ecbrec=record
           link,esr: pointer;
           inuse,cmpl: byte;
           sckt: word;
           ipxwrk: longint;
           dwrk: ipxadress;
           dest: nodeadress;
           frgcount: word;
           frgdata: pointer;
           frgsize: word;
         end;

  PIPXHlpStruc=^TIPXHlpStruc;
  TIPXHlpStruc=record
                 head:ipxheader;
                 data:array [0..63999] of byte;
               end;



var
  myadr: ipxadress;


function testipx: boolean;
var r: registers;
begin
  r.ax:=$7A00;intr ($2F,r);
  testipx:=(r.al=$FF);
end;

procedure getmyadress;
var
  r: registers;
  a: byte;
begin
  r.bx:=9;r.es:=seg(myadr);r.si:=ofs(myadr);intr ($7A,r);
  hexstatus:=finalh;minnum:=4;writeln ('Net: ',dec2hex (myadr.ntw));
  hexstatus:=0;minnum:=2;write ('Node: ');
  for a:=0 to 5 do write (dec2hex (myadr.node[a]));
  writeln ('h');writeln ('Socket: ',myadr.sckt);
end;


procedure opensocket (num: word);
var
  r: registers;
begin
  r.bx:=0;r.al:=0;r.dx:=swap (num);intr ($7A,r);
end;


procedure senddata (var data;socket,len: word);
type ipxdlenrec=record
                  h: ipxheader;
                  l: longint;
                end;
const
  brdcst:nodeadress=($FF,$FF,$FF,$FF,$FF,$FF);
var
  r: registers;
  ecb: ecbrec;
  ipx: Pipxhlpstruc;
  ipxdlen: ipxdlenrec;
begin
  ipxdlen.l:=len;
  fillchar (ecb,sizeof(ecb),0);
  fillchar (ipxdlen.h,sizeof(ipxheader),0);
  ecb.sckt:=swap (socket);
  ecb.frgcount:=1;
  ecb.frgsize:=sizeof(ipxdlen);
  ipxdlen.h.chksum:=$FFFF;
  move (brdcst,ecb.dest,sizeof(brdcst));
  move (myadr,ipxdlen.h.src,sizeof(myadr));
  ipxdlen.h.dest.ntw:=myadr.ntw;
  ipxdlen.h.dest.sckt:=swap(socket);
  move (brdcst,ipxdlen.h.dest.node,sizeof(brdcst));
  ipxdlen.h.src.sckt:=swap(socket);
  ipxdlen.h.len:=swap(sizeof(ipxdlen));
  ecb.frgdata:=@ipxdlen;
  r.bx:=3;r.es:=seg(ecb);r.si:=ofs(ecb);intr ($7A,r);
  getmem (ipx,sizeof(ipxheader)+len);
  move (data,ipx^.data,len);
  fillchar (ecb,sizeof(ecb),0);
  fillchar (ipx^.head,sizeof(ipx^.head),0);
  ecb.sckt:=swap (socket);
  ecb.frgcount:=1;
  ecb.frgsize:=sizeof(ipx^.head)+len;
  ipx^.head.chksum:=$FFFF;
  move (brdcst,ecb.dest,sizeof(brdcst));
  move (myadr,ipx^.head.src,sizeof(myadr));
  ipx^.head.dest.ntw:=myadr.ntw;
  ipx^.head.dest.sckt:=swap(socket);
  move (brdcst,ipx^.head.dest.node,sizeof(brdcst));
  ipx^.head.src.sckt:=swap(socket);
  ipx^.head.len:=swap (sizeof(ipx^.head)+len);
  ecb.frgdata:=ipx;
  r.bx:=3;r.es:=seg(ecb);r.si:=ofs(ecb);intr ($7A,r);
  freemem (ipx,sizeof(ipxheader)+len);
end;

function getdata (var data;socket: word): word;
type ipxdlenrec=record
                  h: ipxheader;
                  l: longint;
                end;

var
  r: registers;
  ecb: ecbrec;
  ipx: Pipxhlpstruc;
  len: word;
  ipxdlen: ipxdlenrec;
begin
  fillchar (ecb,sizeof(ecb),0);
  fillchar (ipxdlen.h,sizeof(ipxdlen.h),0);
  ecb.sckt:=swap (socket);
  ecb.inuse:=$1D;
  ecb.frgcount:=1;
  ecb.frgsize:=sizeof(ipxdlen);
  ecb.frgdata:=@ipxdlen;
  r.bx:=4;r.es:=seg(ecb);r.si:=ofs(ecb);intr ($7A,r);
  while ecb.inuse<>0 do;
  len:=word(ipxdlen.l);
  getmem (ipx,sizeof(ipxheader)+len);
  fillchar (ipx^.head,sizeof(ipx^.head),0);
  ecb.inuse:=$1D;
  ecb.frgsize:=sizeof(ipxheader)+len;
  ecb.frgdata:=ipx;
  r.bx:=4;r.es:=seg(ecb);r.si:=ofs(ecb);intr ($7A,r);
  while ecb.inuse<>0 do;
  move (ipx^.data,data,len);
  getdata:=len;
  freemem (ipx,sizeof(ipxheader)+len);
end;

procedure closesocket (socket: word);
var r: registers;
begin
  r.bx:=1;r.dx:=swap (socket);intr ($7A,r);
end;



var
  s: string;




begin
  if not testipx then
  begin
    writeln;writeln ('No IPX-Driver installed.');
    halt (1);
  end;
  s:='Dies ist eine Netzwerknachricht, versandt mit Hilfe des IPX-Protokolls.';
  getmyadress;
  opensocket ($869E);
  senddata (s,$869E,length(s)+1);
  closesocket ($869E);
end.
