       PUSH    DS             ;Save data segment.
       LDS     SI,[BP+Addr1]  ;Source Address
       LES     DI,[BP+Addr2]  ;Destination Addr
       MOV     CX,[BP+BlkLen] ;Length of block
       JCXZ    Done
       MOV     DX,DI          ;Save X coordinate for later.
       XOR     AX,AX          ;Set Current attributes.
       CLD
LOOPA: LODSB                  ;Get next character.
       CMP     AL,32          ;If a control character, jump.
       JC      ForeGround
       STOSW                  ;Save letter on screen.
Next:  LOOP    LOOPA
       JMP     Short Done
ForeGround:
       CMP     AL,16          ;If less than 16, then change the
       JNC     BackGround     ;foreground color.  Otherwise jump.
       AND     AH,0F0H        ;Strip off old foreground.
       OR      AH,AL
       JMP     Next
BackGround:
       CMP     AL,24          ;If less than 24, then change the
       JZ      NextLine       ;background color.  If exactly 24,
       JNC     FlashBitToggle ;then jump down to next line.
    $2C/$10/           {       SUB     AL,16          ;Otherwise jump to multiple output
    $02/$C0/           {       ADD     AL,AL          ;routines.
    $02/$C0/           {       ADD     AL,AL
    $02/$C0/           {       ADD     AL,AL
    $02/$C0/           {       ADD     AL,AL
    $80/$E4/$8F/       {       AND     AH,8FH         ;Strip off old background.
    $0A/$E0/           {       OR      AH,AL
    $EB/$DA/           {       JMP     Next
                       {NextLine:
    $81/$C2/$A0/$00/   {       ADD     DX,160         ;If equal to 24,
    $8B/$FA/           {       MOV     DI,DX          ;then jump down to
    $EB/$D2/           {       JMP     Next           ;the next line.
                       {FlashBitToggle:
    $3C/$1B/           {       CMP     AL,27          ;Does user want to toggle the blink
    $72/$07/           {       JC      MultiOutput    ;attribute?
    $75/$CC/           {       JNZ     Next
    $80/$F4/$80/       {       XOR     AH,128         ;Done.
    $EB/$C7/           {       JMP     Next
                       {MultiOutput:
    $3C/$19/           {       CMP     AL,25          ;Set Z flag if multi-space output.
    $8B/$D9/           {       MOV     BX,CX          ;Save main counter.
    $AC/               {       LODSB                  ;Get count of number of times
    $8A/$C8/           {       MOV     CL,AL          ;to display character.
    $B0/$20/           {       MOV     AL,32
    $74/$02/           {       JZ      StartOutput    ;Jump here if displaying spaces.
    $AC/               {       LODSB                  ;Otherwise get character to use.
    $4B/               {       DEC     BX             ;Adjust main counter.
                       {StartOutput:
    $32/$ED/           {       XOR     CH,CH
    $41/               {       INC     CX
    $F3/$AB/           {       REP STOSW
    $8B/$CB/           {       MOV     CX,BX
    $49/               {       DEC     CX             ;Adjust main counter.
    $E0/$AA/           {       LOOPNZ  LOOPA          ;Loop if anything else to do...
    $1F);              {Done:  POP     DS             ;Restore data segment.


