                         {FLPT5}
{-------------DoEsc}
PROCEDURE DoEsc(Pk : Packet);        {do the esc instr}
begin
if Wait_Found then
  begin  InsrtSt(Instrnames[Opcodes[$9B]]); OutUstring; end;
UsIndex:=FirstTab;
InsrtSt('ESC'); UsIndex:=SecondTab;
Insrthx2((Opcode and 7)*8+Reg);
Comma; DoMem(Pk);
end;

{-------------St_i}
PROCEDURE St_i;         {do st(i) }
begin
InsrtSt('ST(');
InsrtChr(Chr(Rm+$30));
InsrtChr(')');
end;

{-------------Sti_st}
PROCEDURE Sti_st;       {do st(i),st }
begin
St_i;
InsrtSt(',ST');
end;

{-------------Db}
PROCEDURE Db;
Const DB_NAME :Array[0..11] of String[6] =
           ('FILD','','FIST','FISTP','','FLD','',
            'FSTP','FENI','FDISI','FCLEX','FINIT');
Var     I       :Word;
        Pk : Packet;
        Tmp : String[7];
begin
ReadModeByte(Pk); Wd:=False;
if (Mode=3) then I:=Rm+8 else I:=Reg;   {form an index}
Tmp:=DB_NAME[I];
if (Tmp[0]>#0) and (I<=11) then
   begin
   if not Wait_Found then
     if I>=8 then  {'FENI','FDISI','FCLEX','FINIT' to no wait equivalents}
       Insert('N',Tmp,2);
   InsrtSt(Tmp); UsIndex:=SecondTab;
   if I<=3 then
      begin
      InsrtSt('DWORD '); DoMem(Pk);
      end
   else if I<=7 then
      begin InsrtSt('TBYTE '); DoMem(Pk); end;
   end
else DoEsc(Pk);
end;

{-------------Dd}
PROCEDURE Dd;
Const DD_NAME :Array[0..11] of String[6] =
             ('FLD','','FST','FSTP','FRSTOR',
              '','FSAVE','FSTSW','FFREE','FXCH',
              'FST','FSTP');
Var     I       :Word;
        Pk : Packet;
        Tmp : String[7];
begin
ReadModeByte(Pk); Wd:=False;
if Mode=3 then I:=Reg+8 else I:=Reg;
Tmp:=DD_NAME[I];
if (Tmp[0]>#0) and (I<=11) then
   begin
   if not Wait_Found then
     if (I=6) or (I=7) then  {'FSAVE','FSTSW' to no wait equivalents}
       Insert('N',Tmp,2);
   InsrtSt(Tmp); UsIndex:=SecondTab;
   if I<=3 then InsrtSt('QWORD ');
   if I<=7 then DoMem(Pk)
   else St_i;
   end
else DoEsc(Pk);
end;

{-------------Df}
PROCEDURE Df;
Const DF_NAME :Array[0..11] of String[5] =
              ('FILD','','FIST','FISTP','FBLD',
               'FILD','FBSTP','FISTP','FFREE','FXCH',
               'FST','FSTP');
Var     I       :Word;
        Pk : Packet;
begin
ReadModeByte(Pk); Wd:=False;
if Mode=3 then I:=Reg+8 else I:=Reg;    {form index}
if (I<>1) and (I<=11) then
   begin
   InsrtSt(DF_NAME[I]); UsIndex:=SecondTab;
   if I<=3 then
      begin InsrtSt('WORD '); DoMem(Pk); end
   else if I<=7 then
      begin
      if (I and 5)=4 then InsrtSt('TBYTE ') else InsrtSt('QWORD ');
      DoMem(Pk);
      end
   else St_i;
   end
else DoEsc(Pk);
end;

{-------------D9}
PROCEDURE D9;
Const D9_NAME :Array[0..11] of String[6] =
        ('FLD', '', 'FST', 'FSTP',
         'FLDENV', 'FLDCW', 'FSTENV', 'FSTCW',
         'FLD', 'FXCH', 'FNOP', 'FSTP');

Const D9_3_NAME :Array[0..29] of String[7] =
       ('FCHS','FABS','','','FTST',
        'FXAM','','','FLD1','FLDL2T',
        'FLDL2E','FLDPI','FLDLG2','FLDLN2','FLDZ',
        '','F2XM1','FYL2X','FPTAN','FPATAN',
        'FXTRACT','','FDECSTP','FINCSTP','FPREM',
        'FYL2XP1','FSQRT','','FRNDINT','FSCALE');
Var     I       :Word;
        Pk : Packet;
        Tmp : String[7];
begin
ReadModeByte(Pk);
Wd:=False;
if (Mode<>3) or (Reg<=3) then
   begin
   if Mode=3 then I:=Reg+8 else I:=Reg;
   if (I=1) or ((I=10) and (Rm<>0)) then DoEsc(Pk)
   else
      begin
      Tmp:=D9_NAME[I];
      if not Wait_Found then
        if (I=6) or (I=7) then  {'FSTENV', 'FSTCW' to no wait equivalents}
          Insert('N',Tmp,2);
      InsrtSt(Tmp);  UsIndex:=SecondTab;
      if I<=3 then InsrtSt('DWORD ');
      if I<=7 then DoMem(Pk)
      else if I<>10 then        {fnop is 10}
         St_i;  {st(i)}
      end;
   end
else
   begin        {mode=3 and reg>=4}
   I:=Rm+(Reg and 3)*8; {include lower 2 bits of reg in index}
   if (D9_3_NAME[I][0]>#0) and (I<=29) then
      InsrtSt(D9_3_NAME[I])
   else DoEsc(Pk);
   end;
end;

{-------------D8_dc}
PROCEDURE D8_dc;
Type    Nametype=Array[0..7] of Array[1..5] of Char;
Var     Shortreal       :Boolean;
        Pk : Packet;
Const   D8_dc_name : Nametype =(
          'FADD ','FMUL ','FCOM ','FCOMP','FSUB ','FSUBR','FDIV ','FDIVR');
begin
Wd:=False;
Shortreal:=Opcode=$D8;
ReadModeByte(Pk);
if not Shortreal then if (Reg>=6) then {fdiv, fdivr are reversed here}
   Reg:=Reg Xor 1;
InsrtSt(D8_dc_name[Reg]);
UsIndex:=SecondTab;
if Mode<>3 then
   begin
   if Shortreal then InsrtSt('DWORD ') else InsrtSt('QWORD ');
   DoMem(Pk);
   end
else  {mode=3}
   if Shortreal then
      begin InsrtSt('ST,'); St_i; end
   else Sti_st;                 {add the stack info}
end;

{-------------Da_de}
PROCEDURE Da_de;
Type    Nametype=Array[0..15] of Array[1..6] of Char;
Var     Shortint        :Boolean;
        Pk : Packet;
Const   Da_de_name : Nametype = (
        'FIADD ','FIMUL ','FICOM ','FICOMP','FISUB ','FISUBR','FIDIV ',
        'FIDIVR','FADDP ','FMULP ','FCOMP ','FCOMPP','FSUBRP','FSUBP ',
        'FDIVRP','FDIVP ');
begin
Wd:=False;
Shortint:=Opcode=$DA;
ReadModeByte(Pk);
if Mode<>3 then
   begin
   InsrtSt(Da_de_name[Reg]);
   UsIndex:=SecondTab;
   if Shortint then InsrtSt('DWORD ') else InsrtSt('WORD ');
   DoMem(Pk);
   end
else
   begin        {mode=3}
   if Shortint or ((Reg=3) and (Rm<>1)) then DoEsc(Pk)      {not fl pt}
   else
      begin
      InsrtSt(Da_de_name[Reg+8]);
      UsIndex:=SecondTab;
      if (Reg<>3) then Sti_st;
      end;
   end;
end;
