{$F-,A+,O+,G+,R-,S+,I+,Q-,V-,B-,X+,T-,P-,D-,L-,N-,E+}
unit ChatMode;

interface

procedure chatSplitScreen;

implementation

uses Crt,
     Global, Comm, Output, Input, Strings, ShowFile, Emulate, Transfer, Logs,
     Misc, DateTime, Tetris, StatBar, Email;

procedure chatSplitScreen;
type
   tWindow = record
      x1,y1,x2,y2,x,y : Byte;
      Col : tColorRec;{ok} {lookup}
      Word : String;
   end;

var
   InputChar   : Char;
   A           : Byte;
   Key         : Byte;
   Des         : Boolean;
   Win         : array[1..2] of tWindow;{ok}
   oldPos      : Pointer;
   dt1,dt2,dt3 : tDateTimeRec;{ok}

 procedure CheckWindows;
 begin
    if (Key <> A) then
    begin
       A := Key;
       oGotoXY(Win[A].x1+Win[A].x-1,Win[A].y1+Win[A].y-1);{lookup}
       oSetColRec(Win[A].Col);{lookup}
    end;
 end;

 procedure ClearWin(Z : Byte);
 var N : Byte; S : String;
 begin
    S := '';
    for N := Win[Z].x1 to Win[Z].x2 do S := S + ' ';
    for N := Win[Z].y1 to Win[Z].y2 do
    begin
       oGotoXY(Win[Z].x1,N);{lookup}
       oWrite(S);{lookup}
    end;
    oGotoXY(Win[Z].x1,Win[Z].y1);{lookup}
    Win[Z].x := 1; Win[Z].y := 1;
    if Des then Win[Z].Word := '';
    A := Z;
 end;

 procedure DoEnter(reDraw : Boolean);
 var S : String;
 begin
    CheckWindows;
    Inc(Win[A].y,1);
    Win[A].x := 1;
    if Win[A].y > Win[A].y2-Win[A].y1+1 then
    begin
       S := Win[A].Word;
       ClearWin(A);      {\|/lookup}
       if (reDraw) and (CleanUp(S) <> '') then
       begin
          oCWrite(S);{lookup}
          Win[A].y := 2;
          Win[A].x := 1;
       end;
    end;
    if des then Win[A].Word := '';
    oGotoXY(Win[A].x1+Win[A].x-1,Win[A].y1+Win[A].y-1);
 end;

 procedure WriteIt(S : String);
 begin
    CheckWindows;
    oCWrite(S);{lookup}
    Inc(Win[A].x,Length(S));
 end;

 procedure DoBackspace;
 begin
    if Length(Win[A].Word) < 1 then Exit;
    CheckWindows;
    oBackspace(' ');{lookup}
    if des then Delete(Win[A].Word,Length(Win[A].Word),1);
    Dec(Win[A].x,1);
 end;

 procedure CheckWrap;
 var Mx, Z, V : Byte;
 begin
    Win[A].Word := (Win[A].Word+InputChar);
    Mx := Win[A].x2-Win[A].x1;
    if (Length(Win[A].Word) >= (Mx-1)) then
    begin
       Des := False;
       Z := (Mx-1);
       while (not (Win[A].Word[Z] in [' ','-'])) and (Z <> 0) do Dec(Z,1);
       if Z = 0 then Z := Mx-1;

       Delete(Win[A].Word,1,Z);
       for V := 1 to Length(Win[A].Word) do DoBackspace;
       DoEnter(False);
       WriteIt(Win[A].Word);{lookup}
       Des := True;
    end;
 end;
begin

   GetMem(oldPos,SizeOf(sfPos));
   Move(sfPos,oldPos^,SizeOf(sfPos));

   emuScreenToANSi; {lookup}
   InputChar  := #0;

   sfShowTextFile(txChatMode,ftChatMode);{lookup}
   {This will setup the ansi file and show it to the user and sysop}

   A          := 1;
   Win[1].x1  := sfPos[1].X;
   Win[1].y1  := sfPos[1].Y;
   Win[1].x2  := sfPos[2].X;
   Win[1].y2  := sfPos[2].Y;
   Win[1].Col := sfPos[1].C;
   Win[1].x   := 1;
   Win[1].y   := 1;

   Win[2].x1  := sfPos[3].X;
   Win[2].y1  := sfPos[3].Y;
   Win[2].x2  := sfPos[4].X;
   Win[2].y2  := sfPos[4].Y;
   Win[2].Col := sfPos[3].C;
   Win[2].x   := 1;
   Win[2].y   := 1;

   ClearWin(2);
   ClearWin(1);
   oSetColRec(Win[A].Col);{lookup}
   repeat
      InputChar := iReadKey;
      if LocKey then Key := 1 else Key := 2;
      if extKey = #0 then
      case InputChar of
          #32..#254 : begin
             CheckWindows;
             WriteIt(InputChar);
             CheckWrap;
          end;
          #8  : DoBackspace;
          #13 : begin
                DoEnter(True);
          end;
      end;
   until (HangUp) or ((locKey) and (extKey = altX));

   Move(oldPos^,sfPos,SizeOf(sfPos));
   FreeMem(oldPos,SizeOf(sfPos));

   if Hangup then Exit;
   emuANSitoScreen;{lookup}

end;

end.