/*
 * This file is part of "The Java Telnet Application".
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * "The Java Telnet Application" is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
package de.mud.jta.event;

import de.mud.jta.PluginMessage;
import de.mud.jta.PluginListener;
import de.mud.jta.event.LocalEchoListener;

/**
 * Notification of the local echo property. The terminal should echo all
 * typed in characters locally of this is true.
 * <P>
 * <B>Maintainer:</B> Matthias L. Jugel
 *
 * @version $Id: LocalEchoRequest.java,v 2.1 2000/03/04 14:40:42 marcus Exp $
 * @author Matthias L. Jugel, Marcus Meiner
 */
public class LocalEchoRequest implements PluginMessage {
  protected boolean xecho = false;

  /** Create a new local echo request with the specified value. */
  public LocalEchoRequest(boolean echo) {
    xecho = echo;
  }

  /**
   * Notify all listeners about the status of local echo.
   * @param pl the list of plugin message listeners
   * @return always null
   */
  public Object firePluginMessage(PluginListener pl) {
    if(pl instanceof LocalEchoListener)
      ((LocalEchoListener)pl).setLocalEcho(xecho);
    return null;
  }
}
