/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginConfig;
import de.mud.jta.VisualTransferPlugin;
import de.mud.jta.event.SoundRequest;
import de.mud.jta.plugin.Terminal$1;
import de.mud.jta.plugin.Terminal$10;
import de.mud.jta.plugin.Terminal$11;
import de.mud.jta.plugin.Terminal$12;
import de.mud.jta.plugin.Terminal$13;
import de.mud.jta.plugin.Terminal$14;
import de.mud.jta.plugin.Terminal$15;
import de.mud.jta.plugin.Terminal$16;
import de.mud.jta.plugin.Terminal$2;
import de.mud.jta.plugin.Terminal$3;
import de.mud.jta.plugin.Terminal$4;
import de.mud.jta.plugin.Terminal$5;
import de.mud.jta.plugin.Terminal$6;
import de.mud.jta.plugin.Terminal$7;
import de.mud.jta.plugin.Terminal$8;
import de.mud.jta.plugin.Terminal$9;
import de.mud.terminal.vt320;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class Terminal
extends Plugin
implements FilterPlugin,
VisualTransferPlugin,
ClipboardOwner,
Runnable {
    protected vt320 terminal;
    protected String encoding = "latin1";
    protected SoundRequest audioBeep = null;
    protected Panel tPanel;
    protected Menu menu;
    private Thread f1 = null;
    private Hashtable f2 = new Hashtable();
    private boolean f3 = false;
    protected FilterPlugin source;

    public Terminal(PluginBus pluginBus, String string) {
        super(pluginBus, string);
        MenuItem menuItem;
        this.f2.put("black", Color.black);
        this.f2.put("red", Color.red);
        this.f2.put("green", Color.green);
        this.f2.put("yellow", Color.yellow);
        this.f2.put("blue", Color.blue);
        this.f2.put("magenta", Color.magenta);
        this.f2.put("orange", Color.orange);
        this.f2.put("pink", Color.pink);
        this.f2.put("cyan", Color.cyan);
        this.f2.put("white", Color.white);
        this.f2.put("gray", Color.white);
        this.menu = new Menu("Terminal");
        Menu menu = new Menu("Foreground");
        Menu menu2 = new Menu("Background");
        Enumeration enumeration = this.f2.keys();
        Terminal$1 terminal$1 = new Terminal$1(this);
        Terminal$2 terminal$2 = new Terminal$2(this);
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            menuItem = new MenuItem(string2);
            menu.add(menuItem);
            menuItem.addActionListener(terminal$1);
            menuItem = new MenuItem(string2);
            menu2.add(menuItem);
            menuItem.addActionListener(terminal$2);
        }
        this.menu.add(menu);
        this.menu.add(menu2);
        menuItem = new MenuItem("Smaller Font");
        this.menu.add(menuItem);
        menuItem.addActionListener(new Terminal$3(this));
        menuItem = new MenuItem("Larger Font");
        this.menu.add(menuItem);
        menuItem.addActionListener(new Terminal$4(this));
        menuItem = new MenuItem("Buffer +50");
        this.menu.add(menuItem);
        menuItem.addActionListener(new Terminal$5(this));
        menuItem = new MenuItem("Buffer -50");
        this.menu.add(menuItem);
        menuItem.addActionListener(new Terminal$6(this));
        this.menu.addSeparator();
        menuItem = new MenuItem("Reset Terminal");
        this.menu.add(menuItem);
        menuItem.addActionListener(new Terminal$7(this));
        this.terminal = new Terminal$8(this, pluginBus);
        this.tPanel = new Terminal$9(this, new BorderLayout());
        this.tPanel.add("Center", this.terminal);
        this.terminal.addFocusListener(new Terminal$10(this, pluginBus));
        pluginBus.registerPluginListener(new Terminal$11(this));
        pluginBus.registerPluginListener(new Terminal$12(this));
        pluginBus.registerPluginListener(new Terminal$13(this));
        pluginBus.registerPluginListener(new Terminal$14(this));
        pluginBus.registerPluginListener(new Terminal$15(this));
        pluginBus.registerPluginListener(new Terminal$16(this));
    }

    private void m1(PluginConfig pluginConfig) {
        int n;
        Serializable serializable;
        Object object;
        Color[] colorArray;
        Object object2;
        String string = pluginConfig.getProperty("Terminal", this.id, "foreground");
        if (string != null) {
            this.terminal.setForeground(Color.decode(string));
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "background")) != null) {
            this.terminal.setBackground(Color.decode(string));
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "print.color")) != null) {
            try {
                this.terminal.setColorPrinting(Boolean.valueOf(string));
            }
            catch (Exception exception) {
                this.error("Terminal.color.print: must be either true or false, not " + string);
            }
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "colorSet")) != null) {
            object2 = new Properties();
            try {
                ((Properties)object2).load(this.getClass().getResourceAsStream(string));
            }
            catch (Exception exception) {
                try {
                    ((Properties)object2).load(new URL(string).openStream());
                }
                catch (Exception exception2) {
                    this.error("cannot find colorSet: " + string);
                    this.error("resource access failed: " + exception);
                    this.error("URL access failed: " + exception2);
                    object2 = null;
                }
            }
            if (object2 != null) {
                colorArray = this.terminal.getColorSet();
                int n2 = 0;
                while (n2 < 8) {
                    string = ((Properties)object2).getProperty("color" + n2);
                    if (string != null) {
                        if (this.f2.get(string) != null) {
                            colorArray[n2] = (Color)this.f2.get(string);
                        } else {
                            try {
                                colorArray[n2] = Color.getColor(string) != null ? Color.getColor(string) : Color.decode(string);
                            }
                            catch (Exception exception) {
                                this.error("ignoring unknown color code: " + string);
                            }
                        }
                    }
                    ++n2;
                }
                this.terminal.setColorSet(colorArray);
            }
        }
        object2 = pluginConfig.getProperty("Terminal", this.id, "cursor.foreground");
        colorArray = pluginConfig.getProperty("Terminal", this.id, "cursor.background");
        if (object2 != null || colorArray != null) {
            try {
                Object object3 = object2 == null ? this.terminal.getBackground() : (object = Color.getColor((String)object2) != null ? Color.getColor((String)object2) : Color.decode((String)object2));
                serializable = colorArray == null ? this.terminal.getForeground() : (Color.getColor((String)colorArray) != null ? Color.getColor((String)colorArray) : Color.decode((String)colorArray));
                this.terminal.setCursorColors((Color)object, (Color)serializable);
            }
            catch (Exception exception) {
                this.error("ignoring unknown cursor color code: " + string);
            }
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "border")) != null) {
            object = string;
            boolean bl = false;
            string = pluginConfig.getProperty("Terminal", this.id, "borderRaised");
            if (string != null) {
                bl = Boolean.valueOf(string);
            }
            this.terminal.setBorder(Integer.parseInt((String)object), bl);
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "localecho")) != null) {
            this.terminal.setLocalEcho(Boolean.valueOf(string));
            this.f3 = true;
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "scrollBar")) != null && !((String)(object = string)).equals("none")) {
            if (!((String)object).equals("East") && !((String)object).equals("West")) {
                object = "East";
            }
            serializable = new Scrollbar();
            this.tPanel.add((String)object, (Component)serializable);
            this.terminal.setScrollbar((Scrollbar)serializable);
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "id")) != null) {
            this.terminal.setTerminalID(string);
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "answerback")) != null) {
            this.terminal.setAnswerBack(string);
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "buffer")) != null) {
            this.terminal.setBufferSize(Integer.parseInt(string));
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "size")) != null) {
            try {
                int n3 = string.indexOf(44);
                int n4 = Integer.parseInt(string.substring(1, n3).trim());
                n = Integer.parseInt(string.substring(n3 + 1, string.length() - 1).trim());
                this.terminal.setScreenSize(n4, n);
            }
            catch (Exception exception) {
                this.error("screen size is wrong: " + string);
                this.error("error: " + exception);
            }
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "resize")) != null) {
            if (string.equals("font")) {
                this.terminal.setResizeStrategy(2);
            } else if (string.equals("screen")) {
                this.terminal.setResizeStrategy(1);
            } else {
                this.terminal.setResizeStrategy(0);
            }
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "font")) != null) {
            String string2;
            String string3 = string;
            int n5 = 0;
            n = 12;
            string = pluginConfig.getProperty("Terminal", this.id, "fontSize");
            if (string != null) {
                n = Integer.parseInt(string);
            }
            if ((string2 = pluginConfig.getProperty("Terminal", this.id, "fontStyle")) == null || string2.equals("plain")) {
                n5 = 0;
            } else if (string2.equals("bold")) {
                n5 = 1;
            } else if (string2.equals("italic")) {
                n5 = 2;
            } else if (string2.equals("bold+italic")) {
                n5 = 3;
            }
            this.terminal.setFont(new Font(string3, n5, n));
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "keyCodes")) != null) {
            Properties properties = new Properties();
            try {
                properties.load(this.getClass().getResourceAsStream(string));
            }
            catch (Exception exception) {
                try {
                    properties.load(new URL(string).openStream());
                }
                catch (Exception exception3) {
                    this.error("cannot find keyCodes: " + string);
                    this.error("resource access failed: " + exception);
                    this.error("URL access failed: " + exception3);
                    properties = null;
                }
            }
            if (properties != null) {
                this.terminal.setKeyCodes(properties);
            }
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "VMS")) != null) {
            this.terminal.setVMS(Boolean.valueOf(string));
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "IBM")) != null) {
            this.terminal.setIBMCharset(Boolean.valueOf(string));
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "encoding")) != null) {
            this.encoding = string;
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "beep")) != null) {
            try {
                this.audioBeep = new SoundRequest(new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                this.error("incorrect URL for audio ping: " + malformedURLException);
            }
        }
        this.tPanel.setBackground(this.terminal.getBackground());
    }

    public void run() {
        byte[] byArray = new byte[256];
        int n = 0;
        while (n >= 0) {
            try {
                n = this.read(byArray);
                if (n > 0) {
                    this.terminal.putString(new String(byArray, 0, n, this.encoding));
                }
                this.tPanel.repaint();
            }
            catch (IOException iOException) {
                this.f1 = null;
                return;
            }
        }
    }

    public void setFilterSource(FilterPlugin filterPlugin) {
        this.source = filterPlugin;
    }

    public int read(byte[] byArray) throws IOException {
        return this.source.read(byArray);
    }

    public void write(byte[] byArray) throws IOException {
        this.source.write(byArray);
    }

    public Component getPluginVisual() {
        return this.tPanel;
    }

    public Menu getPluginMenu() {
        return this.menu;
    }

    public void copy(Clipboard clipboard) {
        String string = this.terminal.getSelection();
        if (string != null) {
            StringSelection stringSelection = new StringSelection(string);
            clipboard.setContents(stringSelection, this);
        }
    }

    public void paste(Clipboard clipboard) {
        if (clipboard != null) {
            Transferable transferable = clipboard.getContents(this);
            try {
                byte[] byArray = ((String)transferable.getTransferData(DataFlavor.stringFlavor)).getBytes();
                try {
                    this.write(byArray);
                    return;
                }
                catch (IOException iOException) {
                    this.f1 = null;
                    return;
                }
            }
            catch (Exception exception) {}
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        this.terminal.clearSelection();
    }

    static Hashtable access$000(Terminal terminal) {
        return terminal.f2;
    }

    static Thread access$102(Terminal terminal, Thread thread) {
        terminal.f1 = thread;
        return terminal.f1;
    }

    static Thread access$100(Terminal terminal) {
        return terminal.f1;
    }

    static boolean access$200(Terminal terminal) {
        return terminal.f3;
    }

    static void access$300(Terminal terminal, PluginConfig pluginConfig) {
        terminal.m1(pluginConfig);
    }
}

