/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginConfig;
import de.mud.jta.VisualPlugin;
import de.mud.jta.event.ConfigurationListener;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Hashtable;

public class Capture
extends Plugin
implements FilterPlugin,
VisualPlugin,
ActionListener {
    private static final boolean personalJava = false;
    private static final int debug = 1;
    protected Hashtable remoteUrlList = new Hashtable();
    protected Menu menu;
    protected Dialog dialog;
    protected boolean captureEnabled = false;
    private MenuItem start;
    private MenuItem stop;
    private MenuItem clear;
    private MenuItem save;
    private Frame frame = new Frame("Java Telnet Applet: Captured Text");
    private TextArea textArea;
    protected FilterPlugin source;

    public Capture(PluginBus bus, final String id) {
        super(bus, id);
        this.frame.setLayout(new BorderLayout());
        this.textArea = new TextArea(24, 80);
        this.frame.add((Component)this.textArea, "Center");
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ((Component)Capture.this.frame).setVisible(false);
            }
        });
        this.frame.pack();
        this.dialog = new Dialog(this.frame);
        this.dialog.setLayout(new BorderLayout());
        this.dialog.add(new Label("Cannot store data on remote server!"));
        Button close = new Button("Close Dialog");
        this.dialog.add(close);
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((Component)Capture.this.dialog).setVisible(false);
            }
        });
        this.menu = new Menu("Capture");
        this.start = new MenuItem("Start");
        this.start.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("Capture: start capturing");
                Capture.this.captureEnabled = true;
                Capture.this.start.setEnabled(false);
                Capture.this.stop.setEnabled(true);
            }
        });
        this.menu.add(this.start);
        this.stop = new MenuItem("Stop");
        this.stop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("Capture: stop capturing");
                Capture.this.captureEnabled = false;
                Capture.this.start.setEnabled(true);
                Capture.this.stop.setEnabled(false);
            }
        });
        this.stop.setEnabled(false);
        this.menu.add(this.stop);
        this.clear = new MenuItem("Clear");
        this.clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("Capture: cleared captured text");
                Capture.this.textArea.setText("");
            }
        });
        this.menu.add(this.clear);
        this.menu.addSeparator();
        MenuItem view = new MenuItem("View/Hide Text");
        view.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("view/hide text: " + Capture.this.frame.isVisible());
                if (Capture.this.frame.isVisible()) {
                    ((Component)Capture.this.frame).setVisible(false);
                    Capture.this.frame.hide();
                } else {
                    ((Component)Capture.this.frame).setVisible(true);
                    Capture.this.frame.show();
                }
            }
        });
        this.menu.add(view);
        bus.registerPluginListener(new ConfigurationListener(){

            /*
             * WARNING - void declaration
             */
            public void setConfiguration(PluginConfig config) {
                String tmp;
                int i = 1;
                while ((tmp = config.getProperty("Capture", id, i + ".url")) != null) {
                    try {
                        void var2_3;
                        String urlID = "URL." + i;
                        URL remoteURL = new URL((String)var2_3);
                        Capture.this.remoteUrlList.put(urlID, remoteURL);
                        tmp = config.getProperty("Capture", id, i + ".params");
                        if (tmp != null) {
                            Capture.this.remoteUrlList.put(urlID + ".params", tmp);
                        }
                        if ((tmp = config.getProperty("Capture", id, i + ".name")) != null) {
                            Capture.this.save = new MenuItem("Save As " + tmp);
                        } else {
                            Capture.this.save = new MenuItem("Save As " + remoteURL.toString());
                        }
                        Capture.this.save.setEnabled(true);
                        Capture.this.save.addActionListener(Capture.this);
                        Capture.this.save.setActionCommand(urlID);
                        Capture.this.menu.add(Capture.this.save);
                        ++i;
                    }
                    catch (MalformedURLException e) {
                        System.err.println("capture url invalid: " + e);
                    }
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(ActionEvent e) {
        String urlID = e.getActionCommand();
        URL url = (URL)this.remoteUrlList.get(urlID);
        System.err.println("Capture: storing text: " + urlID + ": " + this.remoteUrlList.get(urlID));
        try {
            String str;
            URLConnection urlConnection = url.openConnection();
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            DataOutputStream out = new DataOutputStream(urlConnection.getOutputStream());
            String content = (String)this.remoteUrlList.get(urlID + ".param");
            content = (content == null ? "" : content + "&") + "content=" + URLEncoder.encode(this.textArea.getText());
            System.err.println("Capture: " + content);
            out.writeBytes(content);
            out.flush();
            out.close();
            System.err.println("Capture: reading response");
            DataInputStream in = new DataInputStream(urlConnection.getInputStream());
            while (null != (str = in.readLine())) {
                void var8_9;
                System.out.println("Capture: " + (String)var8_9);
            }
            in.close();
        }
        catch (IOException ioe) {
            ((Component)this.dialog).setVisible(true);
            System.err.println("Capture: cannot store text on remote server: " + url);
            ioe.printStackTrace();
        }
        System.err.println("Capture: storage complete: " + url);
    }

    public void setFilterSource(FilterPlugin source) {
        System.err.println("Capture: connected to: " + source);
        this.source = source;
    }

    public int read(byte[] b) throws IOException {
        int size = this.source.read(b);
        if (this.captureEnabled && size > 0) {
            String tmp = new String(b, 0, size);
            this.textArea.append(tmp);
        }
        return size;
    }

    public void write(byte[] b) throws IOException {
        if (this.captureEnabled) {
            this.textArea.append(new String(b));
        }
        this.source.write(b);
    }

    public Component getPluginVisual() {
        return null;
    }

    public Menu getPluginMenu() {
        return this.menu;
    }
}

