unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Winsock, WinCrt, Globals, About
  WinDos;

const
  RevNo = '1.00';
  Author = 'nivenh';
  progname = 'telimp';

var
  IntSave : Pointer;

type
  TtelimpForm = class(TForm)
    StatusBevel: TBevel;
    StatusPrompt: TLabel;
    StatusMsg: TLabel;
    QuitButton: TButton;
    SetupButton: TButton;
    InfoButton: TButton;
    Service: TButton;
    ResultBox: TMemo;
    procedure QuitButtonClick(Sender: TObject);
    procedure ServiceClick(Sender: TObject);
    procedure InfoButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  telimpForm: TtelimpForm;
  resultboxLines: longint;
  listening: boolean;
  myVerReqd : word;
  myWSAData : WSADATA;
  TelnetPort : word;
  hInstance : THandle;
  WindowClass : TWndClass;
  cClass : pchar;
  UserChar : Char;
  SendChar : Char;
  {
  s : String[255];
  i : integer;
  CharArray: array[0..255] of char;
  HostNameArray: array[0..255] of char;
  }
  TelnetSocket, AcceptSocket : tSOCKET;
  err : integer;
  Remote_Addr: sockaddr_in;
  Remote_Host: Phostent;
  CanWrite: Boolean;
  GotString: Boolean;
  GotEOF: Boolean;
  Hangup : boolean;
  ThisLen : integer;
  ThisAddr : sockaddr;
  Aborted : boolean;
  DummyWin : HWND;
  Connected : boolean;
  OldWndProc : TFarProc;
  {
  Userid : String;
  }

Const
  USER_CONNECT         = WM_USER + 100;
  USER_READ            = WM_USER + 101;
  USER_WRITE           = WM_USER + 102;

procedure initStuff;

implementation

{$R *.DFM}

var
  TXBuffer : array [0..1024] of char;

procedure FindTelnetService; forward;
procedure CreateSocket; forward;
procedure BindToSocket; forward;
procedure ListenToSocket; forward;


function value(i : word) : string;
var
  S: String[5];
begin
  Str(i, S);
  Value := S;
end;

procedure Abort(msg : string);
var i : word;
begin
  i := MessageDlg('Error in: '+msg, mtError, [mbOK], 0);
  aborted := true;
end;

procedure error(msg : string);
var i : word;
begin
  i := MessageDlg('Error in: '+msg, mtWarning, [mbOK], 0);
  aborted := true;
end;

procedure AddMsg(s : string);
begin
telimpForm.ResultBox.Lines.Add(s);
end;

procedure tWrite(AString: String);
var
  AText : Array[0..255] of char;
begin
  strPcopy(AText,AString);
  StrCat(TXBuffer,AText);
  Send(AcceptSocket, AText, Length(AString), 0);
  {SendUserWriteMessage;}
  Write(AString);
end;

procedure tWriteLN(AString: String);
begin
  tWrite(AString+^M^J);
end;


procedure deinitstuff;
begin
  AddMsg('Session Ending.');
  closeSocket(AcceptSocket);
  closeSocket(TelnetSocket);
  if WSACleanup <> 0 then Error('WSACleanup');
end;

procedure TtelimpForm.QuitButtonClick(Sender: TObject);
begin
deinitstuff;
telimpForm.Close;
aboutBox.Close;
end;

procedure FindTelnetService;
var
  pSE : pServEnt;
begin
  TelnetPort := 0;
  pSE := getservbyname('telnet','tcp');
  if pSE = nil then begin
    Error('GetServByName');
    AddMsg('Telnet is usually on port 23.  Check Services table.');
  end
  else begin
    TelnetPort := htons(pSE^.s_port);
    AddMsg('Using Telnet service on port '+Value(TelnetPort));
  end;
end;

procedure CreateSocket;
begin
  TelnetSocket:=socket(PF_INET, SOCK_STREAM, IPPROTO_IP);
  If TelnetSocket = INVALID_SOCKET then Abort('Can''t CreateSocket')
  else
    AddMsg('Socket descriptor allocated :  '+Value(ord(TelnetSocket)));
end;

procedure BindToSocket;
begin
  Remote_addr.sin_family := PF_INET;
  Remote_addr.sin_port := htons(TelnetPort);
  Remote_addr.sin_addr.s_addr:=INADDR_ANY;
  if bind(TelnetSocket, sockaddr(Remote_Addr), SizeOf(Remote_Addr)) <> 0 then
  begin
    CloseSocket(TelnetSocket);
    Abort('Bind');
  end;
end;

procedure ListenToSocket;
var
  rc : integer;
begin
  rc := listen(TelnetSocket,5);
  if rc > 0 then Error('Listen');
  rc := rc + WSAAsyncSelect(TelnetSocket, dummyWin, USER_CONNECT, FD_ACCEPT);
  if rc > 0 then begin
    CloseSocket(TelnetSocket);
    Abort('WSAAsyncSelect');
  end;
end;

Function GetChar : char;
var
  ch : char;
  count : integer;
begin
  Repeat
    count := recv(AcceptSocket, @ch, 1, 0);
    if WSAGetLastError <> 0 then ;
  until count = 1;
  GetChar := ch;
end;

function WindowProc(Window:HWnd; Message,wParam:Word; lParam:LongInt) : LongInt; export;
begin
AddMsg(IntToStr(Message));
Writeln(IntToStr(Message));
if Message = USER_CONNECT then
  begin
  connected := true;
  {AddMsg('Received a USER_CONNECT message');}
  ThisLen := SizeOf(Remote_Addr);
  ThisAddr := SockAddr(Remote_Addr);
  AcceptSocket := accept(TelnetSocket, @ThisAddr, @ThisLen);
  TelimpForm.StatusMsg.Caption := 'Connected.';{ to '+AcceptSocket;}
  if AcceptSocket=INVALID_SOCKET  then
    begin
    Error('AcceptSocket');
    exit;
    end;
  tWriteLN('Connected through TELNET port '+Value(TelnetPort));
  tWriteLN('Telimp '+RevNo);
  end;
(*
if Message = USER_READ then
  begin{characters received}
  WSAAsyncSelect(AcceptSocket, dummywin, USER_WRITE, FD_WRITE);
  {Handle Received Characters}
  UserChar := GetChar;{RXBuffer[0];}
  tWrite(UserChar);
  end;
if Message = USER_WRITE then
  begin      {characters sent}
  WSAAsyncSelect(AcceptSocket, dummywin, USER_READ, FD_READ);  {notify on rx}
  tWrite(SendChar);
  {
  SendCount :=Send(AcceptSocket,TXBuffer,StrLen(TxBuffer),0);
  if (SendCount = SOCKET_ERROR) and (WSAGetLastError = WSAEWOULDBLOCK)then
    begin
      Repeat
      Delay(50);
      until Send(AcceptSocket,TXBuffer,StrLen(TxBuffer),0) <> SOCKET_ERROR;
    end;
  For i := 0 to StrLen(TxBuffer) do write(TXBuffer[i]) ;
    strCopy(TXBuffer,'');
  }
  end;
*)
WindowProc := CallWindowProc(OldWndProc, Window, Message, wParam, lParam);
end;

procedure myInitWinCRT;
begin
  {
  GetIntVec($14, IntSave);
  SetIntVec($14, Addr(CaptureInt));
  }
  InitWinCrt;
  DummyWin := GetActiveWindow;
  WindowClass.lpfnWndProc := @WindowProc;
  Writeln('Impulse Server Enabled.');
  Writeln('Listening on port 23.');
end;

procedure initStuff;
begin
cClass := 'TPWinCrt';
GetClassInfo(hInstance, cClass ,WindowClass);
WinProcs.UnregisterClass(cClass, hInstance);
WindowClass.hIcon := LoadIcon(0, idi_Question);
WindowClass.hCursor := LoadCursor(0, idc_Arrow);
OldWndProc := tFarProc(WindowClass.lpfnWndProc);
WindowClass.lpfnWndProc := @WindowProc;
WinProcs.RegisterClass(WindowClass);
AutoTracking := true;
ScreenSize.X :=25; ScreenSize.Y :=6;
StrCopy(WindowTitle,'Server Daemon');
aborted := false;
myVerReqd:=$0101;
with telimpForm do
  begin
  AddMsg('Telimp Running.');
  AddMsg('Version '+RevNo);
  AddMsg('Winsock version required :  '+
         value(hibyte(myVerReqd))+'.'+
         value(lobyte(myVerReqd)));
  end;
if WSAStartup(myVerReqd,@myWSAData) <> 0 then Abort('WSAStartup');
listening := false;
FindTelnetService;
CreateSocket;
BindToSocket;
ListenToSocket;
end;


procedure TtelimpForm.ServiceClick(Sender: TObject);
begin
if (not listening) then
  begin
  {WindowOrg.X := TelimpForm.Top;
  WindowOrg.Y := TelimpForm.Left;}
  myInitWinCrt;
  {DummyWin := GetActiveWindow;}
  listening := true;
  AddMsg('Daemon Enabled');
  Service.Caption := 'Disable';
  end
else
  begin
  listening := not listening;
  DoneWinCrt;
  {SetIntVec($14, IntSave);}
  AddMsg('Daemon Disabled.');
  Service.Caption := 'Enable';
  end;
end;

procedure TtelimpForm.InfoButtonClick(Sender: TObject);
begin
AboutBox.Top := TelimpForm.Top + 40;
AboutBox.Left := TelimpForm.Left  + 45;
AboutBox.Show;
end;

end.
