unit Globals;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Dialogs, StdCtrls, ExtCtrls, Winsock, WinCrt,
  WinDos;

const
  setupFileName = 'TELIMP.DAT';

type
  setuprec = record
             comport : word;
             speed : word;
             servermsg : array [1..4] of string;
             impdir : string;
             Nodetoload : byte;
             impcmdline : string;
             end;

var
  setup : setuprec;
  setupf : file of setuprec;

Procedure CaptureInt(VAR AX, DX, AH, AL : word); Interrupt;
Procedure InitSetupRec;

implementation

Procedure InitSetupRec;
Begin
if FileExists(SetupFileName) then
  begin
  assign(SetupF, SetupFileName);
  reset(setupf);
  read(setupf, setup);
  close(setupf);
  end
else
  begin
  assign(setupF, SetupFileName);
  rewrite(setupf);
  with setup do
    begin
    comport := 99;
    speed := 19200;
    fillchar(servermsg, sizeOf(serverMsg), 0);
    impdir := 'c:\imp';
    Nodetoload := 1;
    impcmdline := 'imp -b%SPEED% -m%NODE% -q';
    end;
  write(setupf, setup);
  close(setupf);
  end;
end;

{$F+}
Procedure CaptureInt(VAR AX, DX, AH, AL : word);
begin
  { init fossil }
  if (AH = $04) and (DX = (Setup.Comport-1)) then
    AX := $1954;
  { deinit fossil }
  if (AH = $05) and (DX = (Setup.Comport-1)) then
    {Hangup := true};
  if (AH = $03) and (DX = (Setup.Comport-1)) then
    {Connected := true};
  if (AH = $02) and (DX = (Setup.Comport-1)) then
    {AL := Ord(UserChar)};
  if (AH = $01) and (DX = (Setup.Comport-1)) then
    {SendChar := Chr(AL)};
end;
{$F-}

end.
