{$I M_OPS.PAS}

Unit Mystic_FTP;

Interface

Uses
  m_Socket_Class,
  Sock_Server,
  BBS_Common;

Function CreateFTP (Owner: TServerManager; CliSock: TSocketClass) : TServerClient;

Type
  TFTPServer = Class(TServerClient)
    Server   : TServerManager;
    UserName : String[40];
    Password : String[20];
    LoggedIn : Boolean;
    Cmd      : String;
    Data     : String;
    User     : recUser;
    UserPos  : LongInt;

    Constructor Create (Owner: TServerManager; CliSock: TSocketClass);
    Procedure   Execute; Override;
    Destructor  Destroy; Override;

    Procedure   ResetSession;
    Procedure   cmdUSER;
    Procedure   cmdPASS;
    Procedure   cmdREIN;
  End;

Implementation

Uses
  BBS_User,
  m_Strings;

Const
  FTPTimeOut     = 120;  // Make this configurabe in MCFG?

  re_UserOkay    = '331 User okay. Password required';
  re_UserUnknown = '530 Unknown user';
  re_BadCommand  = '503 Bad sequence of commands';
  re_LoggedIn    = '230 User logged in, proceed';
  re_BadPW       = '530 Login or password incorrect';
  re_Greeting    = '220 Mystic FTP Server ready';
  re_CommandOK   = '200 Command successful';
  re_NoCommand   = '202 Unknown command: ';
  re_Goodbye     = '221 Goodbye';

Function CreateFTP (Owner: TServerManager; CliSock: TSocketClass) : TServerClient;
Begin
  Result := TFTPServer.Create(Owner, CliSock);
End;

Constructor TFTPServer.Create (Owner: TServerManager; CliSock: TSocketClass);
Begin
  Inherited Create(Owner, CliSock);

  Server := Owner;
End;

Procedure TFTPServer.ResetSession;
Begin
  LoggedIn := False;
  UserName := '';
  Password := '';
  UserPos  := -1;
End;

Procedure TFTPServer.cmdUSER;
Begin
  ResetSession;

  If SearchForUser(Data, User, UserPos) Then Begin
    Client.WriteLine(re_UserOkay);
    UserName := Data;
  End Else
    Client.WriteLine(re_UserUnknown);
End;

Procedure TFTPServer.cmdPASS;
Begin
  If (UserName = '') or (UserPos = -1) Then Begin
    Client.WriteLine(re_BadCommand);
    Exit;
  End;

  If strUpper(Data) = User.Password Then Begin
    LoggedIn := True;
    Client.WriteLine(re_LoggedIn);
  End Else
    Client.WriteLine(re_BadPW);
End;

Procedure TFTPServer.cmdREIN;
Begin
  ResetSession;
  Client.WriteLine(re_Greeting);
End;

Procedure TFTPServer.Execute;
Var
  Str : String;
Begin
  cmdREIN;

  Repeat
    If Client.WaitForData(FTPTimeOut * 1000) = 0 Then Begin
      //Server.Server.Status('Client timed out');
      Break;
    End;

    If Terminated Then Exit;

    Client.ReadLine(Str);

    Cmd  := strUpper(strWordGet(1, Str, ' '));
    Data := Copy(Str, Pos(' ', Str) + 1, Length(Str));

//    Server.Server.Status(Cmd + ' ' + Data);

    If Cmd = 'NOOP' Then Client.WriteLine(re_CommandOK) Else
    If Cmd = 'PASS' Then cmdPass Else
    If Cmd = 'QUIT' Then Break Else
    If Cmd = 'REIN' Then cmdREIN Else
    If Cmd = 'USER' Then cmdUser Else
      Client.WriteLine(re_NoCommand + Cmd);
  Until Terminated;

  If Not Terminated Then Client.WriteLine(re_Goodbye);
End;

Destructor TFTPServer.Destroy;
Begin
  Inherited Destroy;
End;

End.
