{$I M_OPS.PAS}

Unit MCFG_MBases;

Interface

Procedure MessageBaseEditor;

Implementation

Uses
  m_Strings,
  m_MenuBox,
  m_MenuForm,
  m_FileIO,
  MCFG_Common,
  MCFG_SysConfig;

Var
  MBaseFile : TBufFile;
  MBase     : RecMessageBase;

Procedure EditMessageBase;
Var
  Box   : TMenuBox;
  Form  : TMenuForm;
  Topic : String;
Begin
  Topic := '|03(|09Message Base Edit|03) |01-|09> |15';
  Box   := TMenuBox.Create(Console);
  Form  := TMenuForm.Create(Console);

  Box.Open (3, 5, 77, 21);

  VerticalLine (17,  6, 20);
  VerticalLine (66,  6, 19);

  Form.AddStr  ('N', ' Name '        , 11,  6, 19,  6,  6, 30, 40, @MBase.Name, Topic + 'Message base description');
  Form.AddStr  ('W', ' Newsgroup '   ,  6,  7, 19,  7, 11, 30, 80, @MBase.NewsName, Topic + 'Newsgroup name (Blank/Disabled)');
  Form.AddStr  ('F', ' File Name '   ,  6,  8, 19,  8, 11, 30, 40, @MBase.FileName, Topic + 'Message base storage file name');
  Form.AddPath ('P', ' Path '        , 11,  9, 19,  9,  6, 30, 60, @MBase.Path, Topic + 'Message base storage path');
  Form.AddStr  ('L', ' List ACS '    ,  7, 10, 19, 10, 10, 30, 30, @MBase.ListACS, Topic + 'Access required to see in base list');
  Form.AddStr  ('R', ' Read ACS '    ,  7, 11, 19, 11, 10, 30, 30, @MBase.ReadACS, Topic + 'Access required to read messages');
  Form.AddStr  ('P', ' Post ACS '    ,  7, 12, 19, 12, 10, 30, 30, @MBase.PostACS, Topic + 'Access required to post messages');
  Form.AddStr  ('Y', ' Sysop ACS '   ,  6, 13, 19, 13, 11, 30, 30, @MBase.SysopACS, Topic + 'Access required for Sysop access');
  Form.AddTog  ('O', ' Post Type '   ,  6, 14, 19, 14, 11,  7,  0, 1, 'Public Private', @MBase.PostType, Topic + 'Message posting type');
  Form.AddTog  ('A', ' Base Type '   ,  6, 15, 19, 15, 11,  9,  0, 3, 'Local EchoMail NetMail Newsgroup', @MBase.NetType, Topic + 'Message base type');
  Form.AddNone ('D', ' Net Address'  ,  4, 16, 13, Topic + 'NetMail Address');
  Form.AddStr  ('I', ' Origin '      ,  9, 17, 19, 17,  8, 30, 50, @MBase.Origin, Topic + 'Message base origin line');
  Form.AddStr  ('S', ' Sponsor '     ,  8, 18, 19, 18,  9, 30, 30, @MBase.Sponsor, Topic + 'User name of base''s sponser');
  Form.AddStr  ('H', ' Header '      ,  9, 19, 19, 19,  8, 20, 20, @MBase.Header, Topic + 'Display file name of msg header');
  Form.AddStr  ('T', ' Template '    ,  7, 20, 19, 20, 10, 20, 20, @MBase.Template, Topic + 'Display file name of template');
  Form.AddAttr ('Q', ' Quote Color ' , 53,  6, 68,  6, 13, @MBase.ColorQuote, Topic + 'Color for quoted text');
  Form.AddAttr ('X', ' Text Color '  , 54,  7, 68,  7, 12, @MBase.ColorText, Topic + 'Color for message text');
  Form.AddAttr ('E', ' Tear Color '  , 54,  8, 68,  8, 12, @MBase.ColorTear, Topic + 'Color for tear line');
  Form.AddAttr ('G', ' Origin Color ', 52,  9, 68,  9, 14, @MBase.ColorOrigin, Topic + 'Color for origin line');
  Form.AddAttr ('K', ' Kludge Color ', 52, 10, 68, 10, 14, @MBase.ColorKludge, Topic + 'Color for kludge line');

  Form.AddWord ('M', ' Max Msgs '    , 56, 11, 68, 11, 10, 5, 0, 65535, @MBase.MaxMsgs, Topic + 'Maximum number of message in base');
  Form.AddWord ('1', ' Max Msg Age ' , 53, 12, 68, 12, 13, 5, 0, 65535, @MBase.MaxAge, Topic + 'Maximum age (days) to keep messages');
  Form.AddBol  ('C', ' New Scan '    , 56, 13, 68, 13, 10, 3, @MBase.NewScan, Topic + 'Base is in user''s newscan by default?');
  Form.AddBits ('2', ' Forced '      , 58, 14, 68, 14,  8, RecMessageForced, @MBase.Flags, Topic + 'Force users to read this base?');
  Form.AddBits ('3', ' Real Names '  , 54, 15, 68, 15, 12, RecMessageRealName, @MBase.Flags, Topic + 'Use real names in this base?');
  Form.AddBits ('4', ' Autosigs '    , 56, 16, 68, 16, 10, RecMessageAutoSig, @MBase.Flags, Topic + 'Allow auto signatures in this base?');
  Form.AddBits ('5', ' Attachments ' , 53, 17, 68, 17, 13, RecMessageFAttach, @MBase.Flags, Topic + 'Allow file attachments in this base?');
  Form.AddBits ('6', ' Kill Kludge ' , 53, 18, 68, 18, 13, RecMessageKFilter, @MBase.Flags, Topic + 'Filter out kludge lines');
  Form.AddTog  ('B', ' Base Format ' , 53, 19, 68, 19, 13,  6,  0, 1, 'JAM Squish', @MBase.BaseType, Topic + 'Message base storage format');

  Repeat
    Console.WriteXY (19, 16, 113, strPadR(strAddr(bbsConfig.NetAddress[MBase.NetAddr]), 19, ' '));

    Case Form.Execute of
      'D' : MBase.NetAddr := NetworkAddress(False);
      #27 : Break;
    End;
  Until False;

  Box.Close;

  Form.Free;
  Box.Free;
End;

Procedure MessageBaseEditor;
Var
  Box       : TMenuBox;
  List      : TMenuList;
  MIndex    : LongInt;

  Procedure MakeList;
  Var
    Tag : Byte;
  Begin
    List.Clear;

    MBaseFile.Reset;
    While Not MBaseFile.EOF Do Begin
      If MBaseFile.FilePos = 0 Then Tag := 2 Else Tag := 0;
      MBaseFile.Read (MBase);
      List.Add(strPadR(strI2S(MBaseFile.FilePos), 5, ' ') + '  ' + strStripMCI(MBase.Name), Tag);
    End;

    List.Add('', 2);
  End;

  Procedure AssignRecord (Email: Boolean);
  Begin
    MIndex := List.Picked;

    MBaseFile.Reset;
    While Not MBaseFile.EOF Do Begin
      MBaseFile.Read (MBase);
      If MIndex = MBase.Idx Then Begin
        Inc (MIndex);
        MBaseFile.Reset;
      End;
    End;

    MBaseFile.RecordInsert (List.Picked);

    FillChar (MBase, SizeOf(RecMessageBase), 0);

    With MBase Do Begin
      Idx         := MIndex;
      FileName    := 'newmsgbase';
      Path        := bbsConfig.PathMsgs;
      Name        := 'New Message Base';
      NewsName    := '';
      NewScan     := True;
      MaxMsgs     := 500;
      MaxAge      := 365;
      Header      := 'msgheader';
      Template    := 'ansimsgread';
      ListACS     := '';
      SysopACS    := 's255';
      NetAddr     := 1;
      ColorQuote  := bbsConfig.ColorQuote;
      ColorText   := bbsConfig.ColorText;
      ColorTear   := bbsConfig.ColorTear;
      ColorOrigin := bbsConfig.ColorOrigin;
      ColorKludge := bbsConfig.ColorKludge;
      Flags       := 0;
      Flags       := RecMessageFAttach AND RecMessageAutoSig AND RecMessageKFilter;

      If Email Then Begin
        FileName := 'email';
        Name     := 'Electronic Mail';
        Idx      := 0;
        PostType := 1;
      End;
    End;

    MBaseFile.Write(MBase);
  End;

  Procedure GlobalEdit;
  Var
    Temp : RecMessageBase;
    OK   : Array[1..21] of Boolean;
  Begin
  End;

(*
  Procedure GlobalEdit;
  Var
    GBox  : cmBoxPTR;
    Input : cmInputPTR;
    OK    : Array[1..21] of Boolean;
    Count : Word;
    Pos   : Byte;
    Temp  : MBaseRec;
  Begin
    If List^.Marked = 0 Then Begin
      ShowMsgBox (0, 'You must tag areas for global editing');
      Exit;
    End;

    FillChar (Temp, SizeOf(Temp), #0);
    FillChar (OK,   SizeOf(OK),   #0);

    New (GBox, Init(True));
    New (Input, Init);

    Input^.HiChars  := #72#80;
    Input^.LoChars  := #21#27;
    GBox^.FrameType := 4;
    GBox^.BoxAttr   := 3;

    GBox^.Open (1, 1, 79, 25);

    FastWrite ( 3, 2, 'Modify', 3);
                FastWrite (24, 2, 'CTRL-U: Accept Changes', 3);
    FastWrite (60, 2, 'Global Base Editor', 3);
    FastWrite ( 2, 3, Replicate('', 77), 3);

    For Count := 1 to 21 Do
      FastWrite (3, 3 + Count, '[   ]', 3);

        FastWrite (10,  4, 'Storage Path', 3);
                FastWrite (10,  5, 'List ACS', 3);
                FastWrite (10,  6, 'Read ACS', 3);
                FastWrite (10,  7, 'Post ACS', 3);
                FastWrite (10,  8, 'Sysop ACS', 3);
                FastWrite (10,  9, 'Password', 3);
                FastWrite (10, 10, 'Def New Scan', 3);
                FastWrite (10, 11, 'Def Qwk Scan', 3);
                FastWrite (10, 12, 'Real Names', 3);
                FastWrite (10, 13, 'Max Messages', 3);
                FastWrite (10, 14, 'Max Msg Age', 3);
                FastWrite (10, 15, 'Base Format', 3);
                FastWrite (10, 16, 'Post Type', 3);
                FastWrite (10, 17, 'Base Type', 3);
                FastWrite (10, 18, 'Net Address', 3);
                FastWrite (10, 19, 'Origin Line', 3);
                FastWrite (10, 20, 'Quote Color', 3);
                FastWrite (10, 21, 'Text Color', 3);
                FastWrite (10, 22, 'Tear Color', 3);
                FastWrite (10, 23, 'Origin Color', 3);
                FastWrite (10, 24, 'Header File', 3);

    Pos := 1;

                Temp.Origin    := Config.Origin;
                Temp.Path      := Config.MsgsPath;
                Temp.ColQuote  := Config.MsgColorQuote;
                Temp.ColText   := Config.MsgColorText;
                Temp.ColTear   := Config.MsgColorTear;
                Temp.ColOrigin := Config.MsgColorOrigin;
                Temp.NetAddr   := 1;

    Repeat
      For Count := 1 to 21 Do
        WriteYN (4, 3 + Count, OK[Count], 7);

                        FieldWrite (24,  4, Temp.Path, 40);
                        FieldWrite (24,  5, Temp.ACS, 20);
                        FieldWrite (24,  6, Temp.ReadACS, 20);
                        FieldWrite (24,  7, Temp.PostACS, 20);
                        FieldWrite (24,  8, Temp.SysopACS, 20);
                        FieldWrite (24,  9, Temp.Password, 15);
                        FieldWrite (24, 10, ScanStr[Temp.DefNScan], 6);
                        FieldWrite (24, 11, ScanStr[Temp.DefQScan], 6);
                        WriteYN    (24, 12, Temp.UseReal, 7);
                        FieldWrite (24, 13, Int2Str(Temp.MaxMsgs), 5);
                        FieldWrite (24, 14, Int2Str(Temp.MaxAge), 5);
                        FieldWrite (24, 15, BaseStr[Temp.BaseType], 6);
                        FieldWrite (24, 16, PostStr[Temp.PostType], 7);
                        FieldWrite (24, 17, NetStr[Temp.NetType], 9);
                        FieldWrite (24, 18, AddrType2Str(Config.NetAddr[Temp.NetAddr]), 19);
                        FieldWrite (24, 19, Temp.Origin, 50);
                        FastWrite  (24, 20, 'XX> Quote', Temp.ColQuote);
                        FastWrite  (24, 21, 'Text', Temp.ColText);
                        FastWrite  (24, 22, '--- Tear', Temp.ColTear);
                        FastWrite  (24, 23, '* Origin:', Temp.ColOrigin);
                        FieldWrite (24, 24, Temp.Header, 8);

      If Odd(Pos) Then Begin
        Count := Pos DIV 2 + 1;
        OK[Count] := Input^.GetYN(4, 3 + Count, OK[Count]);
      End Else
        Case Pos of
                                        2 : Temp.Path     := CheckPath(Input^.GetStr(24, 4, 40, 40, InMode, Temp.Path));
                                        4 : Temp.ACS      := Input^.GetStr(24, 5, 20, 20, 1, Temp.ACS);
                                        6 : Temp.ReadACS  := Input^.GetStr(24, 6, 20, 20, 1, Temp.ReadACS);
                                        8 : Temp.PostACS  := Input^.GetStr(24, 7, 20, 20, 1, Temp.PostACS);
                                        10: Temp.SysopACS := Input^.GetStr(24, 8, 20, 20, 1, Temp.SysopACS);
                                        12: Temp.Password := Input^.GetStr(24, 9, 15, 15, 2, Temp.Password);
                                        14: If Input^.GetEnter(24, 10, 6, ScanStr[Temp.DefNScan]) Then
                                                                If Temp.DefNScan < 2 Then Inc(Temp.DefNScan) Else Temp.DefNScan := 0;
                                        16: If Input^.GetEnter(24, 11, 6, ScanStr[Temp.DefQScan]) Then
                                                                If Temp.DefQScan < 2 Then Inc(Temp.DefQScan) Else Temp.DefQScan := 0;
                                        18: Temp.UseReal := Input^.GetYN(24, 12, Temp.UseReal);
                                        20: Temp.MaxMsgs := Input^.GetNum(24, 13, 5, 5, 0, 65535, Temp.MaxMsgs);
                                        22: Temp.MaxAge  := Input^.GetNum(24, 14, 5, 5, 0, 65535, Temp.MaxAge);
                                        24: If Input^.GetEnter(24, 15, 6, BaseStr[Temp.BaseType]) Then
                                                                If Temp.BaseType = 0 Then Temp.BaseType := 1 Else Temp.BaseType := 0;
                                        26: If Input^.GetEnter(24, 16, 7, PostStr[Temp.PostType]) Then
                                                                If Temp.PostType = 0 Then Temp.PostType := 1 Else Temp.PostType := 0;
                                        28: If Input^.GetEnter(24, 17, 9, NetStr[Temp.NetType]) Then
                                                                If Temp.NetType < 3 Then Inc(Temp.NetType) Else Temp.NetType := 0;
                                        30: If Input^.GetEnter(24, 18, 19, AddrType2Str(Config.NetAddr[Temp.NetAddr])) Then
                                                                Temp.NetAddr := Network_Address(False);
                                        32: Temp.Origin := Input^.GetStr(24, 19, 50, 50, 1, Temp.Origin);
                                        34: If Input^.GetEnter(24, 20, 9, 'XX> Quote') Then
                                                                Temp.ColQuote := GetColorAttr(Temp.ColQuote);
                                        36: If Input^.GetEnter(24, 21, 4, 'Text') Then
                                                                Temp.ColText := GetColorAttr(Temp.ColText);
                                        38: If Input^.GetEnter(24, 22, 8, '--- Tear') Then
                                                                Temp.ColTear := GetColorAttr(Temp.ColTear);
                                        40: If Input^.GetEnter(24, 23, 9, '* Origin:') Then
                                                                Temp.ColOrigin := GetColorAttr(Temp.ColOrigin);
                                        42: Temp.Header := Input^.GetStr(24, 24, 8, 8, InMode, Temp.Header);
        End;

      Case Input^.ExitCode of
        #21 : Begin
                For Count := 1 to List^.ListMax Do
                  If List^.List[Count]^.Tagged = 1 Then Begin
                    Seek (MBaseFile, Count - 1);
                    Read (MBaseFile, MBase);

                                                                                If OK[1]  Then MBase.Path      := Temp.Path;
                                                                                If OK[2]  Then MBase.ACS       := Temp.ACS;
                                                                                If OK[3]  Then MBase.ReadACS   := Temp.ReadACS;
                                                                                If OK[4]  Then MBase.PostACS   := Temp.PostACS;
                                                                                If OK[5]  Then MBase.SysopACS  := Temp.SysopACS;
                                                                                If OK[6]  Then MBase.Password  := Temp.Password;
                                                                                If OK[7]  Then MBase.DefNScan  := Temp.DefNScan;
                                                                                If OK[8]  Then MBase.DefQScan  := Temp.DefQScan;
                                                                                If OK[9]  Then MBase.UseReal   := Temp.UseReal;
                                                                                If OK[10] Then MBase.MaxMsgs   := Temp.MaxMsgs;
                                                                                If OK[11] Then MBase.MaxAge    := Temp.MaxAge;
                                                                                If OK[12] Then MBase.BaseType  := Temp.BaseType;
                                                                                If OK[13] Then MBase.PostType  := Temp.PostType;
                                                                                If OK[14] Then MBase.NetType   := Temp.NetType;
                                                                                If OK[15] Then MBase.NetAddr   := Temp.NetAddr;
                                                                                If OK[16] Then MBase.Origin    := Temp.Origin;
                                                                                If OK[17] Then MBase.ColQuote  := Temp.ColQuote;
                                                                                If OK[18] Then MBase.ColText   := Temp.ColText;                                                                                If OK[19] Then MBase.ColTear   := Temp.ColTear;
                                                                                If OK[20] Then MBase.ColOrigin := Temp.ColOrigin;
                                                                                If OK[21] Then MBase.Header    := Temp.Header;

                    Seek  (MBaseFile, Count - 1);
                    Write (MBaseFile, MBase);
                  End;

                Break;
              End;
        #27 : Break;
        #72 : If Pos > 1 Then Dec(Pos);
        #80 : If Pos < 42 Then Inc(Pos);
      End;

    Until False;

    GBox^.Close;

    Dispose (Input, Done);
    Dispose (GBox, Done);
  End;
*)

Begin
  MBaseFile := TBufFile.Create(4096);

  If Not MBaseFile.Open(bbsConfig.PathData + 'mbases.dat', fmOpenCreate, fmReadWrite + fmDenyNone, SizeOf(RecMessageBase)) Then Begin
    MBaseFile.Free;
    Exit;
  End;

  Box  := TMenuBox.Create(Console);
  List := TMenuList.Create(Console);

  //        StatusBot('CTRL+ (I) Insert (D) Delete (O) Sort (SPACE) Tag (G) Global (ENTER) Edit');

  List.NoWindow := True;
  List.LoChars  := #01#04#07#13#15#27;
  List.AllowTag := True;

  If MBaseFile.FileSize = 0 Then AssignRecord(True);

  Box.Open (15, 5, 65, 21);

  Console.WriteXY (17,  6, 112, '#####  Message Base Description');
  Console.WriteXY (16,  7, 112, strRep('', 49));
  Console.WriteXY (16, 19, 112, strRep('', 49));
  Console.WriteXY (18, 20, 112, '(ENTER/Edit)   CTRL+ (A)dd (D)elete (G)lobal');

  Repeat
    MakeList;

    List.Open (15, 7, 65, 19);
    List.Close;

    Case List.ExitCode of
      #01 : If List.Picked > 1 Then Begin
              AssignRecord(False);
              MakeList;
            End;
      #04 : If (List.Picked > 1) and (List.Picked < List.ListMax) Then
              If ShowMsgBox(1, 'Delete this entry?') Then Begin
                MBaseFile.Seek (List.Picked - 1);
                MBaseFile.Read (MBase);

                MBaseFile.RecordDelete (List.Picked);

                If ShowMsgBox(1, 'Delete message base data files?') Then Begin
                  FileErase (MBase.Path + MBase.FileName + '.jhr');
                  FileErase (MBase.Path + MBase.FileName + '.jlr');
                  FileErase (MBase.Path + MBase.FileName + '.jdt');
                  FileErase (MBase.Path + MBase.FileName + '.jdx');
                  FileErase (MBase.Path + MBase.FileName + '.sqd');
                  FileErase (MBase.Path + MBase.FileName + '.sqi');
                  FileErase (MBase.Path + MBase.FileName + '.sql');
                  FileErase (MBase.Path + MBase.FileName + '.scn');
                End;

                MakeList;
              End;
      #07 : GlobalEdit;
      #13 : If List.Picked < List.ListMax Then Begin
              MBaseFile.Seek (List.Picked - 1);
              MBaseFile.Read (MBase);
              EditMessageBase;
              MBaseFile.Seek  (List.Picked - 1);
              MBaseFile.Write (MBase);
            End;
//      #15 : SortMessageBases;
      #27 : Break;
    End;
  Until False;

  Box.Close;

  MBaseFile.Free;
  List.Free;
  Box.Free;
End;

End.

