{$I M_OPS.PAS}

Unit MCFG_Common;

Interface

Uses
  m_Output,
  m_MenuBox,
  BBS_Common;

{$I BBS_RECORDS.PAS}

Var
  Console       : TOutput;
  bbsConfig     : recConfig;
  Theme         : recTheme;
  ShowMsgBoxPtr : TMenuBox;

Procedure VerticalLine (X1, Y1, Y2: Byte);
Function  CheckPath (Str: String) : String;
Function  CheckBBSVersion (Cfg: recConfig) : Boolean;
Function  ShowMsgBox (BoxType: Byte; Str: String) : Boolean;
Procedure CloseMsgBox;
Function  FileDirExists (Dir: String) : Boolean;
Function  GetStr (Header, Text, Def: String; Len, MaxLen: Byte) : String;
Function  strAddr (Addr: RecEchoMailAddr) : String;

Implementation

Uses
  m_Input,
  m_MenuInput,
  m_Strings,
  DOS;

Function strAddr (Addr: RecEchoMailAddr) : String;
Begin
  Result := strI2S(Addr.Zone) + ':' + strI2S(Addr.Net) + '/' + strI2S(Addr.Node);

  If Addr.Point <> 0 Then Result := Result + '.' + strI2S(Addr.Point);
End;

Procedure VerticalLine (X1, Y1, Y2: Byte);
Var
  Count : Byte;
Begin
  For Count := Y1 to Y2 Do
    Console.WriteXY (X1, Count, 112, '');
End;

Function FileDirExists (Dir: String) : Boolean;
Var
  F    : File;
  Attr : {$IFDEF FPC} Word; {$ENDIF} {$IFDEF VPC} LongInt; {$ENDIF}
Begin
  While Dir[Length(Dir)] = mysPathSep Do Dec(Dir[0]);
  Dir := Dir + mysPathSep + '.';
  Assign (F, Dir);
  GetFAttr (F, Attr);
  Result := ((Attr And Directory) = Directory);
End;

Function CheckPath (Str: String) : String;
Begin
  While Str[Length(Str)] = mysPathSep Do Dec(Str[0]);
  If Not FileDirExists(Str) Then Begin
    If ShowMsgBox(1, 'Directory does not exist.  Create?') Then Begin
      MkDir (Str);
      If IoResult <> 0 Then
        If ShowMsgBox (0, 'Unable to create directory') Then;
    End;
  End;
  CheckPath := Str + mysPathSep;
End;

Function CheckBBSVersion (Cfg: recConfig) : Boolean;
Begin
  Result := Not ((Cfg.VersionMajor <> mysVersionMajor) or (Cfg.VersionMinor <> mysVersionMinor));
End;

Procedure CloseMsgBox;
Begin
  If Assigned(ShowMsgBoxPtr) Then Begin
    ShowMsgBoxPtr.Close;
    ShowMsgBoxPtr.Free;
  End;
End;

Function ShowMsgBox (BoxType: Byte; Str: String) : Boolean;
Var
  Len    : Byte;
  Len2   : Byte;
  Pos    : Byte;
  InKey  : TInput;
Begin
  ShowMsgBox := True;

{ 0 = ok box }
{ 1 = y/n box }
{ 2 = just box }
{ 3 = just box dont close }

  ShowMsgBoxPtr := TMenuBox.Create(Console);
  InKey         := TInput.Create;

  Len := (80 - (Length(Str) + 2)) DIV 2;
  Pos := 1;

  ShowMsgBoxPtr.FrameType := 6;
  ShowMsgBoxPtr.Header    := ' Info ';
  ShowMsgBoxPtr.Box3D     := True;

  If BoxType < 2 Then
    ShowMsgBoxPtr.Open (Len, 10, Len + Length(Str) + 3, 15)
  Else
    ShowMsgBoxPtr.Open (Len, 10, Len + Length(Str) + 3, 14);

  Console.WriteXY (Len + 2, 12, 0 + 7 * 16, Str);

  Case BoxType of
    0 : Begin
          Len2 := (Length(Str) - 4) DIV 2;
          Console.WriteXY (Len + Len2 + 2, 14, 31, ' OK ');
          Repeat
            InKey.ReadKey;
          Until Not InKey.KeyPressed;
        End;
    1 : Repeat
          Len2 := (Length(Str) - 9) DIV 2;
          Console.WriteXY (Len + Len2 + 2, 14, 1 + 7 * 16, ' YES ');
          Console.WriteXY (Len + Len2 + 7, 14, 1 + 7 * 16, ' NO ');
          If Pos = 1 Then
            Console.WriteXY (Len + Len2 + 2, 14, 31, ' YES ')
          Else
            Console.WriteXY (Len + Len2 + 7, 14, 31, ' NO ');

          Case UpCase(InKey.ReadKey) of
            #00 : Case InKey.ReadKey of
                    #75 : Pos := 1;
                    #77 : Pos := 0;
                  End;
            #13 : Begin
                    ShowMsgBox := Boolean(Pos);
                    Break;
                  End;
            #32 : If Pos = 0 Then Inc(Pos) Else Pos := 0;
            'N' : Begin
                    ShowMsgBox := False;
                    Break;
                  End;
            'Y' : Begin
                    ShowMsgBox := True;
                    Break;
                  End;
          End;
        Until False;
  End;

  If BoxType <> 3 Then Begin
    ShowMsgBoxPtr.Close;
    ShowMsgBoxPtr.Free;
  End;

  InKey.Free;
End;

Function GetStr (Header, Text, Def: String; Len, MaxLen: Byte) : String;
Var
  Box     : TMenuBox;
  Input   : TMenuInput;
  Offset  : Byte;
  Str     : String;
  WinSize : Byte;
Begin
  If Len > Length(Text) Then
    Offset := Len
  Else
    Offset := Length(Text);

  WinSize := (80 - Offset + 2) DIV 2;

  Box   := TMenuBox.Create(Console);
  Input := TMenuInput.Create(Console);

  Box.Header    := ' ' + Header + ' ';

//Input.Attr     := 15 + 4 * 16;
//Input.FillAttr :=  7 + 4 * 16;
  Input.LoChars  := #13#27;

  Box.Open (WinSize, 10, WinSize + Offset + 3, 15);

  Console.WriteXY (WinSize + 2, 12, 112, Text);
  Str := Input.GetStr(WinSize + 2, 13, Len, MaxLen, 1, Def);

  Box.Close;

  If Input.ExitCode = #27 Then Str := '';

  Input.Free;
  Box.Free;

  Result := Str;
End;

End.
