{$I M_OPS.PAS}

Unit m_Socket;

// FreePascal does not support INLINE functions within a unit, which should
// be used here to make things a little faster/smaller.  In the future, this
// should be modified to compile with INLINE statements under non FPC
// Pascal compilers (such as VPC).

// This unit is sloppy because I took the basic unit of the ASL library
// as a foundation here.  Unused functions should be removed and the
// code should be formatted nicer once the basic functionality is tested
// and working.

Interface

Uses
  m_Socket_Types,
  {$IFDEF WIN32}
    m_Socket_Windows,
  {$ENDIF}
  {$IFDEF LINUX}
    Linux,
    m_Socket_Linux,
  {$ENDIF}
  SysUtils;

Procedure SockStartup;
Procedure SockCleanup;
Function SockAccept         (s: LongInt; var name: TSockAddrIn; var namelen: LongInt): LongInt;
Function SockBind           (s: LongInt; var name: TSockAddrIn; namelen: LongInt): LongInt;
Function SockConnect        (s: LongInt; var name: TSockaddrIn; namelen: LongInt): LongInt;
Function SockGetPeerName    (s: LongInt; var name: TSockaddr; namelen: LongInt): LongInt;
Function SockGetSockName    (s: LongInt; var name: TSockaddr; namelen: LongInt): LongInt;
Function SockGetSockOpt     (s: LongInt; level: LongInt; optname: LongInt; var optval; var optlen: LongInt): LongInt;
Function SockIOCtl          (s: LongInt; cmd: LongInt; var data: LongInt): LongInt;
Function SockListen         (s: LongInt; backlog: LongInt): Boolean;
Function SockRecv           (s: LongInt; var buf; len: LongInt; flags: LongInt): LongInt;
//Function SockRecvFrom       (s: LongInt; var buf; len: LongInt; flags: LongInt; var name: TSockaddr; var namelen: LongInt): LongInt;
Function SockSelect         (s: longint; noreads: LongInt; nowrites: LongInt; noexcepts: LongInt; timeout: LongInt): LongInt;
Function SockSend           (s: LongInt; var buf; len: LongInt; flags: LongInt): LongInt;
//Function SockSendTo         (s: LongInt; var buf; len: LongInt; flags: LongInt; var name: TSockaddr; namelen: LongInt): LongInt;
Function SockSetSockOpt     (s: LongInt; level: LongInt; optname: LongInt; var optval; optlen: LongInt): LongInt;
Function SockSocket         (domain: LongInt; stype: LongInt; protocol: LongInt): LongInt;
Function SockClose          (s: LongInt): LongInt;
Function SockShutdown       (s: LongInt; howto: LongInt): LongInt;
Function bswap              (u: system.Word): system.Word;
Function SockGetServByName  (Name: STRING; Proto: STRING): PServEnt;
Function SockGetHostByName  (Name: STRING): PHostEnt;
Function SockGetHostByAddr  (Addr: TInAddr; AddrSize, AType: LongInt) : PHostEnt;
//Function SockGetProtoByName (Name: STRING): PProtoEnt;
Function SockInetAddr       (Adr: STRING): LongInt;
Function SockInetNtoA       (ina: TInAddr): STRING;
Function SockLastError : LongInt;
Function SockSetBlocking (Sock: LongInt;Block: Boolean): LongInt;

Implementation

FUNCTION SockAccept(s: LongInt; var name: TSockAddrIn; var namelen: LongInt): LongInt;
BEGIN
  Result:=accept(s, TSockaddr(name), namelen);
END;

FUNCTION SockBind(s: LongInt; var name: TSockAddrIn; namelen: LongInt): LongInt;
BEGIN
  Result:=bind(s, TSockAddr(Name), namelen);
END;

FUNCTION SockConnect(s: LongInt; var name: TSockaddrIn; namelen: LongInt): LongInt;
BEGIN
  Result:=connect(s, TSockaddr(name), namelen);
END;

FUNCTION SockGetPeerName(s: LongInt; var name: TSockaddr; namelen: LongInt): LongInt;
BEGIN
  Result:=getpeername(s, TSockaddr(name), namelen);
END;

FUNCTION SockGetSockName(s: LongInt; var name: TSockaddr; namelen: LongInt): LongInt;
BEGIN
  Result:=getsockname(s, TSockaddr(name), namelen);
END;

FUNCTION SockGetSockOpt(s: LongInt; level: LongInt; optname: LongInt; var optval; var optlen: LongInt): LongInt;
BEGIN
  Result:=getsockopt(s, level, optname, optval, optlen);
END;

FUNCTION SockIOCtl(s: LongInt; cmd: LongInt; Var Data: LongInt): LongInt;
BEGIN
  {$IFDEF LINUX}
    result := 0;
    //Result := ioctl(s, cmd, u_long(data));
  {$ELSE}
    Result:=ioctlsocket(s, cmd, u_long(data));
  {$ENDIF}
END;

FUNCTION SockListen(s: LongInt; backlog: LongInt): Boolean;
var t : longint; str: string;
BEGIN
  T := Listen(S, BackLog);

  if T <> 0 then begin
    t := WSAGetLastError;
    writeln('SOCKERROR', t);
  end;

  Result := (T = 0);
END;

FUNCTION SockRecv(s: LongInt; var buf; len: LongInt; flags: LongInt): LongInt;
BEGIN
  Result:=recv(s, buf, len, flags);
END;

(*
FUNCTION SockRecvFrom(s: LongInt; var buf; len: LongInt; flags: LongInt; var name: TSockaddr; var namelen: LongInt): LongInt;
BEGIN
  Result:=recvfrom(s, buf, len, flags, TSockaddr(name), namelen);
END;
*)

FUNCTION SockSelect(s: longint; noreads: LongInt; nowrites: LongInt; noexcepts: LongInt; timeout: LongInt): LongInt;
VAR
  rfdset, wfdset, efdset: fdset;
  tm   : timeval;
BEGIN
  {$IFDEF WIN32}
  rfdset.fd_count:=noreads;
  rfdset.fd_array[1]:=s;

  wfdset.fd_count:=nowrites;
  wfdset.fd_array[1]:=s;

  efdset.fd_count:=noexcepts;
  efdset.fd_array[1]:=s;
  {$ELSE}
  fd_zero(rfdset);
  fd_zero(wfdset);
  fd_zero(efdset);
  if noreads   = 1 then fd_set(s, rfdset);
  if nowrites  = 1 then fd_set(s, wfdset);
  if noexcepts = 1 then fd_set(s, efdset);
  {$ENDIF}

  tm.sec:=0;
  tm.usec:=TimeOut * 1000;

  if timeout <> -1 then
    Result:=select(s + 1, @rfdset, @wfdset, @efdset, @tm)
  else
    result := select(s + 1, @rfdset, @wfdset, @efdset, nil);
END;

FUNCTION SockSend(s: LongInt; var buf; len: LongInt; flags: LongInt): LongInt;
BEGIN
  Result:=send(s, buf, len, flags);
END;

(*
FUNCTION SockSendTo(s: LongInt; var buf; len: LongInt; flags: LongInt; var name: TSockaddr; namelen: LongInt): LongInt;
BEGIN
  Result:=sendto(s, buf, len, flags, TSockaddr(name), namelen);
END;
*)

FUNCTION SockSetSockOpt(s: LongInt; level: LongInt; optname: LongInt; var optval; optlen: LongInt): LongInt;
BEGIN
  Result:=setsockopt(s, level, optname, optval, optlen);
END;

FUNCTION SockLastError: LongInt;
BEGIN
  {$IFDEF WIN32}
  Result:=WSAGetLastError;
  {$ELSE}
  Result := 0;
  {$ENDIF}
END;

FUNCTION SockSocket(domain: LongInt; stype: LongInt; protocol: LongInt): LongInt;
BEGIN
  Result:=socket(domain, stype, protocol);
END;

FUNCTION SockClose(s: LongInt): LongInt;
BEGIN
  Result:=closesocket(s);
END;

FUNCTION SockShutdown(s: LongInt; howto: LongInt): LongInt;
BEGIN
  Result:=shutdown(s, howto);
END;

Function SockSetBlocking (Sock: LongInt; Block: Boolean): LongInt;
Var
  Data : LongInt;
Begin
  Data   := Ord(Not Block);
  Result := SockIOCTL (Sock, FIONBIO, Data);
End;

FUNCTION bswap(u: system.Word): system.Word;
BEGIN
  Result:=ntohs(u)
END;

  FUNCTION SockGetServByName(Name: STRING; Proto: STRING): PServEnt;
  BEGIN
    Name:=Name+#0; Proto:=Proto+#0;
    SockGetServByName:=PServEnt(GetServByName(@Name[1], @Proto[1]));
  END;

  FUNCTION SockGetHostByName(Name: STRING): PHostEnt;
  BEGIN
    Name:=Name+#0;
    SockGetHostByName:=PHostEnt(GetHostByName(@Name[1]));
  END;

  Function SockGetHostByAddr (Addr: TInAddr; AddrSize, AType: LongInt) : PHostEnt;
  Begin
    Result := GetHostByAddr(PChar(@Addr), AddrSize, AType);
  End;
(*
  FUNCTION SockGetProtoByName(Name: STRING): PProtoEnt;
  BEGIN
    Name:=Name+#0;
    SockGetProtoByName:=PProtoEnt(GetProtoByName(@Name[1]));
  END;
*)
  FUNCTION SockInetAddr(Adr: STRING): LongInt;
  BEGIN
    Adr:=Adr+#0;
    SockInetAddr:=longint(inet_Addr(@Adr[1]));
  END;

{$IFDEF LINUX}
  FUNCTION SockInetNtoA (INA: TInAddr) : String;
  Var
    Res : String[4];
    Count : LongInt;
  Begin
    SockINetNtoA := '';

    For Count := 1 To 4 Do Begin
      Str(THostAddr(LongInt(INA))[Count], Res);
      Result := Result + Res;
      If Count < 4 Then Result := Result + '.';
    End;
  End;
{$ELSE}
  FUNCTION SockInetNtoA(ina: TInAddr): STRING;
  VAR
    p: PChar;
  BEGIN
    p:=inet_ntoa(thostaddr(ina));
    SockINetNtoA:=StrPas(p);
  END;
{$ENDIF}

Procedure SockStartup;
{$IFDEF WINDOWS}
Var
  WSA : WSAData;
  Res : LongInt;
  Ver : System.Word;
{$ENDIF}
Begin
{$IFDEF WINDOWS}
  FillChar(WSA, SizeOf(WSAData), 0);

  Ver := $1010;
  Res := WSAStartup(Ver, WSA);

  WriteLn('Startup RES is ', Res);
  WriteLn('Size is ', SizeOf(Ver));
{$ENDIF}
End;

Procedure SockCleanup;
Begin
{$IFDEF WINDOWS}
  WSACleanup;
{$ENDIF}
End;

Initialization
  SockStartup;

Finalization
  SockCleanup;
End.
