Unit Class_Sync;

{$I M_OPS.PAS}

Interface

{$IFDEF WINDOWS}
Uses
  Windows;
{$ENDIF}

Type
  TCriticalSection = Class
    {$IFDEF WINDOWS}
    Exclusive : PRTLCriticalSection;
    {$ENDIF}

    Constructor Create;
    Destructor  Destroy; Override;
    Procedure   Start;
    Procedure   Finish;
  End;

Implementation

Constructor TCriticalSection.Create;
Begin
  Inherited Create;

{$IFDEF WINDOWS}
  New (Exclusive);
  InitializeCriticalSection(Exclusive^);
{$ENDIF}
End;

Destructor TCriticalSection.Destroy;
Begin
{$IFDEF WINDOWS}
  DeleteCriticalSection(Exclusive^);
  Dispose(Exclusive);
{$ENDIF}
  Inherited Destroy;
End;

Procedure TCriticalSection.Start;
Begin
{$IFDEF WINDOWS}
  EnterCriticalSection(Exclusive^);
{$ENDIF}
End;

Procedure TCriticalSection.Finish;
Begin
{$IFDEF WINDOWS}
  LeaveCriticalSection(Exclusive^);
{$ENDIF}
End;

End.
