{$I M_OPS.PAS}

Unit BBS_User;

Interface

Uses
  m_FileIO,
  m_Strings,
  BBS_Common;

Type
  TBBSUser = Class
    Owner       : Pointer;
    ThisUser    : RecUser;
    ThisUserPos : LongInt;
    Security    : RecSecurity;
    AcsOKFlag   : Boolean;
    IgnoreGroup : Boolean;
    MatrixOK    : Boolean;
    UserAction  : String[80];
    TimeStart   : Integer;
    TimeEnd     : Integer;
    TimeCheck   : Boolean;
    TimeOffset  : LongInt;
    InNodeChat  : Boolean;

    Constructor Create (O: Pointer);
    Destructor  Destroy; Override;

    Procedure   InitializeUserData;
    Procedure   SetTimeLeft (Mins: Integer);
    Function    TimeLeft : Integer;
    Function    TimeOn : LongInt;
    Procedure   Security_Upgrade (Var U: RecUser; Sec: Byte);
    Procedure   Security_Load (Sec: Byte);
//    Function    SearchForUser (UN: String; Var Rec: RecUser; Var RecPos: LongInt) : Boolean;
    Function    IsThisUser (Str: String) : Boolean;
    Function    IsValidUser (Var Str: String; Real: Boolean) : LongInt;
    Function    IsUser (Str: String) : Boolean;
    Procedure   SaveUser;
    Function    CheckTrash (FN, Str: String) : Boolean;
    Function    Access (Str: String) : Boolean;
    Function    AccessUser (User: RecUser; Str: String) : Boolean;
    Procedure   AskTheme;
    Procedure   AskAlias (Str: String);
    Procedure   AskRealName;
    Procedure   AskGender (P1: String);
    Procedure   AskDateFormat (P1: String);
    Function    AskPhone (P1: String; Edit: Boolean; Def: String) : String;
    Function    AskUserInfo (P1: String; Edit: Boolean; Field, Max, InType: ShortInt; Def: String) : String;
    Procedure   AskPassword (Edit: Boolean);
    Procedure   EditUserSettings (Mode: Word);
    Function    CreateNewUser (Str: String) : Boolean;
    Function    GetMatrixUser : Boolean;
    Function    DoUserLogin : Boolean;
    Procedure   SetUserAction (Str: String);
    Function    IsUserOnline (Str: String) : LongInt;
  End;

Function SearchForUser (UN: String; Var Rec: recUser; Var RecPos: LongInt) : Boolean;

Implementation

Uses
  BBS_Core,
  BBS_Events,
  MPL_Execute,
  Mystic_Telnet,
  m_DateTime;

Function SearchForUser (UN: String; Var Rec: recUser; Var RecPos: LongInt) : Boolean;
Var
  UserFile : TBufFile;
Begin
  Result := False;
  UN     := strUpper(UN);

  If UN = '' Then Exit;

//  If UN = 'SYSOP' Then UN := strUpper(bbsConfig.SysopName);

  UserFile := TBufFile.Create(4096);

  If UserFile.Open(bbsConfig.PathData + 'users.dat', fmOpen, fmReadWrite + fmDenyNone, SizeOf(recUser)) Then
    While Not UserFile.EOF Do Begin
      UserFile.Read(Rec);

      If Rec.Flags AND UserDeleted <> 0 Then Continue;

      If (UN = strUpper(Rec.RealName)) or (UN = strUpper(Rec.Handle)) Then Begin
        RecPos := UserFile.FilePos - 1;
        Result := True;
        Break;
      End;
    End;

  UserFile.Free;
End;

Constructor TBBSUser.Create (O: Pointer);
Begin
  Inherited Create;

  Owner      := O;
  TimeCheck  := False;
  TimeOffset := 0;

  // might need to move the above to initializeuserdata

  InitializeUserData;
End;

Destructor TBBSUser.Destroy;
Begin
  Inherited Destroy;
End;

Procedure TBBSUser.InitializeUserData;
Begin
  FillChar (ThisUser, SizeOf(recUser), #0);
  FillChar (Security, SizeOf(recSecurity), #0);

  ThisUserPos         := -1;
  ThisUser.DateType   := 1;
  ThisUser.ScreenSize := bbsConfig.DefScreenSize;
  ThisUser.Theme      := bbsConfig.DefThemeName;
  ThisUser.HotKeys    := True;
  ThisUser.RealName   := 'Unknown';
  ThisUser.Handle     := ThisUser.RealName;
  ThisUser.Security   := 0;
  ThisUser.FSEditor   := True;
  ThisUser.LastMBase  := 0;
  ThisUser.LastMGroup := 0;
  ThisUser.LastFBase  := 0;
  ThisUser.LastFGroup := 0;
  ThisUser.Birthdate  := CurDateJulian;
  ThisUser.Gender     := 'U';
  ThisUser.Invisible  := False;
  ThisUser.Available  := False;
  ThisUser.Flags      := ThisUser.Flags And Not UserNoInactive;
  IgnoreGroup         := False;
  AcsOkFlag           := False;
  MatrixOK            := False;
End;

Procedure TBBSUser.SetTimeLeft (Mins: Integer);
Begin
  If TimeCheck Then TimeOffset := TimeOn;

  TimeStart := TimerMinutes;
  TimeEnd   := TimeStart + Mins;
  TimeCheck := True;
End;

Function TBBSUser.TimeOn : LongInt;
Begin
  If Not TimeCheck Then Begin
    Result := 0;
    Exit;
  End;

  If TimeStart > TimerMinutes Then Begin
    Dec (TimeStart, 1440);
    Dec (TimeEnd,   1440);
  End;

  Result := TimerMinutes - TimeStart + TimeOffset;
End;

Function TBBSUser.TimeLeft : Integer;
Begin
  If Not TimeCheck Then Begin
    Result := 0;
    Exit;
  End;

  If TimeStart > TimerMinutes Then Begin
    Dec (TimeStart, 1440);
    Dec (TimeEnd,   1440);

    If ThisUserPos <> -1 Then
      SetTimeLeft (Security.Time);
  End;

  Result := TimeEnd - TimerMinutes;
End;

Procedure TBBSUser.SetUserAction (Str: String);
Begin
  UserAction := Str;

  TBBSCore(Owner).Owner.Manager.Server.StatusUpdated := True;
End;

Procedure TBBSUser.Security_Load (Sec: Byte);
Var
  SecurityFile : File;
Begin
  Assign  (SecurityFile, bbsConfig.PathData + 'security.dat');
  ioReset (SecurityFile, SizeOf(recSecurity), fmReadWrite + fmDenyNone);
  ioSeek  (SecurityFile, Sec - 1);
  ioRead  (SecurityFile, Security);
  Close   (SecurityFile);
End;

Procedure TBBSUser.Security_Upgrade (Var U: recUser; Sec: Byte);
Var
  A : Char;
Begin
  Security_Load(Sec);

  U.Security  := Sec;
  U.StartMenu := Security.StartMenu;
  U.TimeLeft  := Security.Time;
  U.Expires   := '00/00/00';
  U.ExpiresTo := Security.ExpiresTo;

  If Security.Expires > 0 Then Begin
    U.Expires   := DateJulian2Str(CurDateJulian + Security.Expires, 1);
    U.ExpiresTo := Security.ExpiresTo;
  End;

  For A := 'A' to 'Z' Do
    If Ord(A) - 64 in Security.AF1 Then
      U.AF1 := U.AF1 + [Ord(A) - 64]
    Else
      If Security.Hard Then
        U.AF1 := U.AF1 - [Ord(A) - 64];

  For A := 'A' to 'Z' Do
    If Ord(A) - 64 in Security.AF2 Then
      U.AF2 := U.AF2 + [Ord(A) - 64]
    Else
      If Security.Hard Then
        U.AF2 := U.AF2 - [Ord(A) - 64];
End;

Function TBBSUser.Access (Str: String) : Boolean;
Begin
  Result := AccessUser(ThisUser, Str);
End;

Function TBBSUser.AccessUser (User: RecUser; Str: String) : Boolean;
Const
  OpCmds  = ['%', '^', '(', ')', '&', '!', '|'];
  AcsCmds = ['A', 'C', 'D', 'E', 'F', 'H', 'J', 'K', 'M', 'N', 'O', 'S', 'U', 'W'];
Var
  Key   : Char;
  Data  : String;
  Check : Boolean;
  Out   : String;
  First : Boolean;

  Procedure CheckCommand;
  Var
    Res   : Boolean;
//    Temp1 : LongInt;
//    Temp2 : LongInt;
  Begin
    Res := False;

    Case Key of
      'A' : Res := (DaysAgo(User.Birthdate) DIV 365) >= strS2I(Data);
      'C' : If IgnoreGroup Then Begin
              First := True;
              Check := False;
              Data  := '';
              Exit;
            End Else
              Res := User.LastMGroup = strS2I(Data);
      'D' : If IgnoreGroup Then Begin
              First := True;
              Check := False;
              Data  := '';
              Exit;
            End Else
              Res := User.LastFGroup = strS2I(Data);
      'E' : Res := Ord(Data[1]) - 64 in User.AF2;
      'F' : Res := Ord(Data[1]) - 64 in User.AF1;
      'H' : Res := strS2I(Data) < strS2I(Copy(TimeDos2Str(CurDateDos, False), 1, 2));
      'J' : Res := User.LastMBase = strS2I(Data);
      'K' : Res := User.LastFBase = strS2I(Data);
      'M' : Res := strS2I(Data) < strS2I(Copy(TimeDos2Str(CurDateDos, False), 4, 2));
      'N' : Res := strS2I(Data) = TBBSCore(Owner).Node;
      'O' : Case Data[1] of
              '0' : Res := TBBSCore(Owner).Term.Graphics = 0;
              '1' : Res := TBBSCore(Owner).Term.Graphics = 1;
              'A' : Begin
                      Res := Access(TBBSCore(Owner).Msgs.MBase.SysopACS) or IsThisUser(TBBSCore(Owner).Msgs.MBase.Sponsor);

                      If TBBSCore(Owner).Msgs.Reading Then
                        Res := Res or IsThisUser(TBBSCore(Owner).Msgs.ReadBase^.GetFrom);
                    End;
              'C' : Res := User.CallsToday = 1;
              'E' : Res := TBBSCore(Owner).Msgs.Reading And (TBBSCore(Owner).Msgs.ReadModeChar = 'E');
              'G' : Res := User.Gender = 'M';
              'H' : Res := User.Gender = 'F';
              'K' : Res := AcsOkFlag;
              'M' : Res := (strUpper(User.Handle)   = strUpper(TBBSCore(Owner).Msgs.MBase.Sponsor)) or
                           (strUpper(User.RealName) = strUpper(TBBSCore(Owner).Msgs.MBase.Sponsor)) or
                           Access(TBBSCore(Owner).Msgs.MBase.SysopACS);
              'P' : Res := User.Flags AND UserNoDelete <> 0;
              'S' : Res := Access(bbsConfig.AcsSysop);
            End;
      'S' : Res := User.Security >= strS2I(Data);
      'U' : Res := User.UserID = strS2I(Data);
      'W' : Res := strS2I(Data) = DayOfWeek;
    End;

    If Res Then Out := Out + '^' Else Out := Out + '%';

    Check := False;
    First := True;
    Data  := '';
  End;

(*
post/call ratio
post/door ratio
node msg available?
chat available?
date check
          Function   :   "II"
          Description:   Invisible Mode
          To be True :   Must be in Invisible Mode.

   Pxxxx     A users number of posts must be at least 'xxxx' in order for the
             ACS code to return true, if false it will ignore all remaining
             information in the current command set, and move on to the next
             command set.


    L     <n>          User total calls >= <n>              L14
    M     <n>          User public posts >= <n>             M50
    O     <n>          Online time >= <n>                   O15
    R     <c>          User with restriction <c>            RE
                         1 - No UL/DL Ratio
                         2 - No post/call Ratio
                         3 - No File Point Check
                         5 - No Daily DL Ratio
                         6 - No DL Time Check
                         7 - No Forced PW Change
                         8 - Time Per Call
    T     <n>          User timeleft >= <n>                 T40
    V     <c>          User ratio test
                         K - User passed UL/DL K ratio
                         P - User passed post/call ratio
                         T - User passed post/time ratio
                         U - User passed UL/DL ratio
    X     <c>          Misc User Testing                    XA|XV
                         I - User has full-line input ON
                         C - SysOp is available
                         F - FileSysOpACS (current area)
                         N - User in newuser process
                         P - User has pause ON
                         Q - Files are queued for download
                         X - User is in expert mode
*)

Var
  Count  : Byte;
  Paran1 : Byte;
  Paran2 : Byte;
  Ch1    : Char;
  Ch2    : Char;
  S1     : String[42];
Begin
  Data  := '';
  Out   := '';
  Check := False;
  Str   := strUpper(Str);
  First := True;

  If Str = '' Then Begin
    Result := True;
    Exit;
  End;

  For Count := 1 to Length(Str) Do
    If Str[Count] in OpCmds Then Begin
      If Check Then CheckCommand;
      Out := Out + Str[Count];
    End Else
    If (Str[Count] in AcsCmds) and (First or Check) Then Begin
      If Check Then CheckCommand;
      Key := Str[Count];
      If First Then First := False;
    End Else Begin
      Data  := Data + Str[Count];
      Check := True;
      If Count = Length(Str) Then CheckCommand;
    End;

  Out := '(' + Out + ')';

  While Pos('&', Out) <> 0 Do Delete (Out, Pos('&',  Out), 1);

  While Pos('(', Out) <> 0 Do Begin
    Paran2 := 1;
    While ((Out[Paran2] <> ')') And (Paran2 <= Length(Out))) Do Begin
      If (Out[Paran2] = '(') Then Paran1 := Paran2;
      Inc (Paran2);
    End;

    S1 := Copy(Out, Paran1 + 1, (Paran2 - Paran1) - 1);

    While Pos('!', S1) <> 0 Do Begin
      Count := Pos('!', S1) + 1;
      If S1[Count] = '^' Then S1[Count] := '%' Else
      If S1[Count] = '%' Then S1[Count] := '^';
      Delete (S1, Count - 1, 1);
    End;

    While Pos('|', S1) <> 0 Do Begin
      Count := Pos('|', S1) - 1;
      Ch1   := S1[Count];
      Ch2   := S1[Count + 2];

      If (Ch1 in ['%', '^']) and (Ch2 in ['%', '^']) Then Begin
        Delete (S1, Count, 3);
        If (Ch1 = '^') or (Ch2 = '^') Then
          Insert ('^', S1, Count)
        Else
          Insert ('%', S1, Count)
      End Else
        Delete (S1, Count + 1, 1);
    End;

    While Pos('%%', S1) <> 0 Do Delete (S1, Pos('%%', S1), 1);
    While Pos('^^', S1) <> 0 Do Delete (S1, Pos('^^', S1), 1);
    While Pos('%^', S1) <> 0 Do Delete (S1, Pos('%^', S1) + 1, 1);
    While Pos('^%', S1) <> 0 Do Delete (S1, Pos('^%', S1), 1);

    Delete (Out, Paran1, (Paran2 - Paran1) + 1);
    Insert (S1, Out, Paran1);
  End;

  Result := Pos('%', Out) = 0;
End;

Procedure TBBSUser.SaveUser;
Var
  UserFile : File;
Begin
  If ThisUserPos <> -1 Then Begin
    Assign  (UserFile, bbsConfig.PathData + 'users.dat');
    ioReset (UserFile, SizeOf(recUser), fmReadWrite + fmDenyWrite);
    ioSeek  (UserFile, ThisUserPos);
    ioWrite (UserFile, ThisUser);
    Close   (UserFile);
  End;
End;

(*
Function TBBSUser.SearchForUser (UN: String; Var Rec: recUser; Var RecPos: LongInt) : Boolean;
Var
  UserFile : TBufFile;
Begin
  Result := False;
  UN     := strUpper(UN);

  If UN = '' Then Exit;

//  If UN = 'SYSOP' Then UN := strUpper(bbsConfig.SysopName);

  UserFile := TBufFile.Create(4096);

  If UserFile.Open(bbsConfig.PathData + 'users.dat', fmOpen, fmReadWrite + fmDenyNone, SizeOf(recUser)) Then
    While Not UserFile.EOF Do Begin
      UserFile.Read(Rec);

      If Rec.Flags AND UserDeleted <> 0 Then Continue;

      If (UN = strUpper(Rec.RealName)) or (UN = strUpper(Rec.Handle)) Then Begin
        RecPos := UserFile.FilePos - 1;
        Result := True;
        Break;
      End;
    End;

  UserFile.Free;
End;
*)

Function TBBSUser.IsUser (Str: String) : Boolean;
Var
  U  : RecUser;
  UP : LongInt;
Begin
  Result := SearchForUser(Str, U, UP);
End;

Function TBBSUser.IsThisUser (Str: String) : Boolean;
Begin
  Str    := strUpper(Str);
  Result := (strUpper(TBBSCore(Owner).User.ThisUser.RealName) = Str) or (strUpper(TBBSCore(Owner).User.ThisUser.Handle) = Str);
End;

Function TBBSUser.IsValidUser (Var Str: String; Real: Boolean) : LongInt;
Var
  UserFile : TBufFile;
  User     : RecUser;
  Found    : LongInt;
  First    : Boolean;
Begin
  Result   := -1;
  UserFile := TBufFile.Create(4096);
  Str      := strUpper(Str);

  If Str = 'SYSOP' Then
    Str := strUpper(bbsConfig.SysopName);

  If Not UserFile.Open(bbsConfig.PathData + 'users.dat', fmOpen, fmReadWrite + fmDenyNone, SizeOf(recUser)) Then Begin
    UserFile.Free;
    Exit;
  End;

  Found := -1;
  First := True;

  While Not UserFile.EOF Do Begin
    UserFile.Read(User);
    If User.Flags AND UserDeleted <> 0 Then Continue;
    If Pos(Str, strUpper(User.Handle)) > 0 Then Begin
      If First Then Begin
        TBBSCore(Owner).Term.OutRawLn('');
        First := False;
      End;
      TBBSCore(Owner).Term.PromptInfo['A'] := User.Handle;
      If TBBSCore(Owner).Term.GetYN(TBBSCore(Owner).GetPrompt(84), True) Then Begin
        If Real Then
          Str := User.RealName
        Else
          Str := User.Handle;
        Found := UserFile.FilePos;
        Break;
      End;
    End;
  End;

  UserFile.Free;

  If Found = -1 Then
    TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(85));

  Result := Found;
End;

Function TBBSUser.CheckTrash (FN, Str: String) : Boolean;
Var
  TF      : Text;
  TextBuf : Array[1..4*1024] of Char;
  Temp    : String;
Begin
  Result   := False;
  FileMode := 66;
  Str      := strUpper(strStripB(Str, ' '));

  Assign (TF, FN);
  Reset  (TF);

  If IoResult <> 0 Then Exit;

  SetTextBuf (TF, TextBuf, SizeOf(TextBuf));

  While Not Eof(TF) Do Begin
    ReadLn (TF, Temp);
    Temp := strUpper(strStripB(Temp, ' '));
    If Temp[1] = ';' Then Continue;
    If Temp = Str Then Begin
      Result := True;
      Break;
    End;
  End;

  Close (TF);
End;

Procedure TBBSUser.AskTheme;
Var
  ThemeFile : File of recTheme;
  Temp      : recTheme;
  Shown     : LongInt;
  Picked    : LongInt;
Begin
  Shown    := 0;
  FileMode := 66;

  Assign (ThemeFile, bbsConfig.PathData + 'themes.dat');
  Reset  (ThemeFile);

  TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(17));

  While Not Eof(ThemeFile) Do Begin
    Read (ThemeFile, Temp);

    If ((Not Temp.AllowASCII) and (TBBSCore(Owner).Term.Graphics = 0)) or
       ((Not Temp.AllowANSI)  and (TBBSCore(Owner).Term.Graphics = 1)) Then Continue;

    Inc (Shown);

    TBBSCore(Owner).Term.PromptInfo['A'] := strI2S(Shown);
    TBBSCore(Owner).Term.PromptInfo['B'] := Temp.Description;

    TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(18));
  End;

  TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(19));

  Picked := strS2I(TBBSCore(Owner).Term.GetStr(5, 5, -2, ''));

  If (Picked < 1) or (Picked > Shown) Then Exit;

  Shown := 0;

  Reset (ThemeFile);
  Repeat
    Read (ThemeFile, Temp);

    If ((Not Temp.AllowASCII) and (TBBSCore(Owner).Term.Graphics = 0)) or
       ((Not Temp.AllowANSI)  and (TBBSCore(Owner).Term.Graphics = 1)) Then Continue;

    Inc (Shown);
  Until Shown = Picked;
  Close (ThemeFile);

  TBBSCore(Owner).LoadThemeFile(Temp.FileName);
End;

Procedure TBBSUser.AskAlias (Str: String);
Var
  User : recUser;
  Rec  : LongInt;
Begin
  While Not TBBSCore(Owner).Shutdown Do Begin
    TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(21));

    Str := strStripB(strStripLow(TBBSCore(Owner).Term.GetStr(30, 30, -8, Str)), ' ');

    If CheckTrash(bbsConfig.PathData + mysBlackList, Str) Then
      Str := ''
    Else
    If SearchForUser(Str, User, Rec) Then
      Str := '';

    If Str = '' Then
      TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(22))
    Else
      Break;
  End;

  ThisUser.Handle := Str;
End;

Procedure TBBSUser.AskRealName;
Var
  Str  : String;
  User : recUser;
  Rec  : LongInt;
Begin
  Str := '';

  While (Str = '') And Not TBBSCore(Owner).Shutdown Do Begin
    TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(23));

    Str := strStripB(strStripLow(TBBSCore(Owner).Term.GetStr(30, 30, -8, '')), ' ');

    If Pos(' ', Str) = 0 Then Begin
      TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(24));
      Str := '';
    End Else
    If CheckTrash(bbsConfig.PathData + mysBlackList, Str) Then
      Str := ''
    Else
    If SearchForUser(Str, User, Rec) Then Begin
      TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(22));
      Str := '';
    End;
  End;

  ThisUser.RealName := Str;
End;

Procedure TBBSUser.AskGender (P1: String);
Var
  Keys : String[2];
  Ch   : Char;
Begin
  Keys := strWordGet(1, P1, ' ');

  Delete (P1, 1, 3);

  TBBSCore(Owner).Term.OutFull(P1);
  Ch := TBBSCore(Owner).Term.OneKey(Keys, True);

  If Ch = Keys[1] Then
    ThisUser.Gender := 'M'
  Else
    ThisUser.Gender := 'F';
End;

Procedure TBBSUser.AskDateFormat (P1: String);
Var
  Keys : String[3];
  Ch   : Char;
Begin
  Keys := strWordGet(1, P1, ' ');

  Delete (P1, 1, 4);

  TBBSCore(Owner).Term.OutFull(P1);
  Ch := TBBSCore(Owner).Term.OneKey(Keys, True);

  ThisUser.DateType := 1;

  If Ch = Keys[2] Then ThisUser.DateType := 2 Else
  If Ch = Keys[3] Then ThisUser.DateType := 3 Else
End;

Function TBBSUser.AskPhone (P1: String; Edit: Boolean; Def: String) : String;
Var
  Str   : String;
  Field : Byte;
  Mode  : ShortInt;
Begin
  Str := '';

  If bbsConfig.UsaPhones Then Begin
    Field := 12;
    Mode  := -4;
  End Else Begin
    Field := 15;
    Mode  := -11;
  End;

  While (Str = '') And Not TBBSCore(Owner).ShutDown Do Begin
    If Edit Then Str := Def;

    TBBSCore(Owner).Term.OutFull(P1);
    Str := TBBSCore(Owner).Term.GetStr(Field, Field, Mode, Str);

    If Edit Then Break;

    If (Field = 12) and (Length(Str) <> 12) Then Str := '';
  End;

  Result := Str;
End;

Function TBBSUser.AskUserInfo (P1: String; Edit: Boolean; Field, Max, InType: ShortInt; Def: String) : String;
Var
  Str : String;
Begin
  Str := '';

  While (Str = '') And Not TBBSCore(Owner).ShutDown Do Begin
    If Def <> '' Then Str := Def;

    TBBSCore(Owner).Term.OutFull(P1);
    Str := TBBSCore(Owner).Term.GetStr(Field, Max, InType, Str);

    If Edit Then Break;
  End;

  Result := Str;
End;

Procedure TBBSUser.AskPassword (Edit: Boolean);
Var
  Str1 : String[20];
  Str2 : String[20];
Begin
  If Edit Then Begin
    TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(45));

    Str1 := TBBSCore(Owner).Term.GetStr(20, 20, -6, '');

    If TBBSCore(Owner).ShutDown Then Exit;

    If Str1 <> ThisUser.Password Then Begin
      TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(46));
      Exit;
    End;
  End;

  Repeat
    Repeat
      If Edit Then
        TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(47))
      Else
        TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(48));

      Str1 := TBBSCore(Owner).Term.GetStr(20, 20, -6, '');

      If TBBSCore(Owner).ShutDown Then Exit;

      If Length(Str1) < 4 Then
        If Edit Then
          TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(49))
        Else
          TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(50));

      If CheckTrash('badpassword.txt', Str1) Then
        If Edit Then
          TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(195))
        Else
          TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(196));

    Until (Length(Str1) >= 4) or (TBBSCore(Owner).Shutdown);

    If Edit Then
      TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(51))
    Else
      TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(52));

    Str2 := TBBSCore(Owner).Term.GetStr(20, 20, -6, '');

    If TBBSCore(Owner).ShutDown Then Exit;

    If Str1 <> Str2 Then
      If Edit Then
        TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(53))
      Else
        TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(54));
  Until (Str1 = Str2) or (Edit) or TBBSCore(Owner).Shutdown;

  If Not TBBSCore(Owner).Shutdown Then
    If Str1 = Str2 Then Begin
      ThisUser.Password     := Str1;
      ThisUser.LastPWChange := DateDos2Str(CurDateDos, 1);
    End;
End;

Procedure TBBSUser.EditUserSettings (Mode: Word);
Begin
  Case Mode of
    1 : ThisUser.Street    := AskUserInfo(TBBSCore(Owner).GetPrompt(179), True, 30, 30, -1, ThisUser.Street);
    2 : ThisUser.CityState := AskUserInfo(TBBSCore(Owner).GetPrompt(180), True, 25, 25, -1, ThisUser.CityState);
    3 : ThisUser.ZipCode   := AskUserInfo(TBBSCore(Owner).GetPrompt(181), True, 10, 10, -2, ThisUser.ZipCode);
    4 : ThisUser.HomePhone := AskPhone (TBBSCore(Owner).GetPrompt(182), True, ThisUser.HomePhone);
    5 : ThisUser.DataPhone := AskPhone (TBBSCore(Owner).GetPrompt(183), True, ThisUser.DataPhone);
    6 : ThisUser.Birthdate := DateStr2Julian(AskUserInfo(TBBSCore(Owner).GetPrompt(184), True, 8, 8, -5, DateJulian2Str(ThisUser.Birthdate, ThisUser.DateType)));
    7 : AskGender(TBBSCore(Owner).GetPrompt(185));
    8 : AskDateFormat(TBBSCore(Owner).GetPrompt(186));
    9 : Repeat
          TBBSCore(Owner).Term.AskGraphics(TBBSCore(Owner).GetPrompt(187));
          If (Not TBBSCore(Owner).Theme.AllowASCII and (TBBSCore(Owner).Term.Graphics = 0)) or (Not TBBSCore(Owner).Theme.AllowAnsi and (TBBSCore(Owner).Term.Graphics = 1)) Then
              TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(188))
            Else
              Break;
          Until False;
    10: ThisUser.ScreenSize := strS2I(AskUserInfo(TBBSCore(Owner).GetPrompt(189), True,  2,  2, -2, strI2S(bbsConfig.DefScreenSize)));
    11: AskPassword(True);
    12: AskAlias(ThisUser.Handle);
    13: AskRealName;
    14: AskTheme;
    15: ThisUser.FSEditor := Not ThisUser.FSEditor;
    16: If Access(bbsConfig.AcsInvLogin) Then Begin
          ThisUser.Invisible := Not ThisUser.Invisible;
          //Set_Node_Action (Chat.Action);
        End;
    17: ThisUser.FSFileList  := Not ThisUser.FSFileList;
    18: ThisUser.Available   := Not ThisUser.Available;
    19: ThisUser.HotKeys     := Not ThisUser.HotKeys;
    20: ThisUser.FSMsgReader := Not ThisUser.FSMsgReader;
    21: ThisUser.FSMsgIndex  := Not ThisUser.FSMsgIndex;
    22: ThisUser.Email       := AskUserInfo(TBBSCore(Owner).GetPrompt(191), True, 40, 40, -1, ThisUser.Email);
    23: ThisUser.UserInfo    := AskUserInfo(TBBSCore(Owner).GetPrompt(192), True, 40, 40, -1, ThisUser.UserInfo);
    24: ThisUser.QuoteWindow := Not ThisUser.QuoteWindow;
    25: ThisUser.FSMsgEIndex := Not ThisUser.FSMsgEIndex;
    26: ThisUser.FSNodeChat  := Not ThisUser.FSNodeChat;
    27: ThisUser.ChatName    := AskUserInfo(TBBSCore(Owner).GetPrompt(193), True, 30, 30, -1, ThisUser.ChatName);
//  28: ThisUser.MsgInitials := AskUserInfo(TBBSCore(Owner).GetPrompt(194), False,  3,  3, -1, ThisUser.MsgInitials);
    29..
    38: With bbsConfig.OptionalField[Mode] Do Begin
          Dec (Mode, 28);

          Case iType of
            0 : ThisUser.Optional[Mode] := AskUserInfo(TBBSCore(Owner).GetPrompt(215 + Mode), True, iField, iMax,  -1, '');
            1 : ThisUser.Optional[Mode] := AskUserInfo(TBBSCore(Owner).GetPrompt(215 + Mode), True, iField, iMax,  -2, '');
            2 : ThisUser.Optional[Mode] := AskUserInfo(TBBSCore(Owner).GetPrompt(215 + Mode), True, iField, iMax,  -3, '');
            3 : ThisUser.Optional[Mode] := AskUserInfo(TBBSCore(Owner).GetPrompt(215 + Mode), True, iField, iMax,  -4, '');
            4 : ThisUser.Optional[Mode] := AskUserInfo(TBBSCore(Owner).GetPrompt(215 + Mode), True, iField, iMax,  -5, '');
            5 : ThisUser.Optional[Mode] := AskUserInfo(TBBSCore(Owner).GetPrompt(215 + Mode), True, iField, iMax,  -6, '');
            6 : ThisUser.Optional[Mode] := AskUserInfo(TBBSCore(Owner).GetPrompt(215 + Mode), True, iField, iMax,  -7, '');
            7 : ThisUser.Optional[Mode] := AskUserInfo(TBBSCore(Owner).GetPrompt(215 + Mode), True, iField, iMax, -10, '');
            8 : ThisUser.Optional[Mode] := AskUserInfo(TBBSCore(Owner).GetPrompt(215 + Mode), True, iField, iMax, -11, '');
            9 : If ThisUser.Optional[Mode] = 'YES' Then
                  ThisUser.Optional[Mode] := 'NO'
                Else
                  ThisUser.Optional[Mode] := 'YES';
          End;
        End;
    39: ThisUser.AutoSig := Not ThisUser.AutoSig;
  End;
// qwk options
// archive type
End;

Function TBBSUser.CreateNewUser (Str: String) : Boolean;
Var
  UserFile : File;
  DataFile : File;
  PermIdx  : LongInt;
  Count    : LongInt;
//  Mode     : LongInt;
Begin
  Result := False;

  If Not bbsConfig.AllowNewUsers Then Begin
    TBBSCore(Owner).Term.OutFile('nonewuser');
    Exit;
  End;

  If bbsConfig.NewUserPW <> '' Then
    If Not TBBSCore(Owner).CheckPassword(13, 14, bbsConfig.NewUserPW) Then Begin
      TBBSCore(Owner).Shutdown := True;
      Exit;
    End;

  InitializeUserData;

  TBBSCore(Owner).Term.OutFile('newuser1');

  If ExecuteMPE (Owner, 'apply') > 0 Then Begin
    If ThisUser.RealName    = '' Then ThisUser.RealName    := ThisUser.Handle;
    If ThisUser.Handle      = '' Then ThisUser.Handle      := ThisUser.RealName;
    If ThisUser.ChatName    = '' Then ThisUser.ChatName    := ThisUser.Handle;
//  If ThisUser.MsgInitials = '' Then ThisUser.MsgInitials := strInitials(ThisUser.Handle);

    If { Test validity of user data }
      IsUser(ThisUser.RealName) or
      IsUser(ThisUser.Handle) or
      (ThisUser.Password = '') or
      (ThisUser.RealName = '') or
      (ThisUser.Handle   = '')
    Then Begin
      TBBSCore(Owner).Event.Trigger (evt_Error, Owner, 'User apply MPE');
      Exit;
    End;
  End Else Begin
    If bbsConfig.AskTheme          Then AskTheme;
    If bbsConfig.AskAlias          Then AskAlias(Str);
    If bbsConfig.AskRealname       Then AskRealName;
    If bbsConfig.AskStreet         Then ThisUser.Street      := AskUserInfo(TBBSCore(Owner).GetPrompt(25), False, 30, 30, -1, '');
    If bbsConfig.AskCityState      Then ThisUser.CityState   := AskUserInfo(TBBSCore(Owner).GetPrompt(26), False, 25, 25, -1, '');
    If bbsConfig.AskZipCode        Then ThisUser.ZipCode     := AskUserInfo(TBBSCore(Owner).GetPrompt(27), False, 10, 10, -2, '');
    If bbsConfig.AskHomePhone      Then ThisUser.HomePhone   := AskPhone(TBBSCore(Owner).GetPrompt(28), False, '');
    If bbsConfig.AskDataPhone      Then ThisUser.DataPhone   := AskPhone(TBBSCore(Owner).GetPrompt(29), False, '');
    If bbsConfig.AskGender         Then AskGender(TBBSCore(Owner).GetPrompt(30));
    If bbsConfig.NewDateFormat = 0 Then AskDateFormat(TBBSCore(Owner).GetPrompt(31)) Else ThisUser.DateType := bbsConfig.NewDateFormat;
    If bbsConfig.AskBirthdate      Then ThisUser.Birthdate   := DateStr2Julian(AskUserInfo(TBBSCore(Owner).GetPrompt(33), False,  8,  8, -5, ''));
    If bbsConfig.AskEmail          Then ThisUser.Email       := AskUserInfo(TBBSCore(Owner).GetPrompt(34), False, 40, 40, -1, '');
    If bbsConfig.AskUserInfo       Then ThisUser.UserInfo    := AskUserInfo(TBBSCore(Owner).GetPrompt(35), False, 40, 40, -1, '');
    If bbsConfig.AskChatHandle     Then ThisUser.ChatName    := AskUserInfo(TBBSCore(Owner).GetPrompt(64), False, 30, 30, -1, ThisUser.Handle);

    For Count := 1 to 10 Do
      If bbsConfig.OptionalField[Count].Ask Then
        With bbsConfig.OptionalField[Count] Do
          Case iType of
            0 : ThisUser.Optional[Count] := AskUserInfo(TBBSCore(Owner).GetPrompt(205 + Count), False, iField, iMax,  -1, '');
            1 : ThisUser.Optional[Count] := AskUserInfo(TBBSCore(Owner).GetPrompt(205 + Count), False, iField, iMax,  -2, '');
            2 : ThisUser.Optional[Count] := AskUserInfo(TBBSCore(Owner).GetPrompt(205 + Count), False, iField, iMax,  -3, '');
            3 : ThisUser.Optional[Count] := AskUserInfo(TBBSCore(Owner).GetPrompt(205 + Count), False, iField, iMax,  -4, '');
            4 : ThisUser.Optional[Count] := AskUserInfo(TBBSCore(Owner).GetPrompt(205 + Count), False, iField, iMax,  -5, '');
            5 : ThisUser.Optional[Count] := AskUserInfo(TBBSCore(Owner).GetPrompt(205 + Count), False, iField, iMax,  -6, '');
            6 : ThisUser.Optional[Count] := AskUserInfo(TBBSCore(Owner).GetPrompt(205 + Count), False, iField, iMax,  -7, '');
            7 : ThisUser.Optional[Count] := AskUserInfo(TBBSCore(Owner).GetPrompt(205 + Count), False, iField, iMax, -10, '');
            8 : ThisUser.Optional[Count] := AskUserInfo(TBBSCore(Owner).GetPrompt(205 + Count), False, iField, iMax, -11, '');
            9 : If TBBSCore(Owner).Term.GetYN(TBBSCore(Owner).GetPrompt(205 + Count), False) Then
                  ThisUser.Optional[Count] := 'YES'
                Else
                  ThisUser.Optional[Count] := 'NO';
          End;

    If bbsConfig.AskScreenSize     Then ThisUser.ScreenSize := strS2I(AskUserInfo(TBBSCore(Owner).GetPrompt(36), True,  2,  2, -2, strI2S(bbsConfig.DefScreenSize)));

    If bbsConfig.HotKeys = 2 Then
      ThisUser.HotKeys := TBBSCore(Owner).Term.GetYN(TBBSCore(Owner).GetPrompt(37), True)
    Else
      ThisUser.HotKeys := Boolean(bbsConfig.HotKeys);

    If bbsConfig.FSEditor = 2 Then
      ThisUser.FSEditor := TBBSCore(Owner).Term.GetYN(TBBSCore(Owner).GetPrompt(38), True)
    Else
      ThisUser.FSEditor := Boolean(bbsConfig.FSEditor);

    If bbsConfig.QuoteWindow = 2 Then
      ThisUser.QuoteWindow := TBBSCore(Owner).Term.GetYN(TBBSCore(Owner).GetPrompt(39), True)
    Else
      ThisUser.QuoteWindow := Boolean(bbsConfig.QuoteWindow);

    If bbsConfig.FileListType = 2 Then
      ThisUser.FSFileList := TBBSCore(Owner).Term.GetYN(TBBSCore(Owner).GetPrompt(40), True)
    Else
      ThisUser.FSFileList := Boolean(bbsConfig.FileListType);

    If bbsConfig.MsgReaderType = 2 Then
      ThisUser.FSMsgReader := TBBSCore(Owner).Term.GetYN(TBBSCore(Owner).GetPrompt(41), True)
    Else
      ThisUser.FSMsgReader := Boolean(bbsConfig.MsgReaderType);

    If bbsConfig.MsgAtIndex = 2 Then
      ThisUser.FSMsgIndex := TBBSCore(Owner).Term.GetYN(TBBSCore(Owner).GetPrompt(42), False)
    Else
      ThisUser.FSMsgIndex := Boolean(bbsConfig.MsgAtIndex);

    If bbsConfig.EmailAtIndex = 2 Then
      ThisUser.FSMsgEIndex := TBBSCore(Owner).Term.GetYN(TBBSCore(Owner).GetPrompt(43), True)
    Else
      ThisUser.FSMsgEIndex := Boolean(bbsConfig.EmailAtIndex);

    If bbsConfig.ChatType = 2 Then
      ThisUser.FSNodeChat := TBBSCore(Owner).Term.GetYN(TBBSCore(Owner).GetPrompt(44), True)
    Else
      ThisUser.FSNodeChat := Boolean(bbsConfig.ChatType);

    AskPassword(False);

    If Not bbsConfig.AskRealName Then ThisUser.RealName := ThisUser.Handle;
    If Not bbsConfig.AskAlias    Then ThisUser.Handle   := ThisUser.RealName;
    If ThisUser.ChatName = ''    Then ThisUser.ChatName := ThisUser.Handle;
  End;

  ThisUser.FirstCall    := CurDateDos;
  ThisUser.LastFGroup   := bbsConfig.FirstFileGroup;
  ThisUser.LastMGroup   := bbsConfig.FirstMsgGroup;
  ThisUser.Archive      := bbsConfig.DefArchive;
  ThisUser.Available    := True;

  Security_Upgrade(ThisUser, bbsConfig.NewUserSec);

  TBBSCore(Owner).Menu.MenuName := 'newinfo';
  TBBSCore(Owner).Menu.ExecuteMenu(True, False, True);

  TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(55));
  TBBSCore(Owner).SystemLog('Created account: ' + ThisUser.Handle);

  If TBBSCore(Owner).ShutDown Then Exit;

  Assign (DataFile, bbsConfig.PathData + 'users.ptr');
  If ioReset (DataFile, 4, fmReadWrite + fmDenyWrite) Then Begin
    ioRead (DataFile, PermIdx);
    Inc    (PermIdx);
  End Else Begin
    ioReWrite (DataFile, 4, fmReadWrite + fmDenyWrite);
    PermIdx := 1;
  End;

  ioSeek  (DataFile, 0);
  ioWrite (DataFile, PermIdx);
  Close   (DataFile);

  Assign (UserFile, bbsConfig.PathData + 'users.dat');
  If Not ioReset (UserFile, SizeOf(recUser), fmReadWrite + fmDenyWrite) Then
    ioReWrite (UserFile, SizeOf(recUser), fmReadWrite + fmDenyWrite);

  ThisUserPos     := FileSize(UserFile);
  ThisUser.UserID := PermIdx;

  ioSeek  (UserFile, ThisUserPos);
  ioWrite (UserFile, ThisUser);
  Close   (UserFile);

  If FileExist(bbsConfig.PathData + 'newletter.txt') Then
    TBBSCore(Owner).Msgs.PostTextFile('newletter.txt;1;' + bbsConfig.SysopName + ';' + ThisUser.Handle + ';Welcome', True);

  If FileExist(bbsConfig.PathData + 'sysletter.txt') Then
    TBBSCore(Owner).Msgs.PostTextFile('sysletter.txt;1;' + bbsConfig.SysopName + ';' + bbsConfig.SysopName + ';New account created!', True);

  // if notify sysop then send the message
  // if feedback then send feedback
  // run newuser.mpe

  Result := True;
End;

Function TBBSUser.GetMatrixUser : Boolean;
Var
  User   : RecUser;
  RecPos : LongInt;
  Str    : String[30];
Begin
  Result := False;

  If ThisUserPos <> -1 Then Begin
    Result := True;
    Exit;
  End;

  TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(170));
  Str := TBBSCore(Owner).Term.GetStr(30, 30, -8, '');

  If Not SearchForUser (Str, User, RecPos) Then Exit;
  If Not TBBSCore(Owner).CheckPassword(171, 172, User.Password) Then Begin
    If bbsConfig.PWInquiry Then
      If TBBSCore(Owner).Term.GetYN(TBBSCore(Owner).GetPrompt(256), False) Then
        TBBSCore(Owner).Msgs.PostMessage(True, '/T:' + strReplace(bbsConfig.SysopName, ' ', '_') + ' /S:Password Inquiry');

    TBBSCore(Owner).Msgs.PostTextFile('hackwarn.txt;1;' + bbsConfig.SysopName + ';' + User.Handle + ';Hack attempt', True);
    Exit;
  End;

  ThisUser    := User;
  ThisUserPos := RecPos;
  Result      := True;
End;

Function TBBSUser.DoUserLogin : Boolean;
Var
  Count : LongInt;
  Str   : String;
  User  : recUser;
  Rec   : LongInt;
Begin
  Result := False;
  Count  := 0;

  If bbsConfig.UseMatrix Then Begin
    MatrixOK := False;

    Repeat
      TBBSCore(Owner).Menu.MenuName := bbsConfig.MatrixMenu;
      TBBSCore(Owner).Menu.ExecuteMenu(True, True, True);
    Until MatrixOK or TBBSCore(Owner).ShutDown;

    Result := MatrixOK;
    Exit;
  End;

  TBBSCore(Owner).Term.OutFile('prelogon');

  Repeat
    Inc (Count);

    TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(6));

    Str := TBBSCore(Owner).Term.GetStr(30, 30, -8, '');

    If SearchForUser(Str, User, Rec) Then Begin
      TBBSCore(Owner).SystemLog('Login attempt: ' + Str);
      If TBBSCore(Owner).CheckPassword(8, 7, User.Password) Then Begin
        ThisUser    := User;
        ThisUserPos := Rec;
        Result      := True;
        Exit;
      End Else Begin
        If bbsConfig.PWInquiry Then
          If TBBSCore(Owner).Term.GetYN(TBBSCore(Owner).GetPrompt(256), False) Then
            TBBSCore(Owner).Msgs.PostMessage(True, '/T:' + strReplace(bbsConfig.SysopName, ' ', '_') + ' /S:Password Inquiry');

        TBBSCore(Owner).Msgs.PostTextFile('hackwarn.txt;1;' + bbsConfig.SysopName + ';' + User.Handle + ';Hack attempt', True);
      End;
    End Else Begin
      TBBSCore(Owner).Term.OutFile ('newuser');
      If TBBSCore(Owner).Term.GetYN(TBBSCore(Owner).GetPrompt(9), False) Then
        If CreateNewUser(Str) Then Begin
          Result := True;
          Exit;
        End;
    End;
  Until (Count = bbsConfig.LoginAttempts) or TBBSCore(Owner).Shutdown;
End;

Function TBBSUser.IsUserOnline (Str: String) : LongInt;
Var
  Count : Byte;
Begin
  Result := 0;

  For Count := 1 to bbsConfig.INetTNMax Do
    If TBBSCore(Owner).Owner.Manager.ClientList[Count - 1] <> NIL Then
      If strUpper(Str) = strUpper(TTelnetServer(TBBSCore(Owner).Owner.Manager.ClientList[Count - 1]).BBS.User.ThisUser.Handle) Then Begin
        Result := Count - 1;
        Exit;
      End;
End;

End.
