{$I M_OPS.PAS}

Unit BBS_Telnet;

Interface

Uses
  BBS_Core;

Procedure TelnetClient (Owner: TBBSCore; Data: String);

Implementation

Uses
  m_Types,
  m_Socket_Class,
  m_Output,
  m_Strings,
  m_DateTime,
  BBS_Events;

Procedure TelnetClient (Owner: TBBSCore; Data: String);
Const
  TelnetBufferSize = 4 * 1024;
Var
  Client    : TSocketClass;
  Image     : TConsoleImageRec;
  Saved     : Boolean;
  ExitAfter : Boolean;
  Connected : Boolean;

  Procedure Connect (Addr: String);
  Var
    Port : String[6];
  Begin
    Client := TSocketClass.Create;
    Client.FTelnetClient := True;

    Port := strWordGet(2, Addr, ' ');
    Addr := strWordGet(1, Addr, ' ');

    If Port = '' Then Port := '23';

    Owner.Term.PromptInfo['A'] := Addr;
    Owner.Term.PromptInfo['B'] := Port;

    Owner.Term.OutFull (Owner.GetPrompt(249));

    If Client.Connect(Addr, Port) Then
      Owner.Term.OutPipeLn(Owner.GetPrompt(250))
    Else Begin
      Owner.Term.OutPipeLn(Owner.GetPrompt(251));
      Client.Free;
      Exit;
    End;

    Connected := True;
  End;

  Procedure ClientLoop;
  Var
    Done  : Boolean;
    Res   : LongInt;
//    Count : LongInt;
    Buf   : Array[1..TelnetBufferSize] of Char;
  Begin
    Done := False;

    Repeat
      If Client.WaitForData(0) > 0 Then Begin
        Repeat
          Res := Client.ReadBuf(Buf, TelnetBufferSize);

          If Res < 0 Then Begin
            Client.Free;
            Done := True;
            Owner.Term.OutFullLn(Owner.GetPrompt(252));
            Break;
          End;

          Owner.Term.Terminal.ProcessBuf(Buf[1], Res);
          Owner.Client.WriteBuf(Buf, Res);
        Until (Res <> TelnetBufferSize) or Owner.ShutDown;
      End Else
      If Owner.Client.WaitForData(0) > 0 Then Begin
        Repeat
          Res := Owner.Client.ReadBuf(Buf, TelnetBufferSize);

          If Res < 0 Then Begin
            Client.Free;
            Done := True;
            Owner.Event.Trigger(evt_ConnectionLost, Owner, '');
            Break;
          End;

          If Buf[1] = ^] Then Begin
            Saved := True;
            Owner.Term.Console.GetScreenImage(1, 1, 80, 24, Image);
            Exit;
          End;

          Owner.Term.Terminal.ProcessBuf(Buf[1], Res);
          Client.WriteBuf(Buf, Res);
        Until Res <> TelnetBufferSize;
      End Else
        WaitMS(10);
    Until Done or Owner.ShutDown;

    Connected := False;
  End;

Var
  Str : String;
  Cmd : String;
Begin
  Connected := False;
  ExitAfter := False;
  Saved     := False;

  If Data <> '' Then Begin
    ExitAfter := True;

    Connect(Data);
    If Connected Then ClientLoop;

    If Not Connected Then Exit;
  End;

  Repeat
    Owner.Term.OutFull (Owner.GetPrompt(253));

    Str := Owner.Term.GetStr(40, 255, 1, '');
    Cmd := strUpper(strWordGet(1, Str, ' '));

    If Cmd = 'QUIT' Then
      Break
    Else
    If (Cmd = 'CLOSE') and Connected Then Begin
      Client.Free;
      Connected := False;
      Owner.Term.OutFullLn(Owner.GetPrompt(252));
    End Else
    If (Cmd = 'OPEN') Then Begin
      If Connected Then
        Owner.Term.OutFullLn(Owner.GetPrompt(254))
      Else Begin
        Connect(strStripB(Copy(Str, 5, 255), ' '));
        If Connected Then ClientLoop;
      End;
    End Else
    If (Cmd = '?') or (Cmd = 'HELP') Then
      Owner.Term.OutFullLn(Owner.GetPrompt(255))
    Else
    If (Cmd = '') and (Connected) Then Begin
      If Saved Then Begin
        Owner.Term.RemoteRestore(Image, True);
        Saved := False;
      End;
      ClientLoop;
    End;
  Until Owner.ShutDown;

  If Connected Then Client.Free;
End;

{commands: echo    term}

End.
