Unit BBS_NodeMsg;

{$I M_OPS.PAS}

Interface

Uses
  Class_Sync,
  BBS_Common;

Type
  TBBSNodeMsg = Class
    Owner    : Pointer;
    Data     : Array[1..255] of PtrNodeMsg;
    Count    : Byte;

    Constructor Create (O: Pointer);
    Destructor  Destroy; Override;
    Procedure   AddMsg (mOrigin, mType: Byte; mText: String; mRoom: Byte);
    Function    GetMsg (Var mOrigin, mType: Byte; Var mText: String; Var mRoom: Byte) : Boolean;
  End;

Implementation

Uses
  BBS_Core;

Constructor TBBSNodeMsg.Create (O: Pointer);
Begin
  Inherited Create;

  Owner := O;
  Count := 0;
End;

Destructor TBBSNodeMsg.Destroy;
Begin
  Inherited Destroy;
End;

Procedure TBBSNodeMsg.AddMsg (mOrigin, mType: Byte; mText: String; mRoom: Byte);
Begin
  TBBSCore(Owner).Critical.Start;

  Inc (Count);

  New (Data[Count]);

  Data[Count]^.MsgOrigin := mOrigin;
  Data[Count]^.MsgType   := mType;
  Data[Count]^.MsgData   := mText;
  Data[Count]^.MsgRoom   := mRoom;

  TBBSCore(Owner).Critical.Finish;
End;

Function TBBSNodeMsg.GetMsg (Var mOrigin, mType: Byte; Var mText: String; Var mRoom: Byte) : Boolean;
//var a :byte;
Begin
  Result := False;

  If Count = 0 Then Exit;

  TBBSCore(Owner).Critical.Start;

  mOrigin := Data[1]^.MsgOrigin;
  mType   := Data[1]^.MsgType;
  mText   := Data[1]^.MsgData;
  mRoom   := Data[1]^.MsgRoom;

  Dispose (Data[1]);
  Dec     (Count);

  If Count > 0 Then
    Move (Data[2], Data[1], Count * SizeOf(Pointer));

  TBBSCore(Owner).Critical.Finish;

  Result := True;
End;

End.
