{$I M_OPS.PAS}

Unit BBS_Multinode;

Interface

Uses
  BBS_Core;

Procedure WhosOnline      (Const Owner: TBBSCore; Data: String);
Procedure PageUserForChat (Const Owner: TBBSCore);
Procedure SendNodeMessage (Const Owner: TBBSCore; Data: String);
Procedure User2UserChat   (Const Owner1, Owner2: TBBSCore);

Implementation

Uses
  m_Strings,
  m_DateTime,
  BBS_Common,
//  BBS_NodeMsg,
  Mystic_Telnet,
  BBS_Events;

Procedure WhosOnline (Const Owner: TBBSCore; Data: String);
{ /a : show only active nodes }
Var
  Active : Boolean;
  Count  : LongInt;
  Node   : TBBSCore;
  Saved  : Boolean;
Begin
  Saved := Owner.Term.NoBufFlush;
  Owner.Term.NoBufFlush := True;

  Active := Pos('/A', strUpper(Data)) > 0;

  Owner.Term.AllowPause := True;
  Owner.Term.PausePos   := 1;

  Owner.Term.OutFullLn(Owner.GetPrompt(231));

  For Count := 0 to bbsConfig.InetTNMax - 1 Do Begin
    Owner.Term.PromptInfo['A'] := strI2S(Count + 1);

    If Owner.Owner.Manager.ClientList[Count] <> NIL Then Begin
      Node := TTelnetServer(Owner.Owner.Manager.ClientList[Count]).BBS;

      If Node.User.ThisUser.Invisible Then
        If Not Owner.User.Access(bbsConfig.AcsSeeInvis) Then
          Continue;

      Owner.Term.PromptInfo['B'] := Node.User.ThisUser.Handle;
      Owner.Term.PromptInfo['C'] := Node.User.UserAction;
      Owner.Term.PromptInfo['D'] := Node.User.ThisUser.CityState;
      Owner.Term.PromptInfo['E'] := Node.User.ThisUser.Gender;
      Owner.Term.PromptInfo['F'] := strI2S(DaysAgo(Node.User.ThisUser.Birthdate) DIV 365);
      Owner.Term.PromptInfo['G'] := Owner.Term.OutYesNo(Node.User.ThisUser.Available);
      Owner.Term.PromptInfo['H'] := strI2S(Node.User.ThisUser.Security);
      Owner.Term.PromptInfo['I'] := Node.User.ThisUser.UserInfo;

      Owner.Term.OutFullLn(Owner.GetPrompt(232));
    End Else
      If Not Active Then
        Owner.Term.OutFullLn(Owner.GetPrompt(233));

    If (Owner.Term.PausePos = Owner.User.ThisUser.ScreenSize) And (Owner.Term.AllowPause) Then
      Case Owner.Term.MorePrompt of
        'N' : Break;
        'C' : Owner.Term.AllowPause := False;
      End;
  End;

  Owner.Term.OutFull(Owner.GetPrompt(234));

  Owner.Term.BufFlush;
  Owner.Term.NoBufFlush := Saved;
End;

Procedure PageUserForChat (Const Owner: TBBSCore);
Var
  Str    : String;
  ToNode : Byte;
Begin
  Repeat
    Owner.Term.OutFull(Owner.GetPrompt(272));
    Str := Owner.Term.GetStr(3, 3, -2, '');
    If Str = '?' Then WhosOnline(Owner, '') Else
    If Str = 'Q' Then Exit Else Break;
  Until Owner.ShutDown;

  If Owner.ShutDown Then Exit;

  ToNode := strS2I(Str);

  If (ToNode < 1) or (ToNode > bbsConfig.INetTNMax) or (Owner.Owner.Manager.ClientList[ToNode - 1] = NIL) Then Begin
    Owner.Term.OutFullLn(Owner.GetPrompt(259));
    Exit;
  End;

  If (ToNode = Owner.Node) or (Not TTelnetServer(Owner.Owner.Manager.ClientList[ToNode - 1]).BBS.User.ThisUser.Available) Then Begin
    Owner.Term.OutFullLn(Owner.GetPrompt(268));
    Exit;
  End;

  Owner.Term.PromptInfo['A'] := TTelnetServer(Owner.Owner.Manager.ClientList[ToNode - 1]).BBS.User.ThisUser.Handle;

  Owner.Term.OutFullLn(Owner.GetPrompt(273));

  TTelnetServer(Owner.Owner.Manager.ClientList[ToNode - 1]).BBS.NodeMsg.AddMsg(Owner.Node, nodeChatRequest, Owner.User.ThisUser.Handle, 0);
End;

Procedure SendNodeMessage (Const Owner: TBBSCore; Data: String);
Var
  Str      : String[3];
  FromNode : Byte;
  ToNode   : Byte;
  MsgType  : Byte;
  MsgText  : String;
  Count    : Byte;
Begin
  MsgType := nodeMessage;

  If Data = '' Then Begin
    Repeat
      Owner.Term.OutFull(Owner.GetPrompt(258));
      Str := Owner.Term.GetStr(3, 3, -2, '');
      If Str = '?' Then WhosOnline(Owner, '') Else
      If Str = 'Q' Then Exit Else Break;
    Until Owner.ShutDown;

    If Owner.ShutDown Then Exit;

    FromNode := strS2I(Str);
    ToNode   := FromNode;

    If (ToNode < 1) or (ToNode > bbsConfig.INetTNMax) or (Owner.Owner.Manager.ClientList[ToNode - 1] = NIL) Then Begin
      Owner.Term.OutFullLn (Owner.GetPrompt(259));
      Exit;
    End;

    If Not TTelnetServer(Owner.Owner.Manager.ClientList[ToNode - 1]).BBS.User.ThisUser.Available Then Begin
      Owner.Term.OutFullLn(Owner.GetPrompt(268));
      Exit;
    End;

    Owner.Term.PromptInfo['A'] := strI2S(FromNode);
    Owner.Term.OutFull(Owner.GetPrompt(260));

    MsgText := Owner.Term.GetStr(78, 255, -1, '');

    If MsgText = '' Then Exit;
  End Else Begin
    If Pos(';', Data) = 0 Then Exit;

    FromNode := strS2I(strWordGet(1, Data, ';'));

    If FromNode = 0 Then Begin
      FromNode := 1;
      ToNode   := bbsConfig.INetTNMax;
      MsgType  := nodeBroadcast;
    End Else
      ToNode := FromNode;

    MsgText := Copy(Data, Pos(';', Data) + 1, 255);
  End;

  For Count := FromNode to ToNode Do
    If Owner.Owner.Manager.ClientList[Count - 1] <> NIL Then
      TTelnetServer(Owner.Owner.Manager.ClientList[Count - 1]).BBS.NodeMsg.AddMsg(Owner.Node, MsgType, MsgText, 0);
End;

Procedure SplitChatMode (Const Owner1, Owner2: TBBSCore);
Type
  ChatInfoRec = Record
    CurX     : Byte;
    CurY     : Byte;
    Text     : String;
    WinTop   : Byte;
    WinLeft  : Byte;
    WinBot   : Byte;
    WinRight : Byte;
    TextAttr : Byte;
    Current  : Boolean;
  End;

Var
  User1 : ChatInfoRec;
  User2 : ChatInfoRec;
  Ch    : Char;
  Done  : Boolean;
  Node  : Integer;

  Procedure ReDraw;
  Begin
    Done := False;

    Owner1.Term.ShowTemplate('ansichat');

    User1.WinTop   := Owner1.Term.ScreenInfo[1].Y;
    User1.WinLeft  := Owner1.Term.ScreenInfo[1].X;
    User1.WinBot   := Owner1.Term.ScreenInfo[2].Y;
    User1.WinRight := Owner1.Term.ScreenInfo[2].X;
    User1.TextAttr := Owner1.Term.ScreenInfo[1].A;
    User1.Current  := False;
    User1.Text     := '';
    User1.CurX     := User1.WinLeft;
    User1.CurY     := User1.WinTop;

    User2.WinTop   := Owner1.Term.ScreenInfo[4].Y;
    User2.WinLeft  := Owner1.Term.ScreenInfo[4].X;
    User2.WinBot   := Owner1.Term.ScreenInfo[5].Y;
    User2.WinRight := Owner1.Term.ScreenInfo[5].X;
    User2.TextAttr := Owner1.Term.ScreenInfo[4].A;
    User2.Current  := False;
    User2.Text     := '';
    User2.CurX     := User2.WinLeft;
    User2.CurY     := User2.WinTop;

    Owner1.Term.OutRaw (
      Owner1.Term.AnsiGotoXY(Owner1.Term.ScreenInfo[3].X, Owner1.Term.ScreenInfo[3].Y) +
      Owner1.Term.Attr2Ansi(Owner1.Term.ScreenInfo[3].A, False) +
      Owner1.User.ThisUser.Handle
    );

    Owner1.Term.OutRaw (
      Owner1.Term.AnsiGotoXY(Owner1.Term.ScreenInfo[6].X, Owner1.Term.ScreenInfo[6].Y) +
      Owner1.Term.Attr2Ansi(Owner1.Term.ScreenInfo[6].A, False) +
      Owner2.User.ThisUser.Handle
    );
  End;

  Procedure ClearWindow (Var User: ChatInfoRec; Text: String);
  Var
    Count : Byte;
  Begin
    For Count := User.WinBot DownTo User.WinTop Do
      Owner1.Term.OutRaw (
        Owner1.Term.AnsiGotoXY(User.WinLeft, Count) +
        strRep(' ', User.WinRight - User.WinLeft + 1)
      );

    User.CurX := User.WinLeft;
    User.CurY := User.WinTop + 1;

    Owner1.Term.OutRaw (
      Owner1.Term.AnsiGotoXY(User.WinLeft, User.WinTop) +
      Text +
      Owner1.Term.AnsiGotoXY(User.CurX, User.CurY)
    );
  End;

  Procedure AddChar (Var User, Other: ChatInfoRec; Ch: Char);
  Var
    TempStr : String;
  Begin
    If Not User.Current Then Begin
      Owner1.Term.OutRaw(Owner1.Term.AnsiGotoXY(User.CurX, User.CurY) + Owner1.Term.Attr2Ansi(User.TextAttr, False));

      User.Current  := True;
      Other.Current := False;
    End;

    Case Ch of
      #83,
      #08 : If User.Text <> '' Then Begin
              Owner1.Term.OutBS(1, True);
              Dec (User.Text[0]);
              Dec (User.CurX);
            End;
      #10 : ;
      #13 : Begin
              If User.CurY = User.WinBot Then
                ClearWindow(User, User.Text)
              Else Begin
                Inc (User.CurY);
                User.CurX := User.WinLeft;
                Owner1.Term.OutRaw(Owner1.Term.AnsiGotoXY(User.CurX, User.CurY));
              End;

              User.Text := '';
            End;
      #18 : ReDraw;
      #27 : Done := True;
    Else
      Owner1.Term.OutRaw(Ch);
      User.Text := User.Text + Ch;
      Inc (User.CurX);

      If User.CurX = User.WinRight Then Begin
        strWrap(User.Text, TempStr, User.CurX - User.WinLeft);

        If User.CurY = User.WinBot Then Begin
          ClearWindow(User, User.Text);
          User.Text := TempStr;
          Owner1.Term.OutRaw(User.Text);
          Inc (User.CurX, Length(User.Text));
        End Else Begin
          Inc (User.CurY);

          User.Text := TempStr;
          User.CurX := User.WinLeft + Length(TempStr);

          Owner1.Term.OutBS(Length(TempStr), True);
          Owner1.Term.OutRaw(Owner1.Term.AnsiGotoXY(User.WinLeft, User.CurY) + User.Text);
        End;
      End;
    End;
  End;

Begin
  Node := Owner2.Node;

  ReDraw;

  While Not Done And Not Owner1.ShutDown And (TTelnetServer(Owner1.Owner.Manager.ClientList[Node - 1]) <> NIL) Do Begin
    If Owner1.Term.KeyBufStr <> '' Then Begin
      Ch := Owner1.Term.KeyBufStr[1];
      Delete (Owner1.Term.KeyBufStr, 1, 1);
      AddChar (User2, User1, Ch);
    End Else Begin
      Ch := Owner1.Term.NewGetKey(200);
      If Ch = #0 Then Continue;
      Owner2.Term.KeyBufStr := Owner2.Term.KeyBufStr + Ch;
      AddChar (User1, User2, Ch);
    End;
  End;

  Owner1.Term.OutPipe('|16');
End;

Procedure LineChatMode (Const Owner1, Owner2: TBBSCore);
Var
  Ch       : Char;
  IsOne    : Boolean;
  ChatText : String;
  Temp     : String;
  Node     : Integer;
Begin
  Node     := Owner2.Node;
  ChatText := '';

  While Not Owner1.ShutDown And (TTelnetServer(Owner2.Owner.Manager.ClientList[Node - 1]) <> NIL) Do Begin
    If Owner1.Term.KeyBufStr <> '' Then Begin
      Ch := Owner1.Term.KeyBufStr[1];
      Delete (Owner1.Term.KeyBufStr, 1, 1);
      IsOne := False;
    End Else Begin
      Ch := Owner1.Term.NewGetKey(200);
      If Ch = #0 Then Continue;
      IsOne := True;
      Owner2.Term.KeyBufStr := Owner2.Term.KeyBufStr + Ch;
    End;

    Case Ch of
      #83,
      #08 : If Length(ChatText) > 1 Then Begin
               Owner1.Term.OutBS(1, True);
              Dec(ChatText[0]);
            End;
      #13 : Begin
              ChatText := '';
              Owner1.Term.OutRawLn('');
            End;
      #27 : Break;
    Else
      If IsOne Then
        Owner1.Term.OutRaw(Owner1.Term.Attr2Ansi(Owner1.Theme.LineChat1, False))
      Else
        Owner1.Term.OutRaw(Owner1.Term.Attr2Ansi(Owner1.Theme.LineChat2, False));

      ChatText := ChatText + Ch;

      If Length(ChatText) > 79 Then Begin
        strWrap(ChatText, Temp, 79);
        Owner1.Term.OutBS(Length(Temp), True);
        Owner1.Term.OutRawLn('');
        ChatText := Temp;
        Owner1.Term.OutRaw(ChatText);
      End Else
        Owner1.Term.OutRaw(Ch);
    End;
  End;
End;

Procedure User2UserChat (Const Owner1, Owner2: TBBSCore);
Var
  SavedAvail  : Boolean;
  SavedAction : String;
Begin
  SavedAvail  := Owner1.User.ThisUser.Available;
  SavedAction := Owner1.User.UserAction;

  Owner1.User.ThisUser.Available := False;

  Owner1.User.UserAction := Owner1.GetPrompt(274);

  Owner1.Term.PromptInfo['A'] := Owner2.User.ThisUser.Handle;
  Owner1.Term.OutFullLn(Owner1.GetPrompt(271));

  If Owner1.Term.Graphics > 0 Then
    SplitChatMode (Owner1, Owner2)
  Else
    LineChatMode (Owner1, Owner2);

  Owner1.User.ThisUser.Available := SavedAvail;
  Owner1.User.UserAction         := SavedAction;
End;

End.
