{$I M_OPS.PAS}

Unit BBS_MenuData;

// change this to use buffered file i/o after implementation.

Interface

Uses
  m_FileIO,
  BBS_Common;

Type
  TMenuData = Class
    Menu     : File;
    Info     : RecMenuInfo;
    Item     : Array[1..mysMaxMenuItems] of PtrMenuItem;
    NumItems : Byte;

    Constructor Create;
    Destructor  Destroy; Override;
    Function    CreateNewMenu (FN: String) : Boolean;
    Function    Load          (Append: Boolean; FN: String) : Boolean;
    Function    Save          (FN: String) : Boolean;
    Procedure   Unload;
    Procedure   InsertItem    (Num: Word);
    Procedure   DeleteItem    (Num: Word);
    Procedure   CopyItem      (Source, Dest: Word);
    Procedure   InsertCommand (Num, CmdNum: Word);
    Procedure   DeleteCommand (Num, CmdNum: Word);
  End;

Implementation

Constructor TMenuData.Create;
Begin
  Inherited Create;

  FillChar (Info, SizeOf(Info), 0);
  NumItems := 0;
End;

Destructor TMenuData.Destroy;
Begin
  Unload;

  Inherited Destroy;
End;

Procedure TMenuData.Unload;
Var
  Count1 : LongInt;
  Count2 : LongInt;
Begin
//  If NumItems = 0 Then Exit;

  For Count1 := NumItems DownTo 1 Do Begin
    For Count2 := Item[Count1]^.Commands DownTo 1 Do
      Dispose (Item[Count1]^.CmdData[Count2]);

    Dispose (Item[Count1]);
  End;

  NumItems := 0;
End;

Function TMenuData.Load (Append: Boolean; FN: String) : Boolean;
Var
  Res   : LongInt;
  Count : LongInt;
  Junk  : RecMenuInfo;
Begin
  If Not Append Then Unload;
  //  If Not Append Then NumItems := 0; //Unload;
  // some how when doing the prompt menus... numitems is not reset

  Res    := 0;
  Result := False;

  If FN = '' Then Exit;

  Assign  (Menu, FN);
  ioReset (Menu, 1, fmReadWrite + fmDenyNone);

  If IoCode <> 0 Then Exit;

  ioBlockRead (Menu, Junk, SizeOf(Junk), Res);

  If IoCode <> 0 Then Begin
    Close (Menu);
    Exit;
  End;

  If Not Append Then Info := Junk;

  While Not Eof(Menu) And (NumItems <= mysMaxMenuItems) Do Begin
    Inc (NumItems);

    New (Item[NumItems]);

    ioBlockRead (Menu, Item[NumItems]^, SizeOf(RecMenuItem), Res);

    For Count := 1 to Item[NumItems]^.Commands Do Begin
      New (Item[NumItems]^.CmdData[Count]);

      ioBlockRead (Menu, Item[NumItems]^.CmdData[Count]^, SizeOf(RecMenuCmd), Res);
    End;
  End;

  Close (Menu);

  Result := True;
End;

Function TMenuData.Save (FN: String) : Boolean;
Var
  Res    : LongInt;
  Count  : LongInt;
  Count2 : LongInt;
Begin
  Result := False;
  Res    := 0;

  Assign    (Menu, FN);
  ioReWrite (Menu, 1, fmReadWrite + fmDenyNone);

  If IoCode <> 0 Then Exit;

  ioBlockWrite (Menu, Info, SizeOf(Info), Res);

  For Count := 1 to NumItems Do Begin
    ioBlockWrite (Menu, Item[Count]^, SizeOf(recMenuItem), Res);

    For Count2 := 1 to Item[Count]^.Commands Do
      ioBlockWrite(Menu, Item[Count]^.CmdData[Count2]^, SizeOf(RecMenuCmd), Res);
  End;

  Close (Menu);

  Result := True;
End;

Procedure TMenuData.DeleteItem (Num: Word);
Var
  Count : Word;
Begin
  If NumItems = 0 Then Exit;

  For Count := 1 to Item[Num]^.Commands Do
    Dispose (Item[Num]^.CmdData[Count]);

  Dispose (Item[Num]);

  For Count := Num To NumItems - 1 Do
    Item[Count] := Item[Count + 1];

  Dec(NumItems);
End;

Procedure TMenuData.DeleteCommand (Num, CmdNum: Word);
Var
  Count : Word;
Begin
  If Item[Num]^.Commands = 0 Then Exit;

  Dispose (Item[Num]^.CmdData[CmdNum]);

  For Count := CmdNum To Item[Num]^.Commands - 1 Do
    Item[Num]^.CmdData[Count] := Item[Num]^.CmdData[Count + 1];

  Dec (Item[Num]^.Commands);
End;

Procedure TMenuData.InsertCommand (Num, CmdNum: Word);
Var
  Count : Word;
Begin
  If Item[Num]^.Commands = mysMaxMenuCmds Then Exit;

  Inc (Item[Num]^.Commands);

  For Count := Item[Num]^.Commands DownTo CmdNum + 1 Do
    Item[Num]^.CmdData[Count] := Item[Num]^.CmdData[Count - 1];

  New (Item[Num]^.CmdData[CmdNum]);

  With Item[Num]^.CmdData[CmdNum]^ Do Begin
    MenuCmd := 'GO';
    Access  := '';
    Data    := 'main';
    JumpID  := 0;
  End;
End;

Procedure TMenuData.InsertItem (Num: Word);
Var
  Count : Word;
Begin
  If NumItems = mysMaxMenuItems Then Exit;

  Inc (NumItems);

  For Count := NumItems DownTo Num + 1 Do
    Item[Count] := Item[Count - 1];

  New (Item[Num]);

  With Item[Num]^ Do Begin
    Text       := '|09(|10Q|09) |03Quit to Main Menu';
    TextLo     := '|07Quit to Main Menu';
    TextHi     := '|15Quit to Main Menu';
    HotKey     := 'Q';
    Access     := '';
    ShowType   := 0;
    Redraw     := True;
    JumpUp     := 0;
    JumpDown   := 0;
    JumpLeft   := 0;
    JumpRight  := 0;
    JumpEscape := 0;
    JumpTab    := 0;
    JumpPgUp   := 0;
    JumpPgDn   := 0;
    X          := 0;
    Y          := 0;
    Commands   := 0;
    // use fillchar 0 and remove all those blah := 0 above
  End;

  InsertCommand(Num, 1);
End;

Function TMenuData.CreateNewMenu (FN: String) : Boolean;
Begin
  Info.Description := 'New Mystic BBS menu';
  Info.Header      := '|CR|14New Menu Header|CR';
  Info.Footer      := '|CR|09Selection|03: |11';
  Info.DispCols    := 3;

  InsertItem(1);

  Result := Save(FN);
End;

Procedure TMenuData.CopyItem (Source, Dest: Word);
Var
  Count : Word;
Begin
  If NumItems = mysMaxMenuItems Then Exit;

  Inc (NumItems);

  For Count := NumItems DownTo Dest + 1 Do
    Item[Count] := Item[Count - 1];

  New (Item[Dest]);

  Item[Dest]^ := Item[Source]^;

  For Count := 1 to Item[Source]^.Commands Do Begin
    New (Item[Dest]^.CmdData[Count]);

    Item[Dest]^.CmdData[Count]^ := Item[Source]^.CmdData[Count]^;
  End;
End;

End.
