{$I M_OPS.PAS}

Unit BBS_General;

Interface

Uses
  BBS_Core;

Procedure UserListing (Owner: TBBSCore; Data: String);

Implementation

Uses
  m_FileIO,
  m_Strings,
  m_DateTime,
  BBS_Common;

Procedure UserListing (Owner: TBBSCore; Data: String);
Var
  Total    : LongInt;
  User     : RecUser;
  UserFile : File;
  Ch       : Char;
  Saved    : Boolean;
Begin
  If strUpper(Data) = '/S' Then Begin
    Owner.Term.OutFull(Owner.GetPrompt(245));
    Data := Owner.Term.GetStr(30, 30, -2, '');
  End;

  Saved := Owner.Term.NoBufFlush;
  Owner.Term.NoBufFlush := True;

  Assign  (UserFile, bbsConfig.PathData + 'users.dat');
  ioReset (UserFile, SizeOf(RecUser), fmReadWrite + fmDenyNone);

  Owner.Term.PausePos   := 1;
  Owner.Term.AllowPause := True;

  Owner.Term.PromptInfo['A'] := strComma(FileSize(UserFile));

  Owner.Term.OutFullLn(Owner.GetPrompt(246));

  Total := 0;

  While Not Eof(UserFile) Do Begin
    ioRead (UserFile, User);

    If User.Flags And UserDeleted <> 0 Then Continue;

    Owner.Term.PromptInfo['A'] := User.Handle;
    Owner.Term.PromptInfo['B'] := User.CityState;
    Owner.Term.PromptInfo['C'] := DateDos2Str(User.LastCall, Owner.User.ThisUser.DateType);
    Owner.Term.PromptInfo['D'] := User.Gender;
    Owner.Term.PromptInfo['E'] := strI2S(User.Security);
    Owner.Term.PromptInfo['F'] := strI2S(DaysAgo(User.Birthdate) DIV 365);
    Owner.Term.PromptInfo['G'] := User.Email;
    Owner.Term.PromptInfo['H'] := User.UserInfo;

    For Ch := 'I' to 'R' Do
      Owner.Term.PromptInfo[Ch] := User.Optional[Byte(Ch) - 72];

    If (Data = '') or (Pos(Data, strUpper(User.Handle)) > 0) Then Begin
      Owner.Term.OutFullLn(Owner.GetPrompt(247));
      Inc (Total);

      If (Owner.Term.PausePos >= Owner.User.ThisUser.ScreenSize) And (Owner.Term.AllowPause) Then
        Case Owner.Term.MorePrompt of
          'N' : Break;
          'C' : Owner.Term.AllowPause := False;
        End;
    End;
  End;

  Close (UserFile);

  Owner.Term.PromptInfo['A'] := strComma(Total);
  Owner.Term.OutFull(Owner.GetPrompt(248));

  Owner.Term.BufFlush;
  Owner.Term.NoBufFlush := Saved;
End;

End.
