Unit BBS_FileBase;

{$I M_OPS.PAS}

// CHANGE PROMPTS TO USE FILE AREA PROMPTS
// UNCOMMENT LOADING OF LAST GROUP/BASE IN LOGIN

// ideas:
// 1. make some type of rating system for files and maybe some type of
//    comment system similar to oneliners or something
//    store date of upload, uploader, # of downloads, last downloaded
//
// 2. file bases should have 10 paths for files, flags to allow uploads,
//    each file path should have cdROM flag so mystic copies the file to
//    a temporary directory before sending

Interface

Uses
  BBS_Common;

Type
  TFileBase = Class
    Owner  : Pointer;
    FBase  : RecFileBase;
    FGroup : RecGroup;

    Constructor Create (O: Pointer);
    Destructor  Destroy; Override;
    Function    ListAreas   (Compress: Boolean) : LongInt;
    Procedure   ChangeGroup (Data: String; FirstBase, ShowFile: Boolean);
    Procedure   ChangeArea  (Data: String);
  End;

Implementation

Uses
  m_FileIO,
  m_Strings,
  BBS_Core;

Constructor TFileBase.Create (O: Pointer);
Begin
  Inherited Create;

  Owner := O;
End;

Destructor TFileBase.Destroy;
Begin
  Inherited Destroy;
End;

Function TFileBase.ListAreas (Compress: Boolean) : LongInt;
Var
  FBaseFile : TBufFile;
  TempBase  : RecFileBase;
  Total     : Word;
  Listed    : Word;
  StrHeader : String;
  StrMiddle : String;
Begin
  Result    := 0;
  FBaseFile := TBufFile.Create(4096);

  If Not FBaseFile.Open (bbsConfig.PathData + mysFBasesDat, fmOpen, fmReadWrite + fmDenyNone, SizeOf(RecFileBase)) Then Begin
    FBaseFile.Free;
    Exit;
  End;

  TBBSCore(Owner).Term.AllowPause := True;
  TBBSCore(Owner).Term.PausePos   := 1;

  Total  := 0;
  Listed := 0;

  Case bbsConfig.FColumns of
    1 : Begin
          StrHeader := TBBSCore(Owner).GetPrompt(279);
          StrMiddle := TBBSCore(Owner).GetPrompt(280);
        End;
    2 : Begin
          StrHeader := TBBSCore(Owner).GetPrompt(281);
          StrMiddle := TBBSCore(Owner).GetPrompt(282);
        End;
  End;

  While Not FBaseFile.EOF And Not TBBSCore(Owner).ShutDown Do Begin
    FBaseFile.Read (TempBase);

    If TBBSCore(Owner).User.Access(TempBase.ListACS) Then Begin
      Inc (Listed);

      If Listed = 1 Then TBBSCore(Owner).Term.OutFullLn(StrHeader);

      If Compress Then
        Inc (Total)
      Else
        Total := FBaseFile.FilePos;

      TBBSCore(Owner).Term.PromptInfo['A'] := strI2S(Total);
      TBBSCore(Owner).Term.PromptInfo['B'] := TempBase.Name;
      TBBSCore(Owner).Term.PromptInfo['C'] := '0';
//      TBBSCore(Owner).Term.PromptInfo['D'] := TempBase.Sponsor;

(*
      If OpenCreateBase (MsgBase, TempBase) Then Begin
        TBBSCore(Owner).Term.PromptInfo['C'] := strI2S(MsgBase^.NumberOfMsgs);
        MsgBase^.CloseMsgBase;
        Dispose (MsgBase, Done);
      End;
*)

      TBBSCore(Owner).Term.OutFull (StrMiddle);
      If (Listed Mod bbsConfig.FColumns = 0) and (Listed > 0) Then
        TBBSCore(Owner).Term.OutFullLn('');
    End;

    If FBaseFile.EOF And (Listed Mod bbsConfig.FColumns <> 0) Then
      TBBSCore(Owner).Term.OutFullLn('');

    If (TBBSCore(Owner).Term.PausePos = TBBSCore(Owner).User.ThisUser.ScreenSize) and (TBBSCore(Owner).Term.AllowPause) Then
      Case TBBSCore(Owner).Term.MorePrompt of
        'N' : Begin
                Total := FBaseFile.FileSize;
                Break;
              End;
        'C' : TBBSCore(Owner).Term.AllowPause := False;
      End;
  End;

  FBaseFile.Free;

  Result := Total;
End;

Procedure TFileBase.ChangeGroup (Data: String; FirstBase, ShowFile: Boolean);
// todo: add NOLIST option
Var
  GroupFile : File;
  FBaseFile : File;
  TempGroup : RecGroup;
  TempFBase : RecFileBase;
  Listed    : LongInt;
  Saved     : LongInt;
  FileAreas : LongInt;
  Count     : LongInt;
Begin
  Assign (GroupFile, bbsConfig.PathData + 'groups_f.dat');

  If (Data = '+') or (Data = '-') Then Begin
    If Not ioReset (GroupFile, SizeOf(RecGroup), fmReadWrite + fmDenyNone) Then Exit;

    Count := TBBSCore(Owner).User.ThisUser.LastFGroup - 1;

    Repeat
      Case Data[1] of
        '+' : Inc(Count);
        '-' : Dec(Count);
      End;

      If Not ioSeek(GroupFile, Count)     Then Break;
      If Not ioRead(GroupFile, TempGroup) Then Break;

      If TBBSCore(Owner).User.Access(TempGroup.Access) Then Begin
        TBBSCore(Owner).User.ThisUser.LastFGroup := FilePos(GroupFile);
        FGroup := TempGroup;
        Close (GroupFile);

        If ShowFile Then
          TBBSCore(Owner).Term.OutFile ('fgroup' + strI2S(TBBSCore(Owner).User.ThisUser.LastFGroup));

        If FirstBase Then Begin
          TBBSCore(Owner).User.ThisUser.LastFBase := 0;
          ChangeArea('+');
        End;

        Exit;
      End;
    Until False;

    Close (GroupFile);
    Exit;
  End;

  If Not ioReset (GroupFile, SizeOf(RecGroup), fmReadWrite + fmDenyNone) Then Exit;

  Count := strS2I(Data);

  If Count > 0 Then Begin
    If Count > FileSize(GroupFile) Then Begin
      Close (GroupFile);
      Exit;
    End;

    ioSeek (GroupFile, Count - 1);
    ioRead (GroupFile, TempGroup);

    If TBBSCore(Owner).User.Access(TempGroup.Access) Then Begin
      TBBSCore(Owner).User.ThisUser.LastFGroup := FilePos(GroupFile);
      FGroup := TempGroup;
      If ShowFile Then
        TBBSCore(Owner).Term.OutFile('fgroup' + strI2S(Count));
    End;

    Close (GroupFile);

    If FirstBase Then Begin
      TBBSCore(Owner).User.ThisUser.LastFBase := 1;
      ChangeArea('+');
    End;

    Exit;
  End;

  TBBSCore(Owner).Term.PausePos   := 1;
  TBBSCore(Owner).Term.AllowPause := True;

  Saved  := TBBSCore(Owner).User.ThisUser.LastFGroup;
  Listed := 0;

  While Not Eof(GroupFile) And Not TBBSCore(Owner).ShutDown Do Begin
    ioRead (GroupFile, TempGroup);

    If TempGroup.Hidden Then Continue;

    If TBBSCore(Owner).User.Access(TempGroup.Access) Then Begin
      FileAreas := 0;
      TBBSCore(Owner).User.ThisUser.LastFGroup := FilePos(GroupFile);

      If bbsConfig.FGroups Then Begin
        Assign  (FBaseFile, bbsConfig.PathData + mysFBasesDat);
        ioReset (FBaseFile, SizeOf(RecFileBase), fmReadWrite + fmDenyNone);
        ioRead  (FBaseFile, TempFBase);
        While Not Eof(FBaseFile) Do Begin
          ioRead (FBaseFile, TempFBase);
          If TBBSCore(Owner).User.Access(TempFBase.ListACS) Then Inc(FileAreas);
        End;
        Close (FBaseFile);
      End;

      Inc (Listed);

      If Listed = 1 Then
        TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(283));

      TBBSCore(Owner).Term.PromptInfo['A'] := strI2S(Listed);
      TBBSCore(Owner).Term.PromptInfo['B'] := TempGroup.Desc;
      TBBSCore(Owner).Term.PromptInfo['C'] := strI2S(FileAreas);
      TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(284));

      If (TBBSCore(Owner).Term.PausePos = TBBSCore(Owner).User.ThisUser.ScreenSize) and (TBBSCore(Owner).Term.AllowPause) Then
        Case TBBSCore(Owner).Term.MorePrompt of
          'N' : Break;
          'C' : TBBSCore(Owner).Term.AllowPause := False;
        End;
    End;
  End;

  If TBBSCore(Owner).ShutDown Then Exit;

  TBBSCore(Owner).User.ThisUser.LastFGroup := Saved;

  If Listed = 0 Then
    TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(285))
  Else Begin
    TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(286));

    Count := strS2I(TBBSCore(Owner).Term.GetStr(5, 5, -1, ''));

    If (Count > 0) and (Count <= Listed) Then Begin
      Listed := 0;

      ioReset (GroupFile, SizeOf(RecGroup), fmReadWrite + fmDenyNone);
      Repeat
        ioRead(GroupFile, TempGroup);
        If TempGroup.Hidden Then Continue;
        If TBBSCore(Owner).User.Access(TempGroup.Access) Then Inc(Listed);
        If Count = Listed Then Break;
      Until False;

      TBBSCore(Owner).User.ThisUser.LastFGroup := FilePos(GroupFile);
      FGroup := TempGroup;

      If ShowFile Then
        TBBSCore(Owner).Term.OutFile ('fgroup' + strI2S(TBBSCore(Owner).User.ThisUser.LastFGroup));

      TBBSCore(Owner).User.ThisUser.LastFBase := 1;
      ChangeArea('+');
    End;
  End;

  Close (GroupFile);
End;

Procedure TFileBase.ChangeArea (Data: String);
Var
  Count     : LongInt;
  Total     : LongInt;
  TempBase  : RecFileBase;
  Str       : String[5];
  FBaseFile : File;
  StrFooter : String;
Begin
  Assign (FBaseFile, bbsConfig.PathData + mysFBasesDat);

  If bbsConfig.FColumns = 1 Then
    StrFooter := TBBSCore(Owner).GetPrompt(287)
  Else
    StrFooter := TBBSCore(Owner).GetPrompt(288);

  If (Data = '+') or (Data = '-') Then Begin
    ioReset (FBaseFile, SizeOf(RecFileBase), fmReadWrite + fmDenyNone);

    Count := TBBSCore(Owner).User.ThisUser.LastFBase - 1;

    Repeat
      Case Data[1] of
        '+' : Inc(Count);
        '-' : Dec(Count);
      End;

      If Not ioSeek(FBaseFile, Count)    Then Break;
      If Not ioRead(FBaseFile, TempBase) Then Break;

      If TBBSCore(Owner).User.Access(TempBase.ListACS) Then Begin
        TBBSCore(Owner).User.ThisUser.LastFBase := FilePos(FBaseFile);
        FBase := TempBase;
        Close (FBaseFile);
        Exit;
      End;
    Until False;

    Close (FBaseFile);
    Exit;
  End;

  Count := strS2I(Data);

  If Count > 0 Then Begin
    ioReset (FBaseFile, SizeOf(RecFileBase), fmReadWrite + fmDenyNone);
    If Count <= FileSize(FBaseFile) Then Begin
      ioSeek (FBaseFile, Count - 1);
      ioRead (FBaseFile, TempBase);
      If TBBSCore(Owner).User.Access(TempBase.ListACS) Then Begin
        TBBSCore(Owner).User.ThisUser.LastFBase := FilePos(FBaseFile);
        FBase := TempBase;
      End;
    End;
    Close (FBaseFile);
    Exit;
  End;

  If Pos('NOLIST', strUpper(Data)) > 0 Then Begin
    ioReset (FBaseFile, SizeOf(RecFileBase), fmReadWrite + fmDenyNone);
    Total := FileSize(FBaseFile);
    Close (FBaseFile);
  End Else
    Total := ListAreas(bbsConfig.FCompress);

  If Total = 0 Then
    TBBSCore(Owner).Term.OutFullLn (TBBSCore(Owner).GetPrompt(289))
  Else Begin
    Repeat
      TBBSCore(Owner).Term.OutFull (StrFooter);

      Str := TBBSCore(Owner).Term.GetStr(5, 5, -2, '');

      If Str = '?' Then
        Total := ListAreas(bbsConfig.FCompress)
      Else
        Break;
    Until TBBSCore(Owner).ShutDown;

    Count := strS2I(Str);

    If (Count > 0) and (Count <= Total) Then Begin
      ioReset (FBaseFile, SizeOf(RecFileBase), fmReadWrite + fmDenyNone);
      If Not bbsConfig.FCompress Then Begin
        ioSeek (FBaseFile, Count - 1);
        ioRead (FBaseFile, TempBase);
        If Not TBBSCore(Owner).User.Access(TempBase.ListACS) Then Begin
          Close (FBaseFile);
          Exit;
        End;
      End Else Begin
        Total := 0;

        While Not Eof(FBaseFile) And (Count <> Total) Do Begin
          ioRead (FBaseFile, TempBase);
          If TBBSCore(Owner).User.Access(TempBase.ListACS) Then Inc(Total);
        End;

        If Count <> Total Then Begin
          Close (FBaseFile);
          Exit;
        End;
      End;

      TBBSCore(Owner).User.ThisUser.LastFBase := FilePos(FBaseFile);
      FBase := TempBase;

      Close (FBaseFile);
    End;
  End;
End;

End.
