{$I M_OPS.PAS}

Unit MCFG_USER;

Interface

Procedure UserEditor;

Implementation

Uses
  m_Types,
  m_Output,
  m_FileIO,
  m_MenuBox,
  m_MenuFOrm,
  m_Strings,
  m_DateTime,
  MCFG_Common,
  MCFG_Security;

Var
  UserFile : File;
  User     : recUser;

Procedure Edit_User (Num: LongInt);
Var
  Box      : TMenuBox;
  Form     : TMenuForm;
  PagePos  : Byte;
  Topic    : String;
  Image    : TConsoleImageRec;
  BoxImage : TConsoleImageRec;
  Changed  : Boolean;

  Procedure UpdatePage;
  Begin
    Console.PutScreenImage(BoxImage);

    VerticalLine (21, 3, 20);

    Console.WriteXY (57, 3, 112, 'User Information');
    Console.WriteXY (62, 4, 112, 'Preferences');
    Console.WriteXY (61, 5, 112, 'Statistics 1');
    Console.WriteXY (61, 6, 112, 'Statistics 2');
    Console.WriteXY (60, 7, 112, 'Account Flags');
    Console.WriteXY (60, 8, 112, 'Custom Fields');

    Console.WriteXY (59, 10, 120, 'CTRL-U/Upgrade');

    Console.WriteXY (65, 20, 112, 'Page ' + strI2S(PagePos) + '/6');

    Case PagePos of
      1 : Console.WriteXY (57, 3, 127, 'USER INFORMATION');
      2 : Console.WriteXY (62, 4, 127, 'PREFERENCES');
      3 : Console.WriteXY (61, 5, 127, 'STATISTICS 1');
      4 : Console.WriteXY (61, 6, 127, 'STATISTICS 2');
      5 : Console.WriteXY (60, 7, 127, 'ACCOUNT FLAGS');
      6 : Console.WriteXY (60, 8, 127, 'CUSTOM FIELDS');
    End;
  End;

Var
  Birthdate : String[8];
  FirstCall : String[8];
  LastCall  : String[8];
  Temp      : Integer;
  SecFile   : File;
  Sec       : RecSecurity;
  Ch        : Char;
Begin
  Topic   := '|03(|09User Editor|03) |01-|09> |15';
  Changed := False;
  PagePos := 1;

  ioReset (UserFile, SizeOf(recUser), fmReadWrite + fmDenyNone);
  ioSeek  (UserFile, Num - 1);
  ioRead  (UserFile, User);
  Close   (UserFile);

  Console.GetScreenImage(1, 1, 80, 3, Image);

  Console.WriteXY (1, 1, 8, strRep('', 80));
  Console.WriteXY (1, 2, 8, strRep('', 80));
  Console.WriteXY (1, 3, 8, strRep('', 80));

  Box  := TMenuBox.Create(Console);
  Form := TMenuForm.Create(Console);

  Box.Header       := ' ' + User.Handle + ' (ID ' + strI2S(User.UserID) + ') ';
  Form.LoExitChars := #21;
  Form.HiExitChars := #73#81;
//  Form.ExitOnFirst := True;
//  Form.ExitOnLast  := True;

  Box.Open (6, 2, 74, 21);

  Console.GetScreenImage (6, 2, 74, 21, BoxImage);

  Birthdate := DateJulian2Str(User.Birthdate, 1);
  FirstCall := DateDos2Str(User.FirstCall, 1);
  LastCall  := DateDos2Str(User.LastCall, 1);

  Repeat
    Case PagePos of
      1 : Begin
            UpdatePage;

            Form.Clear;

            Form.AddStr  ('H', ' Handle '    , 13,  3, 23,  3,  8, 30, 30, @User.Handle, Topic + 'User''s account handle');
            Form.AddStr  ('R', ' Real Name'  , 10,  4, 23,  4, 11, 30, 30, @User.RealName, Topic + 'User''s real name');
            Form.AddStr  ('A', ' Address '   , 12,  5, 23,  5,  9, 30, 30, @User.Street, Topic + 'User''s street address');
            Form.AddStr  ('C', ' City '      , 15,  6, 23,  6,  6, 25, 25, @User.CityState, Topic + 'User''s city and state');
            Form.AddStr  ('Z', ' Zip Code '  , 11,  7, 23,  7, 10, 10, 10, @User.ZipCode, Topic + 'User''s postal code');
            Form.AddDate ('B', ' Birthdate ' , 10,  8, 23,  8, 11, @Birthdate, Topic + 'User''s birthdate (MM/DD/YY)');
            Form.AddChar ('G', ' Gender '    , 13,  9, 23,  9,  8, 32, 254, @User.Gender, Topic + 'User''s gender. M/Male, F/Female');
            Form.AddStr  ('P', ' Home Phone ',  9, 10, 23, 10, 12, 15, 15, @User.HomePhone, Topic + 'User''s home phone number');
            Form.AddStr  ('O', ' Data Phone ',  9, 11, 23, 11, 12, 15, 15, @User.DataPhone, Topic + 'User''s data phone number');
            Form.AddStr  ('E', ' E-Mail ',     13, 12, 23, 12,  8, 40, 40, @User.Email, Topic + 'User''s email address');
            Form.AddStr  ('U', ' User Note ',  10, 13, 23, 13, 11, 40, 40, @User.UserInfo, Topic + 'User''s user note');
            Form.AddPass ('W', ' Password ',   11, 14, 23, 14, 10, 20, 20, @User.Password, Topic + 'User''s password');
            Form.AddStr  ('M', ' Start Menu ',  9, 15, 23, 15, 12, 20, 20, @User.StartMenu, Topic + 'User is sent to this menu after logging in');
            Form.AddByte ('S', ' Security ',   11, 16, 23, 16, 10,  3, 0, 255, @User.Security, Topic + 'User''s security level');
            Form.AddFlag ('1', ' Flags #1',    11, 17, 23, 17, 10, @User.AF1, Topic + 'User''s access flags: Set 1');
            Form.AddFlag ('2', ' Flags #2',    11, 18, 23, 18, 10, @User.AF2, Topic + 'User''s access flags: Set 2');
            Form.AddDate ('X', ' Expires',     12, 19, 23, 19,  9, @User.Expires, Topic + 'User''s account expiration date (00/00/00: Disabled)');
            Form.AddByte ('T', ' To ',         17, 20, 23, 20,  4, 3, 0, 255, @User.ExpiresTo, Topic + 'Security profile to give user after expiration');
          End;
      2 : Begin
            UpdatePage;

            Form.Clear;

            Form.AddStr  ('T', ' Theme '       , 14,  3, 23,  3,  7, 20,  20, @User.Theme, Topic + 'Filename of user''s theme');
            Form.AddTog  ('D', ' Date Format ' ,  8,  4, 23,  4, 13,  8,  1,  3, 'MM/DD/YY DD/MM/YY YY/MM/DD', @User.DateType, Topic + 'User''s date format');
            Form.AddByte ('S', ' Screen Size ' ,  8,  5, 23,  5, 13,  2,  0, 50, @User.ScreenSize, Topic + 'User''s terminal size in lines');
            Form.AddTog  ('F', ' File Listing ',  7,  6, 23,  6, 14,  8,  0,  1, 'Standard Full', @User.FSFileList, Topic + 'User''s file listing type');
            Form.AddBol  ('K', ' Hot Keys '    , 11,  7, 23,  7, 10,  3,  @User.HotKeys, Topic + 'User''s hotkey input status');
            Form.AddTog  ('N', ' Node Chat '   , 10,  8, 23,  8, 11,  8,  0,  1, 'Standard Full', @User.FSNodeChat, Topic + 'User''s node chat type');
            Form.AddBol  ('E', ' FS Editor '   , 10,  9, 23,  9, 11,  3,  @User.FSEditor, Topic + 'User''s full screen editor setting');
            Form.AddBol  ('Q', ' Quote Window ',  7, 10, 23, 10, 14,  3,  @User.QuoteWindow, Topic + 'User''s FS editor quote window status');
            Form.AddTog  ('M', ' Msg Reader '  ,  9, 11, 23, 11, 12,  8,  0,  1, 'Standard Full', @User.FSMsgReader, Topic + 'Full screen message reader status');
            Form.AddBol  ('X', ' Msg Index '   , 10, 12, 23, 12, 11,  3,  @User.FSMsgIndex, Topic + 'Start reading at message index');
            Form.AddBol  ('I', ' Mail Index '  ,  9, 13, 23, 13, 12,  3,  @User.FSMsgEIndex, Topic + 'Start reading email at message index');
            Form.AddBol  ('A', ' Auto-Sig '    , 11, 14, 23, 14, 10,  3,  @User.AutoSig, Topic + 'Use auto signature?');
            Form.AddStr  ('V', ' Archive Type ',  7, 15, 23, 15, 14,  4,  4, @User.Archive, Topic + 'User''s archive type extension');
            Form.AddStr  ('H', ' Chat Handle ' ,  8, 16, 23, 16, 13, 30, 30, @User.ChatName, Topic + 'User''s node chat handle');
//          Form.AddStr  ('U', ' Msg Initials ',  7, 17, 23, 17, 14,  3,  3, @User.MsgInitials, Topic + 'User''s quote initials');
          End;
      3 : Begin
            UpdatePage;

            Form.Clear;

            Console.WriteXY (11, 20, 112, 'Caller ID');
            Console.WriteXY (23, 20, 113, User.PeerName + ' (' + User.PeerIP + ')');

            Form.AddLong ('C', ' Calls '       , 14,  3, 23,  3,  7,  7, 0, 9999999, @User.Calls, Topic + 'Total number of calls to the BBS');
            Form.AddWord ('L', ' Calls Today ' ,  8,  4, 23,  4, 13,  5, 0, 65000, @User.CallsToday, Topic + 'Total number of calls today');
            Form.AddLong ('D', ' Downloads '   , 10,  5, 23,  5, 11,  7, 0, 9999999, @User.Downloads, Topic + 'Total number of downloads');
            Form.AddWord ('T', ' DLs Today '   , 10,  6, 23,  6, 11,  5, 0, 65000, @User.DLsToday, Topic + 'Total downloads today');
            Form.AddLong ('W', ' DL KB '       , 14,  7, 23,  7,  7, 10, 0, 2000000000, @User.DownloadKB, Topic + 'Total downloads in kilobytes');
            Form.AddLong ('K', ' DL KB Today ' ,  8,  8, 23,  8, 13, 10, 0, 2000000000, @User.DLkbToday, Topic + 'Downloads in kilobytes today');
            Form.AddDate ('F', ' First Call '  ,  9,  9, 23,  9, 12, @FirstCall, Topic + 'Date of first call (MM/DD/YY)');
            Form.AddDate ('A', ' Last Call '   , 10, 10, 23, 10, 11, @LastCall, Topic + 'Date of last call (MM/DD/YY)');
            Form.AddLong ('M', ' Msg Posts '   , 10, 11, 23, 11, 11, 10, 0, 2000000000, @User.MsgPosts, Topic + 'Total number of message posts');
            Form.AddWord ('E', ' E-Mails '     , 12, 12, 23, 12,  9,  5, 0, 65000, @User.Emails, Topic + 'Number of e-mails sent');
            Form.AddLong ('U', ' Uploads '     , 12, 13, 23, 13,  9, 10, 0, 2000000000, @User.Uploads, Topic + 'Total number of uploads');
            Form.AddLong ('B', ' Upload KB '   , 10, 14, 23, 14, 11, 10, 0, 2000000000, @User.UploadKB, Topic + 'Total uploads in kilobytes');
            Form.AddWord ('I', ' Time Bank '   , 10, 15, 23, 15, 11,  5, 0, 65000, @User.TimeBank, Topic + 'Total minutes in time bank');
            Form.AddDate ('P', ' Last PW Date ',  7, 16, 23, 16, 14, @User.LastPWChange, Topic + 'Date of last password change');
            Form.AddByte ('Y', ' Yes Votes '   , 10, 17, 23, 17, 11,  3, 0, 255, @User.YesVotes, Topic + 'Total number of NUV Yes votes');
            Form.AddByte ('N', ' No Votes '    , 11, 18, 23, 18, 10,  3, 0, 255, @User.NoVotes, Topic + 'Total number of NUV No votes');
            Form.AddByte ('V', ' Abs Votes '   , 10, 19, 23, 19, 11,  3, 0, 255, @User.AbsVotes, Topic + 'Total abstained NUV votes');
          End;
      4 : Begin
            UpdatePage;

            Form.Clear;

            Form.AddLong ('O', ' Doors Ran '   , 10, 3, 23, 3, 11, 10, 0, 2000000000, @User.DoorsRan, Topic + 'Total number of doors ran');
            Form.AddWord ('T', ' Time Left '   , 10, 4, 23, 4, 11, 10, 0, 1440, @User.TimeLeft, Topic + 'Total number of minutes left for today');
          End;
      5 : Begin
            UpdatePage;

            Form.Clear;

            Form.AddBits ('D', ' Deleted '     , 12, 3, 23, 3,  9, UserDeleted,    @User.Flags, Topic + 'Is this account marked as deleted?');
            Form.AddBits ('L', ' Locked Out '  ,  9, 4, 23, 4, 12, UserLockedOut,  @User.Flags, Topic + 'Is this account locked out of the system?');
            Form.AddBits ('N', ' No Delete '   , 10, 5, 23, 5, 11, UserNoDelete,   @User.Flags, Topic + 'Prevent this account from getting deleted');
            Form.AddBits ('P', ' No PW Change ',  7, 6, 23, 6, 14, UserNoPWChange, @User.Flags, Topic + 'User is exempt from forced password changes');
            Form.AddBits ('C', ' No Call Info ',  7, 7, 23, 7, 14, UserNoLastCall, @User.Flags, Topic + 'User is not added to last caller data');
            Form.AddBits ('I', ' No Inactive ',   8, 8, 23, 8, 13, UserNoInactive, @User.Flags, Topic + 'User is not checked for inactivity timeout');
          End;
      6 : Begin
            UpdatePage;

            Form.Clear;

            For Temp := 1 to 9 Do
              Form.AddStr ('1', bbsConfig.OptionalField[Temp].Desc, 8, 2 + Temp, 23, 2 + Temp, 13, 33, 60, @User.Optional[Temp], Topic + 'User optional field #' + strI2S(Temp));

            Form.AddStr ('1', bbsConfig.OptionalField[10].Desc, 8, 12, 23, 12, 13, 33, 60, @User.Optional[10], Topic + 'User optional field #10');
          End;
    End;

    Case Form.Execute of
      #21 : Begin
              Temp := SecurityEditor(False);

              If Temp <> -1 Then Begin
                Changed := True;

                Assign  (SecFile, bbsConfig.PathData + 'security.dat');
                ioReset (SecFile, SizeOf(recSecurity), fmReadWrite + fmDenyNone);
                ioSeek  (SecFile, Temp - 1);
                ioRead  (SecFile, Sec);
                Close   (SecFile);

                User.Security  := Temp;
                User.StartMenu := Sec.StartMenu;
                User.TimeLeft  := Sec.Time;
                User.Expires   := '00/00/00';
                User.ExpiresTo := Sec.ExpiresTo;

                If Sec.Expires > 0 Then Begin
                  User.Expires   := DateJulian2Str(CurDateJulian + Sec.Expires, 1);
                  User.ExpiresTo := Sec.ExpiresTo;
                End;

                For Ch := 'A' to 'Z' Do
                  If Ord(Ch) - 64 in Sec.AF1 Then
                    User.AF1 := User.AF1 + [Ord(Ch) - 64]
                  Else
                  If Sec.Hard Then
                    User.AF1 := User.AF1 - [Ord(Ch) - 64];

                For Ch := 'A' to 'Z' Do
                  If Ord(Ch) - 64 in Sec.AF2 Then
                    User.AF2 := User.AF2 + [Ord(Ch) - 64]
                  Else
                  If Sec.Hard Then
                    User.AF2 := User.AF2 - [Ord(Ch) - 64];
              End;
            End;
      #27 : Begin
              Changed := Changed or Form.Changed;
              Break;
            End;
//      #72,
      #73 : If PagePos > 1 Then Dec(PagePos);
//      #80,
      #81 : If PagePos < 6 Then Inc(PagePos);
    End;

    Changed := Changed or Form.Changed;
  Until False;

  User.Birthdate := DateStr2Julian(Birthdate);
  User.FirstCall := DateStr2Dos(FirstCall);
  User.LastCall  := DateStr2Dos(LastCall);

  Box.Close;
  Box.Free;
  Form.Free;

  Console.PutScreenImage(Image);

  If Changed Then
    If ShowMsgBox(1, 'Save changes?') Then Begin
      Assign  (UserFile, bbsConfig.PathData + 'users.dat');
//      ioReset (UserFile, SizeOf(recUser), fmReadWrite + fmDenyWrite);
      Reset   (UserFile, SizeOf(recUser));
      ioSeek  (UserFile, Num - 1);
      ioWrite (UserFile, User);
      Close   (UserFile);
    End;
End;

Function User_List (Var Picked, TopPage: LongInt) : LongInt;
Var
  Box  : TMenuBox;
  List : TMenuList;
  OK   : Boolean;
  Res  : LongInt;

  Procedure MakeList;
  Begin
    OK := True;

    List.Clear;

    Assign  (UserFile, bbsConfig.PathData + 'users.dat');
    If Not ioReset (UserFile, SizeOf(recUser), fmReadWrite + fmDenyNone) Then
      If ShowMsgBox(1, 'User database not found.  Create?') Then
        If Not ioReWrite (UserFile, SizeOf(RecUser), fmReadWrite + fmDenyNone) Then Begin
          ShowMsgBox(0, 'Unable to create user database');
          Exit;
        End;

    While Not Eof(UserFile) Do Begin
      {$IFNDEF FPC}
      If MaxAvail < 8192 Then Begin
        If ShowMsgBox (1, 'Out of memory: Load first user?') Then Res := 1;
        OK := False;
        Break;
      End;
      {$ENDIF}

      ioRead (UserFile, User);

      If User.Flags AND UserDeleted <> 0 Then
        List.Add (strPadR(User.Handle, 37, ' ') + 'DELETED', 0)
      Else
        List.Add (strPadR(User.Handle, 32, ' ') +
                  strPadL(strI2S(User.Security), 5, ' ') +
                  strPadL(strI2S(User.UserID), 10, ' '), 0);
    End;

    Close(UserFile);
  End;

Begin
  User_List := 0;
  Res       := 0;

  Box  := TMenuBox.Create(Console);
  List := TMenuList.Create(Console);

  Box.Header    := ' User Editor ';
  List.NoWindow := True;

  Box.Open (15, 6, 65, 21);

  Console.WriteXY (17, 7, 112, 'User Name                       Level    UserID');
  Console.WriteXY (16, 8, 112, strRep('', 49));

{ StatusBot ('(ENTER) Select   (F2) Search   (F3) Again   (ESC) Quit');}

  MakeList;

  If OK Then Begin
    List.Picked := Picked;
    List.TopPage := TopPage;

    List.Open (15, 8, 65, 21);
    List.Close;
  End;

  Box.Close;

  If List.ExitCode <> #27 Then
    If OK Then
      If List.ListMax <> 0 Then User_List := List.Picked
    Else
      User_List := Res;

  List.Free;
  Box.Free;
End;

Procedure UserEditor;
Var
  Picked  : LongInt;
  TopPage : LongInt;
Begin
  Picked  := 1;
  TopPage := 1;

  Assign (UserFile, bbsConfig.PathData + 'users.dat');

  If Not ioReset (UserFile, SizeOf(recUser), fmReadWrite + fmDenyNone) Then Begin
    Picked := 0;

    ioReWrite (UserFile, SizeOf(recUser), fmReadWrite + fmDenyAll);
    Close     (UserFile);
    Assign    (UserFile, bbsConfig.PathData + 'users.ptr');
    ioReWrite (UserFile, 4, fmReadWrite + fmDenyAll);
    ioWrite   (UserFile, Picked);
    Close     (UserFile);
  End;

  Repeat
    Picked := User_List(Picked, TopPage);

    If Picked = 0 Then Break;

    Edit_User(Picked);
  Until False;
End;

End.

