{$I M_OPS.PAS}

Unit MCFG_SYSCONFIG;

Interface

Function  NetworkAddress (Edit: Boolean) : Byte;
Procedure NewUserSettings1;
Procedure NewUserSettings2;
Procedure GeneralSettings1;
Procedure SystemPaths;
Procedure InternetOptions;
Procedure MessageSettings;
Procedure FileBaseSettings;

Implementation

Uses
  m_MenuBox,
  m_MenuForm,
  m_Strings,
  MCFG_Common;

Procedure EditAddress (Num: Byte);
Var
  Box   : TMenuBox;
  Form  : TMenuForm;
  Topic : String;
Begin
  Topic := '';
  Box   := TMenuBox.Create(Console);
  Form  := TMenuForm.Create(Console);

  Box.Open (21, 5, 60, 13);

  VerticalLine (36, 7, 11);

  Form.AddWord ('Z', ' Zone '       , 30,  7, 38,  7,  6, 5, 0, 65535, @bbsConfig.NetAddress[Num].Zone, Topic + 'Network Zone number');
  Form.AddWord ('N', ' Net '        , 31,  8, 38,  8,  5, 5, 0, 65535, @bbsConfig.NetAddress[Num].Net, Topic + 'Network Net number');
  Form.AddWord ('O', ' Node '       , 30,  9, 38,  9,  6, 5, 0, 65535, @bbsConfig.NetAddress[Num].Node, Topic + 'Network Node number');
  Form.AddWord ('P', ' Point   '    , 29, 10, 38, 10,  7, 5, 0, 65535, @bbsConfig.NetAddress[Num].Point, Topic + 'Network Pointer number');
  Form.AddStr  ('D', ' Description ', 23, 11, 38, 11, 13, 20, 20, @bbsConfig.NetDesc[Num], Topic + 'Network description');

  Form.Execute;

  Box.Close;

  Form.Free;
  Box.Free;
End;

Function NetworkAddress (Edit: Boolean) : Byte;
Var
  Box  : TMenuBox;
  List : TMenuList;

  Procedure Make_List;
  Var
    A : Byte;
  Begin
    List.Clear;

    For A := 1 to 20 Do
      List.Add(strPadL(strAddr(bbsConfig.NetAddress[A]), 23, ' ') + ' ' + strPadL(bbsConfig.NetDesc[A], 20, ' '), 0);
  End;

Begin
  Result := 0;

  Box  := TMenuBox.Create(Console);
  List := TMenuList.Create(Console);

  List.NoWindow := True;

  Box.Open (17, 6, 64, 21);

  Console.WriteXY (27, 7, 112, 'Network Address          Description');
  Console.WriteXY (19, 8, 112, strRep('', 44));

  Repeat
    Make_List;

    List.Open (17, 8, 64, 21);

    Case List.ExitCode of
      #13 : If Edit Then
              EditAddress(List.Picked)
            Else Begin
              Result := List.Picked;
              Break;
            End;
      #27 : Break;
    End;
  Until False;

  List.Close;
  Box.Close;

  List.Free;
  Box.Free;
End;

Procedure MessageSettings;
Var
  Box   : TMenuBox;
  Form  : TMenuForm;
  Topic : String;
Begin
  Topic := '|03(|09Message Settings|03) |01-|09> |15';
  Box   := TMenuBox.Create(Console);
  Form  := TMenuForm.Create(Console);

  Box.Header := ' Message Settings ';

  Box.Open (3, 5, 77, 21);

  VerticalLine (27, 7, 20);
  VerticalLine (66, 7, 14);

  Form.AddBol  ('A', ' Area Compression '    ,  9,  7, 29,  7, 18,  3, @bbsConfig.MCompress, Topic + 'Compress area numbers in listing');
  Form.AddBol  ('B', ' Bases in Group List ' ,  6,  8, 29,  8, 21,  3, @bbsConfig.MGroups, Topic + 'Show # of bases in group list');
  Form.AddByte ('L', ' Area List Columns '   ,  8,  9, 29,  9, 19,  1, 1, 2, @bbsConfig.MColumns, Topic + 'Area list columns');
  Form.AddBol  ('R', ' Redisplay Msg Header ',  5, 10, 29, 10, 22,  3, @bbsConfig.DispMsgHdr, Topic + 'Redisplay msg header after pause?');
  Form.AddByte ('M', ' Max Autosig Lines '   ,  8, 11, 29, 11, 19,  1, 255, 3, @bbsConfig.MaxAutoSig, Topic + 'Max # of auto signature lines');
  Form.AddStr  ('C', ' Crosspost ACS '       , 12, 12, 29, 12, 15, 20, 30, @bbsConfig.AcsCrossPost, Topic + 'Access level to crosspost messages');
  Form.AddStr  ('F', ' File Attach ACS '     , 10, 13, 29, 13, 17, 20, 30, @bbsConfig.AcsFileAttach, Topic + 'Access level to attach files messages');
  Form.AddStr  ('N', ' Node Lookup ACS '     , 10, 14, 29, 14, 17, 20, 30, @bbsConfig.AcsNodeLookup, Topic + 'Access level to lookup echomail nodes');
  Form.AddBol  ('E', ' Netmail Crash '       , 12, 15, 29, 15, 15,  3, @bbsConfig.nmCrash, Topic + 'Netmail Crash flag');
  Form.AddBol  ('T', ' Netmail Hold '        , 13, 16, 29, 16, 14,  3, @bbsConfig.nmHold, Topic + 'Netmail Hold flag');
  Form.AddBol  ('I', ' Netmail Kill '        , 13, 17, 29, 17, 14,  3, @bbsConfig.nmKill, Topic + 'Netmail Kill flag');
  Form.AddBol  ('U', ' Use External Editor ' ,  6, 18, 29, 18, 21,  3, @bbsConfig.UseFSEditor, Topic + 'Use external message editor');
  Form.AddStr  ('S', ' FSE Command '         , 14, 19, 29, 19, 13, 40, 60, @bbsConfig.FSCommand, Topic + 'Command line to run external editor');
  Form.AddStr  ('O', ' Origin Line '         , 14, 20, 29, 20, 13, 40, 50, @bbsConfig.OriginLine, Topic + 'Default origin line');
  Form.AddAttr ('Q', ' Quote Color '         , 53,  7, 68,  7, 13, @bbsConfig.ColorQuote, Topic + 'Default quote text color');
  Form.AddAttr ('X', ' Text Color '          , 54,  8, 68,  8, 12, @bbsConfig.ColorText, Topic + 'Default text color');
  Form.AddAttr ('1', ' Tear Color '          , 54,  9, 68,  9, 12, @bbsConfig.ColorTear, Topic + 'Default tear line color');
  Form.AddAttr ('G', ' Origin Color '        , 52, 10, 68, 10, 14, @bbsConfig.ColorOrigin, Topic + 'Default origin line color');
  Form.AddAttr ('K', ' Kludge Color '        , 52, 11, 68, 11, 14, @bbsConfig.ColorKludge, Topic + 'Default kludge line color');
  Form.AddStr  ('4', ' Offline Mail '        , 52, 12, 68, 12, 14, 8, 8, @bbsConfig.MailPacket, Topic + 'Offline mail unique filename');
  Form.AddStr  ('5', ' Default Archive '     , 49, 13, 68, 13, 17, 4, 4, @bbsConfig.DefArchive, Topic + 'Default archive extention');
  Form.AddWord ('2', ' Max Msgs/Base '       , 51, 14, 68, 14, 15, 5, 1, 65535, @bbsConfig.MailMaxBase, Topic + 'Offline mail: Max msgs per base');
  Form.AddWord ('3', ' Max Msgs/Packet '     , 49, 15, 68, 15, 17, 5, 1, 65535, @bbsConfig.MailMaxPacket, Topic + 'Offline mail: Msg msgs per packet');
  Form.Execute;

  Box.Close;
  Form.Free;
  Box.Free;
End;

Procedure FileBaseSettings;
Var
  Box   : TMenuBox;
  Form  : TMenuForm;
  Topic : String;
Begin
  Topic := '|03(|09File Base Settings|03) |01-|09> |15';
  Box   := TMenuBox.Create(Console);
  Form  := TMenuForm.Create(Console);

  Box.Header := ' File Base Settings ';

  Box.Open (7, 5, 75, 21);

  VerticalLine (32, 7, 20);
  VerticalLine (63, 7, 11);

  Form.AddBol  ('C', ' Compress Area Numbers ' ,  9,  7, 34,  7, 23,  3, @bbsConfig.FCompress, Topic + 'Compress area numbers in listing');
  Form.AddBol  ('B', ' Show Bases in Groups '  , 10,  8, 34,  8, 22,  3, @bbsConfig.FGroups, Topic + 'Show # of bases in group list');
  Form.AddByte ('L', ' File Area List Columns ',  8,  9, 34,  9, 24,  1, 1, 2, @bbsConfig.FColumns, Topic + 'Area list columns');
  Form.AddBol  ('R', ' Redisplay File Header ' ,  9, 10, 34, 10, 23,  3, @bbsConfig.FReDisplay, Topic + 'Redisplay filelist header after pause?');
  Form.AddBol  ('I', ' Import FILE_ID.DIZ '    , 12, 11, 34, 11, 20,  3, @bbsConfig.FImportDIZ, Topic + 'Attempt to import FILE_ID.DIZ');
  Form.AddByte ('M', ' Maximum Desc Lines '    , 12, 12, 34, 12, 20,  2, 1, 99, @bbsConfig.FMaxDescSize, Topic + 'Max number of file description lines');
  Form.AddStr  ('A', ' Auto-Validate ACS '     , 13, 13, 34, 13, 19, 30, 30, @bbsConfig.AcsAutoValid, Topic + 'Access level to auto validate uploads');
  Form.AddStr  ('S', ' See Unvalid ACS '       , 15, 14, 34, 14, 17, 30, 30, @bbsConfig.AcsSeeUnvalid, Topic + 'Access to see unvalid files in listing');
  Form.AddStr  ('D', ' Download Unvalid ACS '  , 10, 15, 34, 15, 22, 30, 30, @bbsConfig.AcsDLUnvalid, Topic + 'Access to download unvalid files');
  Form.AddStr  ('E', ' See Failed ACS '        , 16, 16, 34, 16, 16, 30, 30, @bbsConfig.AcsSeeFailed, Topic + 'Access to see failed files in listing');
  Form.AddStr  ('O', ' Download Failed ACS '   , 11, 17, 34, 17, 21, 30, 30, @bbsConfig.AcsDLFailed, Topic + 'Access to download failed files');
  Form.AddTog  ('Y', ' Upload Scanner Type '   , 11, 18, 34, 18, 21,  8,  0, 2, 'None Internal External', @bbsConfig.FULScanner, Topic + 'Upload file scanner type');
  Form.AddStr  ('N', ' Scanner Command Line '  , 10, 19, 34, 19, 22, 40, 80, @bbsConfig.FULCmdLine, Topic + 'Command line to execute external scanner');
  Form.AddByte ('V', ' Pass Errorlevel '       , 15, 20, 34, 20, 17, 3, 0, 255, @bbsConfig.FULPassed, Topic + 'Errorlevel to signal a passed upload scan');
  Form.AddWord ('F', ' Default Upload Base '   , 42,  7, 65,  7, 21, 5, 0, 65535, @bbsConfig.FDefUpload, Topic + 'Default upload base number (0/Disabled)');
  Form.AddTog  ('U', ' Upload Dupe Scan '      , 45,  8, 65,  8, 18, 7, 0, 2, 'None Current All', @bbsConfig.FDupeScan, Topic + 'Method of scanning for duplicate uploads');
  Form.AddLong ('K', ' Minimum Upload KB '     , 44,  9, 65,  9, 19, 9, 0, 999999999, @bbsConfig.MinUploadKB, Topic + 'Minimum space in kilobytes to allow uploads');
  Form.AddLong ('P', ' Minimum CDCOPY KB '     , 44, 10, 65, 10, 19, 9, 0, 999999999, @bbsConfig.FMinCDCopy, Topic + 'Minimum space in kilobytes to allow "Copy-To-Temp"');
  Form.AddByte ('Z', ' Maximum Batch Size '    , 43, 11, 65, 11, 20, 3, 1, 255, @bbsConfig.MaxBatchQueue, Topic + 'Maximum number of files to store in batch queue');

  Form.Execute;

  Box.Close;
  Form.Free;
  Box.Free;
End;

Procedure NewUserSettings2;
Var
  Box   : TMenuBox;
  Form  : TMenuForm;
  Topic : String;
  Count : Byte;
Begin
  Topic := '|03(|09New User Settings 2|03) |01-|09> |15';
  Box   := TMenuBox.Create(Console);
  Form  := TMenuForm.Create(Console);

  Box.Header := ' Optional User Fields ';

  For Count := 1 to 10 Do Begin
    Form.AddBol  ('1', 'Ask' ,   8, 6 + Count, 12, 6 + Count, 3, 3,      @BbsConfig.OptionalField[Count].Ask, Topic + 'Ask optional field #' + strI2S(Count));
    Form.AddStr  ('2', 'Desc',  18, 6 + Count, 23, 6 + Count, 4, 13, 13, @BbsConfig.OptionalField[Count].Desc, Topic + 'Description of field (for user editor)');
    Form.AddTog  ('3', 'Type',  41, 6 + Count, 46, 6 + Count, 4, 8, 0, 9, 'Standard Upper Proper Phone Date Password Lower Elite Number Yes/No', @BbsConfig.OptionalField[Count].iType, Topic + 'Field input type');
    Form.AddByte ('4', 'Field', 57, 6 + Count, 63, 6 + Count, 5, 2, 1, 60, @BbsConfig.OptionalField[Count].iField, Topic + 'Size of input field');
    Form.AddByte ('5', 'Max'  , 68, 6 + Count, 72, 6 + Count, 3, 2, 1, 60, @BbsConfig.OptionalField[Count].iMax, Topic + 'Maximum size of input');
  End;

  Box.Open (6, 5, 75, 18);

  Form.Execute;

  Box.Close;
  Form.Free;
  Box.Free;
End;

Procedure NewUserSettings1;
Var
  Box   : TMenuBox;
  Form  : TMenuForm;
  Topic : String;
Begin
  Topic := '|03(|09New User Settings 1|03) |01-|09> |15';
  Box   := TMenuBox.Create(Console);
  Form  := TMenuForm.Create(Console);

  Box.Header := ' New User Settings 1 ';

  Form.AddBol  ('A', ' Allow New Users'     , 10,  6, 29,  6, 17,  3,          @bbsConfig.AllowNewUsers, Topic + 'Allow new user accounts?');
  Form.AddStr  ('W', ' New User Password '  ,  8,  7, 29,  7, 19, 15, 20,      @bbsConfig.NewUserPW, Topic + 'Password required to create an account');
  Form.AddByte ('S', ' Security Level '     , 11,  8, 29,  8, 16,  3,  1, 255, @bbsConfig.NewUserSec, Topic + 'New user''s security level');
  Form.AddTog  ('F', ' Date Format '        , 14,  9, 29,  9, 13,  8,  0, 3, 'Ask MM/DD/YY DD/MM/YY YY/MM/DD', @bbsConfig.NewDateFormat, Topic + 'Date format for new accounts');
  Form.AddBol  ('U', ' Use USA Phone '      , 12, 10, 29, 10, 15,  3,          @bbsConfig.UsaPhones, Topic + 'Use ###-###-#### format phone numbers');
  Form.AddWord ('M', ' First Message Group ',  6, 11, 29, 11, 21,  5,  0, 65535, @bbsConfig.FirstMsgGroup, Topic + 'Message group # new users are placed into');
  Form.AddWord ('G', ' First File Group '   ,  9, 12, 29, 12, 18,  5,  0, 65535, @bbsConfig.FirstFileGroup, Topic + 'File group # new users are placed into');

  Form.AddTog  ('R', ' Message Reader Type ',  6, 14, 29, 14, 21,  8,  0, 2, 'Standard Full Ask', @bbsConfig.MsgReaderType, Topic + 'New users message reader type');
  Form.AddTog  ('X', ' Start At Msg Index ' ,  7, 15, 29, 15, 20,  3,  0, 2, 'No Yes Ask', @bbsConfig.MsgAtIndex, Topic + 'Start reading at message index listing');
  Form.AddTog  ('E', ' Email At Msg Index ' ,  7, 16, 29, 16, 20,  3,  0, 2, 'No Yes Ask', @bbsConfig.EmailAtIndex, Topic + 'Start Email at message index listing');
  Form.AddTog  ('L', ' FS Quote Window '    , 10, 17, 29, 17, 17,  3,  0, 2, 'No Yes Ask', @bbsConfig.QuoteWindow, Topic + 'Use FS editor quote window');
  Form.AddTog  ('I', ' File List Type '     , 11, 18, 29, 18, 16,  8,  0, 2, 'Standard Full Ask', @bbsConfig.FileListType, Topic + 'File listing style');
  Form.AddTog  ('H', ' Hot Keys '           , 17, 19, 29, 19, 10,  3,  0, 2, 'No Yes Ask', @bbsConfig.HotKeys, Topic + 'Hot key type');
  Form.AddTog  ('T', ' Node Chat Type '     , 11, 20, 29, 20, 16,  8,  0, 2, 'Standard Full Ask', @bbsConfig.ChatType, Topic + 'Node chat type');

  Form.AddBol  ('B', ' Ask Alias '          , 58,  6, 71,  6, 11,  3, @bbsConfig.AskAlias, Topic + 'Ask for Aliases');
  Form.AddBol  ('C', ' Ask Real Name '      , 54,  7, 71,  7, 15,  3, @bbsConfig.AskRealName, Topic + 'Ask for real name');
  Form.AddBol  ('D', ' Ask Street '         , 57,  8, 71,  8, 12,  3, @bbsConfig.AskStreet, Topic + 'Ask street address');
  Form.AddBol  ('J', ' Ask City/State '     , 53,  9, 71,  9, 16,  3, @bbsConfig.AskCityState, Topic + 'Ask City and State');
  Form.AddBol  ('K', ' Ask Zip Code '       , 55, 10, 71, 10, 14,  3, @bbsConfig.AskZipCode, Topic + 'Ask Zip Code');
  Form.AddBol  ('N', ' Ask Home Phone '     , 53, 11, 71, 11, 16,  3, @bbsConfig.AskHomePhone, Topic + 'Ask for home phone number');
  Form.AddBol  ('O', ' Ask Data Phone '     , 53, 12, 71, 12, 16,  3, @bbsConfig.AskDataPhone, Topic + 'Ask for data phone number');
  Form.AddBol  ('P', ' Ask Birthdate '      , 54, 13, 71, 13, 15,  3, @bbsConfig.AskBirthdate, Topic + 'Ask for birthdate');
  Form.AddBol  ('Q', ' Ask Gender '         , 57, 14, 71, 14, 12,  3, @bbsConfig.AskGender, Topic + 'Ask gender');
  Form.AddBol  ('V', ' Ask Email '          , 58, 15, 71, 15, 11,  3, @bbsConfig.AskEmail, Topic + 'Ask for Email address');
  Form.AddBol  ('Y', ' Ask Screen Size '    , 52, 16, 71, 16, 17,  3, @bbsConfig.AskScreenSize, Topic + 'Ask for screen size');
  Form.AddTog  ('Z', ' FS Editor '          , 58, 17, 71, 17, 11,  3, 0, 2, 'No Yes Ask', @bbsConfig.FSEditor, Topic + 'Full screen editor type');
  Form.AddBol  ('1', ' Ask Theme '          , 58, 18, 71, 18, 11,  3, @bbsConfig.AskTheme, Topic + 'Ask for theme or use default theme?');
  Form.AddBol  ('2', ' Ask Chat Handle '    , 52, 19, 71, 19, 17,  3, @bbsConfig.AskChatHandle, Topic + 'Ask for chat room handle?');
//Form.AddBol  ('3', ' Ask Msg Initial '    , 52, 20, 71, 20, 17,  3, @bbsConfig.AskInitials, Topic + 'Ask message quote initials?');

  Box.Open (5, 5, 75, 21);

  VerticalLine (27,  6, 12);
  VerticalLine (27, 14, 20);
  VerticalLine (69,  6, 20);

  Form.Execute;

  If Not bbsConfig.AskAlias And Not bbsConfig.AskRealName Then bbsConfig.AskAlias := True;

  Box.Close;
  Form.Free;
  Box.Free;
End;

Procedure GeneralSettings1;
Var
  Box   : TMenuBox;
  Form  : TMenuForm;
  Topic : String;
Begin
  Topic := '|03(|09General Settings 1|03) |01-|09> |15';
  Box   := TMenuBox.Create(Console);
  Form  := TMenuForm.Create(Console);

  Box.Header := ' General Settings 1 ';

  Box.Open     (3, 5, 76, 21);
  VerticalLine (17,  6, 7);
  VerticalLine (58,  6, 7);
  VerticalLine (26,  9, 20);
  VerticalLine (70,  9, 15);

  Form.AddStr  ('B', ' BBS Name '           ,  7,  6, 19,  6, 10, 22, 30, @bbsConfig.BBSName,      Topic + 'Name of the BBS system');
  Form.AddStr  ('Y', ' Sysop Name '         ,  5,  7, 19,  7, 12, 22, 30, @bbsConfig.SysopName,    Topic + 'Sysop name');
  Form.AddStr  ('U', ' Def Start Menu '     , 10,  9, 28,  9, 16, 20, 20, @bbsConfig.DefStartMenu, Topic + 'Default start menu name');
  Form.AddStr  ('T', ' Def Theme Name '     , 10, 10, 28, 10, 16, 20, 20, @bbsConfig.DefThemeName, Topic + 'Default theme filename');
  Form.AddTog  ('O', ' Def Term Mode '      , 11, 11, 28, 11, 15, 11,  0, 4, 'Detect Detect/Ask Ask ANSI ASCII', @bbsConfig.DefTermMode, Topic + 'How should Mystic detect a user''s graphics');
  Form.AddByte ('S', ' Def Screen Size '    ,  9, 12, 28, 12, 17,  3, 1, 25, @bbsConfig.DefScreenSize, Topic + 'Default screen size');
  Form.AddStr  ('A', ' Sysop Access ACS '   ,  8, 13, 28, 13, 18, 20, 30, @bbsConfig.AcsSysop, Topic + 'Access level for Sysop functions');
  Form.AddStr  ('I', ' Invisible Login ACS ',  5, 14, 28, 14, 21, 20, 30, @bbsConfig.AcsInvLogin, Topic + 'Access level for invislble logins');
  Form.AddStr  ('E', ' See Invisible ACS '  ,  7, 15, 28, 15, 19, 20, 30, @bbsConfig.AcsSeeInvis, Topic + 'Access level to see invisible users');
  Form.AddStr  ('M', ' Multiple Login ACS ' ,  6, 16, 28, 16, 20, 20, 30, @bbsConfig.AcsMultiLogin, Topic + 'Access level for multiple node logins');
  Form.AddBol  ('X', ' Use Matrix Login '   ,  8, 17, 28, 17, 18,  3, @bbsConfig.UseMatrix, Topic + 'Enable matrix style login menu');
  Form.AddStr  ('2', ' Matrix Menu Name '   ,  8, 18, 28, 18, 18, 20, 20, @bbsConfig.MatrixMenu, Topic + 'Matrix menu file name');
  Form.AddStr  ('3', ' Matrix Access '      , 11, 19, 28, 19, 15, 30, 30, @bbsConfig.MatrixAccess, Topic + 'Access required to login from matrix');
  Form.AddStr  ('P', ' System Password '    , 41,  6, 60,  6, 17, 15, 20, @bbsConfig.SystemPW, Topic + 'Password required to access the BBS');
  Form.AddStr  ('W', ' SysOp Password '     , 42,  7, 60,  7, 16, 15, 20, @bbsConfig.SysOpPW, Topic + 'Password required for SysOp login');
  Form.AddWord ('N', ' Inactivity Timeout ' , 50,  9, 72,  9, 20,  3,  0, 999, @bbsConfig.Inactivity, Topic + 'Inactivity timeout in seconds (0/Disabled)');
  Form.AddBol  ('R', ' Snoop StatusBar '    , 53, 10, 72, 10, 17,  3,  @bbsConfig.TaskBar, Topic + 'Show statusbar with user information when snooping');
  Form.AddByte ('L', ' Login Attempts '     , 54, 11, 72, 11, 16,  3,  1, 255, @bbsConfig.LoginAttempts, Topic + 'Maximum number of login attempts before disconnect');
  Form.AddByte ('G', ' Login Time Limit '   , 52, 12, 72, 12, 18,  3,  0, 255, @bbsConfig.LoginTime, Topic + 'Number of minutes allowed for login');
  Form.AddWord ('C', ' Password Change '    , 53, 13, 72, 13, 17,  3,  0, 999, @bbsConfig.PWChange, Topic + 'Days until forced password change (0/Disabled)');
  Form.AddByte ('1', ' Password Attempts '  , 51, 14, 72, 14, 19,  3,  1, 255, @bbsConfig.PWAttempts, Topic + 'Maximum number of password attempts');
  Form.AddBol  ('2', ' Password Inquiry '   , 52, 15, 72, 15, 18,  3, @bbsConfig.PWInquiry, Topic + 'Allow user to send password inquiry Email');

  Form.Execute;

  Box.Close;

  Form.Free;
  Box.Free;

End;

Procedure SystemPaths;
Var
  Box   : TMenuBox;
  Form  : TMenuForm;
  Topic : String;
Begin
  Topic := '|03(|09System Paths|03) |01-|09> |15';
  Box   := TMenuBox.Create(Console);
  Form  := TMenuForm.Create(Console);

  Box.Header := ' System Directories ';

  Box.Open     (5,  6,  75, 21);
  VerticalLine (26, 8, 17);
  Console.WriteXY (7, 20, 112, 'Note: There are additional paths found in the Theme Editor');

  Form.AddPath ('S', ' System Path ',       13,  8, 28,  8, 13, 45, 60, @bbsConfig.PathSystem,   Topic + 'Root directory of Mystic BBS system');
  Form.AddPath ('D', ' Data File Path '   , 10,  9, 28,  9, 16, 45, 60, @bbsConfig.PathData,     Topic + 'Directory where data files are stored');
  Form.AddPath ('M', ' Message Base Path ',  7, 10, 28, 10, 19, 45, 60, @bbsConfig.PathMsgs,     Topic + 'Default message base data file storage directory');
  Form.AddPath ('L', ' System Logs Path ' ,  8, 11, 28, 11, 18, 45, 60, @bbsConfig.PathLogs,     Topic + 'Directory where BBS logs and chat logs are stored');
  Form.AddPath ('A', ' File Attach Path ' ,  8, 12, 28, 12, 18, 45, 60, @bbsConfig.PathAttach,   Topic + 'Directory where files attached to messages are stored');
  Form.AddPath ('O', ' Offline Mail Path ',  7, 13, 28, 13, 19, 45, 60, @bbsConfig.PathOffMail,  Topic + 'Local offline mail packet directory');
  Form.AddPath ('T', ' Text File Path ',    10, 14, 28, 14, 16, 45, 60, @bbsConfig.PathText,     Topic + 'Default display file directory');
  Form.AddPath ('E', ' Template Path ',     11, 15, 28, 15, 15, 45, 60, @bbsConfig.PathTemplate, Topic + 'Default template file directory');
  Form.AddPath ('U', ' Menu File Path ',    10, 16, 28, 16, 16, 45, 60, @bbsConfig.PathMenu,     Topic + 'Default menu file directory');
  Form.AddPath ('C', ' Script File Path ',   8, 17, 28, 17, 18, 45, 60, @bbsConfig.PathScripts,  Topic + 'Default script (MPL) directory');

  Form.Execute;

  Box.Close;

  Form.Free;
  Box.Free;
End;

Procedure InternetOptions;
Var
  Box   : TMenuBox;
  Form  : TMenuForm;
  Topic : String;
Begin
  Topic := '|03(|09Internet Servers|03) |01-|09> |15';
  Box   := TMenuBox.Create(Console);
  Form  := TMenuForm.Create(Console);

  Box.Header := ' Internet Server Options ';

  Box.Open(4, 7, 76, 17);

  VerticalLine(19,  9, 9);
  VerticalLine(19, 11, 15);

  Console.WriteXY (10, 11, 112, '(TELNET)');
  Console.WriteXY (13, 12, 112, '(FTP)');
  Console.WriteXY (12, 13, 112, '(SMTP)');
  Console.WriteXY (12, 14, 112, '(POP3)');
  Console.WriteXY (12, 15, 112, '(NNTP)');

  Form.Clear;

  Form.AddStr  ('D', ' Domain Name ', 6,  9, 21,  9, 13, 30, 30, @bbsConfig.InetDomain,   Topic + 'Internet domain name assigned to BBS');

  Form.AddBol  ('1', 'Use',     21, 11, 25, 11, 3, 3, @bbsConfig.InetTNUse, Topic + 'Activate telnet server');
  Form.AddWord ('1', 'Port',    31, 11, 36, 11, 4, 5, 0, 65000, @bbsConfig.InetTNPort, Topic + 'Telnet server listening port');
  Form.AddByte ('1', 'Clients', 44, 11, 52, 11, 7, 3, 1, 255, @bbsConfig.InetTNMax, Topic + 'Maximum telnet connections (nodes)');
  Form.AddByte ('1', 'IPs',     58, 11, 62, 11, 3, 3, 1, 255, @bbsConfig.InetTNIPs, Topic + 'Maximum # of connections per IP address');

  Form.AddBol  ('1', 'Use',     21, 12, 25, 12, 3, 3, @bbsConfig.InetFTPUse, Topic + 'Active FTP server');
  Form.AddWord ('1', 'Port',    31, 12, 36, 12, 4, 5, 0, 65000, @bbsConfig.InetFTPPort, Topic + 'FTP server listening port');
  Form.AddByte ('1', 'Clients', 44, 12, 52, 12, 7, 3, 1, 255, @bbsConfig.InetFTPMax, Topic + 'Maximum FTP connections');
  Form.AddByte ('1', 'IPs',     58, 12, 62, 12, 3, 3, 1, 255, @bbsConfig.InetFTPIPs, Topic + 'Maximum # of connections per IP address');

  Form.AddBol  ('1', 'Use',     21, 13, 25, 13, 3, 3, @bbsConfig.INetSMTPUse,  Topic + 'Activate SMTP server');
  Form.AddWord ('1', 'Port',    31, 13, 36, 13, 4, 5, 0, 65000, @bbsConfig.InetSMTPPort, Topic + 'SMTP server listening port');
  Form.AddByte ('1', 'Clients', 44, 13, 52, 13, 7, 3, 1, 255, @bbsConfig.InetSMTPMax, Topic + 'Maximum SMTP connections');
  Form.AddByte ('1', 'IPs',     58, 13, 62, 13, 3, 3, 1, 255, @bbsConfig.InetSMTPIPs, Topic + 'Maximum # of connections per IP address');

  Form.AddBol  ('1', 'Use',     21, 14, 25, 14, 3, 3, @bbsConfig.InetPOP3Use,  Topic + 'Activate POP3 server');
  Form.AddWord ('1', 'Port',    31, 14, 36, 14, 4, 5, 0, 65000, @bbsConfig.InetPOP3Port, Topic + 'POP3 server listening port');
  Form.AddByte ('1', 'Clients', 44, 14, 52, 14, 7, 3, 1, 255, @bbsConfig.InetPOP3Max, Topic + 'Maximum POP3 connections');
  Form.AddByte ('1', 'IPs',     58, 14, 62, 14, 3, 3, 1, 255, @bbsConfig.InetPOP3IPs, Topic + 'Maximum # of connections per IP address');

  Form.AddBol  ('1', 'Use',     21, 15, 25, 15, 3, 3, @bbsConfig.INetNNTPUse,  Topic + 'Activate NNTP server');
  Form.AddWord ('1', 'Port',    31, 15, 36, 15, 4, 5, 0, 65000, @bbsConfig.InetNNTPPort, Topic + 'NNTP server listening port');
  Form.AddByte ('1', 'Clients', 44, 15, 52, 15, 7, 3, 1, 255, @bbsConfig.InetNNTPMax, Topic + 'Maximum NNTP connections');
  Form.AddByte ('1', 'IPs',     58, 15, 62, 15, 3, 3, 1, 255, @bbsConfig.InetNNTPIPs, Topic + 'Maximum # of connections per IP address');

  Form.Execute;

  Box.Close;

  Form.Free;
  Box.Free;
End;

End.
