{$I M_OPS.PAS}

Unit BBS_Doors;

Interface

Uses
  BBS_Common;

Type
  TBBSDoor = Class
    Owner      : Pointer;
    Path       : String;
    Name       : String;
    Door       : RecDoors;
    SavedAvail : Boolean;

    Constructor Create (O: Pointer);
    Destructor  Destroy; Override;
    Procedure   Write_DORINFO;
    Procedure   Write_DOOR32;
    Procedure   Write_DOORSYS;
    Procedure   Write_CHAINTXT;
    Function    ParseDoorCodes (Str: String) : String;
    Procedure   Execute (ID: String);

    {$IFDEF WINDOWS}
      Procedure ExecuteWin32;
    {$ENDIF}
  End;

Implementation

Uses
  {$IFDEF WIN32}
    Windows,
    SysUtils,
  {$ENDIF}
  BBS_Core,
  BBS_User,
  m_Socket,
  m_FileIO,
  m_DateTime,
  m_Strings;

Constructor TBBSDoor.Create (O: Pointer);
Begin
  Inherited Create;

  Owner := O;
End;

Procedure TBBSDoor.Write_DORINFO;
Var
  tFile : Text;
  Temp  : Byte;
Begin
  Assign  (tFile, Path + 'dorinfo1.def');
  ReWrite (tFile);
  WriteLn (tFile, bbsConfig.BBSName);
  WriteLn (tFile, strWordGet(1, bbsConfig.SysopName, ' '));

  Temp := Pos(' ', bbsConfig.SysopName);

  If Temp > 0 Then
    WriteLn (tFile, Copy(bbsConfig.SysopName, Temp + 1, 255))
  Else
    WriteLn (tFile, '');

  WriteLn (tFile, 'COM1');
  WriteLn (tFile, '38400 BAUD,N,8,1');
  WriteLn (tFile, '0'); {WHAT IS THIS?}
  WriteLn (tFile, strWordGet(1, Name, ' '));

  Temp := Pos(' ', Name);

  If Temp > 0 Then
    WriteLn (tFile, Copy(Name, Temp + 1, 255))
  Else
    WriteLn (tFile, '');

  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.CityState);
  WriteLn (tFile, TBBSCore(Owner).Term.Graphics);
  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.Security);
  WriteLn (tFile, TBBSCore(Owner).User.TimeLeft);  //time left in minutes
  WriteLn (tFile, '-1'); {-1 FOSSIL, 0=NOT... ???}
  Close   (tFile);
End;

Procedure TBBSDoor.Write_DOOR32;
Var
  tFile : Text;
Begin
  Assign  (tFile, Path + 'door32.sys');
  ReWrite (tFile);
  WriteLn (tFile, '2');  // telnet
  WriteLn (tFile, TBBSCore(Owner).Client.FSocketHandle); // socket handle
  WriteLn (tFile, '38400');
  WriteLn (tFile, 'Mystic ' + mysVersionText);
  WriteLn (tFile, TBBSCore(Owner).User.ThisUserPos);
  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.RealName);
  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.Handle);
  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.Security);
  WriteLn (tFile, TBBSCore(Owner).User.TimeLeft);  //Time left
  WriteLn (tFile, TBBSCore(Owner).Term.Graphics);
  WriteLn (tFile, TBBSCore(Owner).Node);
  Close   (tFile);
End;

Procedure TBBSDoor.Write_DOORSYS;
Var
  tFile : Text;
Begin
  Assign  (tFile, Path + 'door.sys');
  ReWrite (tFile);
  WriteLn (tFile, 'COM1:');
  WriteLn (tFile, '38400');
  WriteLn (tFile, '8');
  WriteLn (tFile, TBBSCore(Owner).Node);
  WriteLn (tFile, '38400'); {locked rate}
  WriteLn (tFile, 'Y'); {screen display}
  WriteLn (tFile, 'N');
  WriteLn (tFile, 'Y'); {page bell}
  WriteLn (tFile, 'Y');
  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.RealName);
  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.CityState);
  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.HomePhone);
  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.DataPhone);
  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.Password);
  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.Security);
  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.Calls);
  WriteLn (tFile, DateDos2Str(TBBSCore(Owner).User.ThisUser.LastCall, 1));
  WriteLn (tFile, TBBSCore(Owner).User.TimeLeft * 60); // time left in seconds
  WriteLn (tFile, TBBSCore(Owner).User.TimeLeft);      // time left in minutes

  If TBBSCore(Owner).Term.Graphics > 0 Then
    WriteLn (tFile, 'GR')
  Else
    WriteLn (tFile, 'NG');

  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.ScreenSize);   {page length}
  WriteLn (tFile, 'N');    {Y=expert, N=novice}
  WriteLn (tFile, '');
  WriteLn (tFile, '');
  WriteLn (tFile, '');  {user account expiration date}
  WriteLn (tFile, TBBSCore(Owner).User.ThisUserPos); {user record number}
  WriteLn (tFile, ''); {default protocol}
  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.Uploads);
  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.Downloads);
  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.DownloadKB);
  WriteLn (tFile, TBBSCore(Owner).User.Security.MaxDLk);
  WriteLn (tFile, DateJulian2Str(TBBSCore(Owner).User.ThisUser.Birthdate, 1));
  WriteLn (tFile, bbsConfig.PathData);
  WriteLn (tFile, bbsConfig.PathMsgs);
  WriteLn (tFile, bbsConfig.SysopName);
  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.Handle);
  WriteLn (tFile, '00:00');  // next event start time
  WriteLn (tFile, 'Y'); {error-free connection}
  WriteLn (tFile, 'N'); {ansi in NG mode}
  WriteLn (tFile, 'Y'); {record locking}
  WriteLn (tFile, '7'); {default BBS color}
  WriteLn (tFile, '0'); {time credits per minute}
  WriteLn (tFile, '00/00/00'); {last new filescan date}
  WriteLn (tFile, TimeDos2Str(TBBSCore(Owner).User.ThisUser.LastCall, False)); {time of this call}
  WriteLn (tFile, TimeDos2Str(TBBSCore(Owner).User.ThisUser.LastCall, False)); {time of last call}
  WriteLn (tFile, '32768'); {max daily files (??) }
  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.DLsToday);
  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.UploadKB);
  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.DownloadKB);
  WriteLn (tFile, ''); {user comment}
  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.DoorsRan);
  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.MsgPosts); {total posts}
  Close   (tFile);
End;

Procedure TBBSDoor.Write_CHAINTXT;
Var
  tFile : Text;
Begin
  Assign  (tFile, Path + 'chain.txt');
  ReWrite (tFile);
  WriteLn (tFile, TBBSCore(Owner).User.ThisUserPos);
  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.Handle);
  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.RealName);
  WriteLn (tFile, '');
  WriteLn (tFile, DaysAgo(TBBSCore(Owner).User.ThisUser.Birthdate) DIV 365);
  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.Gender);
  WriteLn (tFile, '0');  { User's gold }
  WriteLn (tFile, DateDos2Str(TBBSCore(Owner).User.ThisUser.LastCall, 1));
  WriteLn (tFile, '80');
  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.ScreenSize);
  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.Security);
  WriteLn (tFile, '0');
  WriteLn (tFile, '0');
  WriteLn (tFile, TBBSCore(Owner).Term.Graphics);
  WriteLn (tFile, '1');  // not local
  WriteLn (tFile, TBBSCore(Owner).User.TimeLeft * 60);  //time left in seconds
  WriteLn (tFile, TBBSCore(Owner).Theme.PathText);
  WriteLn (tFile, BbsConfig.PathData);
  WriteLn (tFile, 'node', TBBSCore(Owner).Node, '.log');
  WriteLn (tFile, '38400');
  WriteLn (tFile, '1');  //comport
  WriteLn (tFile, bbsConfig.BBSName);
  WriteLn (tFile, bbsConfig.SysopName);
  WriteLn (tFile, TimerSeconds);
  WriteLn (tFile, TBBSCore(Owner).User.TimeOn * 60); {seconds online}
  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.UploadKB);
  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.Uploads);
  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.DownloadKB);
  WriteLn (tFile, TBBSCore(Owner).User.ThisUser.Downloads);
  WriteLn (tFile, '8N1');
  Close   (tFile);
End;

Destructor TBBSDoor.Destroy;
Begin
  Inherited Destroy;
End;

{$IFDEF WINDOWS}
Procedure TBBSDoor.ExecuteWin32;
Var
  PI          : TProcessInformation;
  SI          : TStartupInfo;
  CommandLine : String;
  StartDir    : String;
Begin
  CommandLine := Door.StartPath + ParseDoorCodes(Door.Command) + #0;
  StartDir    := Door.StartPath + #0;

  FillChar (SI, SizeOf(SI), 0);
  FillChar (PI, SizeOf(PI), 0);

  SI.cb          := SizeOf(SI);
  SI.dwFlags     := STARTF_USESHOWWINDOW;
  SI.wShowWindow := SW_SHOWMINNOACTIVE;

  If CreateProcess(
    NIL,
    PChar(@CommandLine[1]),
    NIL,
    NIL,
    True,
    Create_New_Console or Normal_Priority_Class,
    NIL,
    PChar(@StartDir[1]),
    SI,
    PI)
  Then Begin
    WaitForSingleObject (PI.hProcess, INFINITE);
    CloseHandle (PI.hProcess);
    CloseHandle (PI.hThread);
  End Else
    TBBSCore(Owner).SystemLog('Error executing door');
End;
{$ENDIF}

Function TBBSDoor.ParseDoorCodes (Str: String) : String;
Var
  Count : Byte;
Begin
  Result := '';
  Count  := 1;

  While Count <= Length(Str) Do Begin
    If Str[Count] = '%' Then Begin
      Inc (Count);
      Case UpCase(Str[Count]) of
        '#' : Result := Result + strI2S(TBBSCore(Owner).User.ThisUser.UserID);
        'D' : Result := Result + Path;
        'H' : Result := Result + strI2S(TBBSCore(Owner).Client.FSocketHandle);
        'N' : Result := Result + strI2S(TBBSCore(Owner).Node);
        'P' : Result := Result + TBBSCore(Owner).TempPath;
        'R' : Result := Result + TBBSCore(Owner).User.ThisUser.RealName;
        'U' : Result := Result + TBBSCore(Owner).User.ThisUser.Handle;
        'T' : Result := Result + strI2S(TBBSCore(Owner).User.TimeLeft);
        'I' : Result := Result + TBBSCore(Owner).Client.PeerIP;
      Else
        Result := Result + '%' + Str[Count];
      End;
    End Else
      Result := Result + Str[Count];

    Inc (Count);
  End;
End;

Procedure TBBSDoor.Execute (ID: String);
Var
  DoorFile : TBufFile;
  Found    : Boolean;
Begin
  ID       := strUpper(ID);
  Found    := False;
  DoorFile := TBufFile.Create(4096);

  If Not DoorFile.Open (BbsConfig.PathData + 'doors.dat', fmOpenCreate, fmReadWrite + fmDenyNone, SizeOf(RecDoors)) Then Begin
    DoorFile.Free;
    Exit;
  End;

  While Not DoorFile.EOF Do Begin
    DoorFile.Read(Door);
    If Door.DoorID = ID Then Begin
      Found := True;
      Break;
    End;
  End;

  If Found And (Door.Flags And RecDoorStats <> 0) Then Begin
    If Copy(DateDos2Str(Door.LastRan, 1), 1, 5) <> Copy(DateDos2Str(CurDateDos, 1), 1, 5) Then Begin
      Door.LastRan  := CurDateDos;
      Door.RanToday := 0;
    End;

    Inc (Door.RanToday);
    Inc (Door.RanTotal);

    DoorFile.Seek  (DoorFile.FilePos - 1);
    DoorFile.Write (Door);

    Inc (TBBSCore(Owner).User.ThisUser.DoorsRan);
  End;

  DoorFile.Close;
  DoorFile.Free;

  If Not Found Then Begin
    TBBSCore(Owner).SystemLog('Invalid door: ' + ID);
    Exit;
  End;

  If Door.Flags And RecDoorRealName <> 0 Then
    Name := TBBSCore(Owner).User.ThisUser.RealName
  Else
    Name := TBBSCore(Owner).User.ThisUser.Handle;

  Path := TBBSCore(Owner).TempPath;

  If Door.Flags And RecDoorDropPath <> 0 Then
    If FileDirExists(Door.StartPath) Then
      Path := Door.StartPath;

  TBBSCore(Owner).User.SaveUser;

  Write_DORINFO;
  Write_DOORSYS;
  Write_CHAINTXT;
  Write_DOOR32;

  If Door.Flags And RecDoorLoading <> 0 Then Begin
    TBBSCore(Owner).Term.PromptInfo['A'] := Door.Name;
    TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(205));
  End;

  SavedAvail := TBBSCore(Owner).User.ThisUser.Available;
  TBBSCore(Owner).User.ThisUser.Available := False;

  TBBSCore(Owner).User.SetUserAction(strReplace(TBBSCore(Owner).GetPrompt(65), '|&A', Door.Name));

  TBBSCore(Owner).SystemLog('Executed: ' + Door.Name);

  {$IFDEF WIN32}
    ExecuteWin32;
  {$ENDIF}

  {$IFDEF LINUX}
    // Not Implemented yet...
  {$ENDIF}

  SearchForUser(TBBSCore(Owner).User.ThisUser.Handle, TBBSCore(Owner).User.ThisUser, TBBSCore(Owner).User.ThisUserPos);
  TBBSCore(Owner).User.ThisUser.Available := SavedAvail;
End;

End.
