/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_PANELSPARENT
#define __LCMD_PANELSPARENT

#include "lcmd/LCmdFilePanelFrame.h"

/**
 * This class defines the common parent window of the two file panels.
 *
 * @author  Leif Erik Larsen
 * @since   1999.04.08
 */
class LCmdPanelsParent : public GWindow
{
   public:

      const GString FRAME1_NAME;
      const GString FRAME2_NAME;

      /**
       * The first (and the left, by default) of the two file panel windows.
       *
       * Whether it is the left or the right file panel depends on if the
       * "Swap panels" command has been performed.
       */
      LCmdFilePanelFrame frame1;

      /**
       * The second (and the right, by default) of the two file panel windows.
       *
       * Whether it is the left or the right file panel depends on if the
       * "Swap panels" command has been performed.
       */
      LCmdFilePanelFrame frame2;

   public:

      LCmdPanelsParent ( class LCmdSubClient& parentWin, const GString& constraints );
      virtual ~LCmdPanelsParent ();

   public:

      /**
       * Get the preferred height of the window, in pixels.
       */
      int getPreferredHeight () const;

      /**
       * Load and activate the profile variables for the file panel
       * parent window, from the specified section name.
       * @see #writeProfile
       */
      void queryProfile ( const GString& sectName );

      /**
       * Write the profile variables for the file panel parent window,
       * under the specified section name.
       * @see #queryProfile
       */
      void writeProfile ( const GString& sectName, bool force );
};

#endif // #ifndef __LCMD_PANELSPARENT
