/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_MAKEDIR
#define __LCMD_MAKEDIR

#include "glib/primitives/GString.h"

/**
 * Used by the "Make Directory" command.
 */
class LCmdMakeDir : public GObject
{
   public:

      /** Previous string specified in the dialog. */
      GString dirStr;

      /** True if "Create as ZIP-file" is on. */
      bool makeAsZip;

   public:

      LCmdMakeDir ();
      virtual ~LCmdMakeDir ();

   public:

      /**
       * Handle the menu command <i>cmdMakeDir</i>.
       * That is the command used to create a new directory in the
       * specified file panel. The user will be prompted for the directory
       * name of which to be created. Nested directory creation is supported.
       */
      void cmdMakeDir ( class LCmdFilePanel& panel );

   private:

      /**
       * Create a directory with the name specified in <i>dir</i>. If
       * <i>asZip</i> is true then we will create a ZIP-file with the
       * name <i>dir</i> rather than create a physical directory.
       *
       * In case of any error, we will show the corresponding error message
       * in a message box that uses the <i>hWndParent</i> window as its
       * parent window.
       *
       * @author  Leif Erik Larsen
       * @since   2005.03.09
       * @param   vfs  The Virtual File System of where to make directory.
       * @return  True on success, or else false on any error.
       */
      bool doMakeDir ( class GVfs& vfs, const GString& dir, bool asZip );
};

#endif // #ifndef __LCMD_MAKEDIR
