/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_FILEPANELMODETREE
#define __LCMD_FILEPANELMODETREE

#include "lcmd/LCmdFilePanelModeAbstract.h"

#include "glib/gui/GTreeView.h"
#include "glib/gui/tree/GMutableTreeNode.h"
#include "glib/gui/tree/GDefaultTreeModel.h"

/**
 * @author  Leif Erik Larsen
 * @since   2006.01.15
 */
class LCmdFilePanelModeTree : public GWindow,
                              public GTreeViewListener,
                              public LCmdFilePanelModeAbstract
{
   public:

      /** The file panel containing the filenames list that we show. */
      class LCmdFilePanel& fpanel;

      /** The root node of our tree. */
      GMutableTreeNode rootNode;

      /** The tree of directory nodes. */
      GDefaultTreeModel dirTree;

      /** The tree view. */
      GTreeView treeView;

   public:

      explicit LCmdFilePanelModeTree ( class LCmdFilePanel& fpanel,
                                       const GString& winName );

      virtual ~LCmdFilePanelModeTree ();

   protected:

      virtual bool onPaint ( class GGraphics& g, const class GRectangle& rect );
      virtual bool onTimer ( const GString& timerID, GObject* userData );

   private:

      void refreshContent ();

      /** Implements {@link GTreeViewListener#treeNodeIsCollapsing}. */
      virtual void treeNodeIsCollapsing ( class GTreeNode& node );

      /** Implements {@link GTreeViewListener#treeNodeIsExpanding}. */
      virtual void treeNodeIsExpanding ( class GTreeNode& node );

      /** Implements {@link GTreeViewListener#treeNodeSelectionHasChanged}. */
      virtual void treeNodeSelectionHasChanged ();

   public:

      virtual int calcItemIdxFromPos ( int xpos, int ypos ) const;

      virtual bool calcItemRect ( int itemIndex, class GRectangle& rect ) const;

      virtual void drawItem ( int itemIndex );
      virtual void drawItem ( int itemIndex, class GGraphics& g, const class GRectangle& itemRect, bool isDragOver = false );

      /**
       * Get the current selected file item, or null if the current 
       * selection is a drive node or if there is no current selection.
       *
       * @author  Leif Erik Larsen
       * @since   2006.10.12
       */
      class LCmdFileItem* getCurrentSelectedFileItem ();

      virtual int getCurrentSelectedIndex () const;

      virtual int getFirstVisibleIndex () const;

      virtual void invalidateAll ( bool inclChildren ) const;

      virtual void invalidateRect ( const GRectangle& rect ) const;

      virtual bool isHorizontallyScrollable () const;

      virtual void itemsListHasBeenRefreshed ();

      virtual void layout ();

      virtual int navigateDown ();
      virtual int navigateUp ();
      virtual int navigateEnd ();
      virtual int navigateHome ();
      virtual int navigateLeft ();
      virtual int navigateRight ();
      virtual int navigatePageDown ();
      virtual int navigatePageUp ();
      virtual int navigateRandom ( int index );

      virtual void onViewHasBeenActivated ();
};

#endif // #ifndef __LCMD_FILEPANELMODETREE
