/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_FILEPANELMODEINFO
#define __LCMD_FILEPANELMODEINFO

#include "lcmd/LCmdFilePanelModeAbstract.h"
#include "lcmd/LCmdFileItemContainer.h"

#include "glib/gui/GDecoratedWindow.h"

/**
 * @author  Leif Erik Larsen
 * @since   2006.01.15
 */
class LCmdFilePanelModeInfo : public GDecoratedWindow,
                              public LCmdFilePanelModeAbstract,
                              public LCmdFileItemContainer::Listener
{
   friend class LCmdFilePanel;

   public:

      /** The file panel containing the filenames list that we show. */
      class LCmdFilePanel& fpanel;

      /** 
       * Index of current selected item, or -1 if no item is selected. 
       * This variable is not actually used by this view mode, but we need
       * to keep track of the "selected index" upon {@link #navigateRandom}
       * in order to keep selection index anyway.
       */
      int curSelectedItem;

      /** Always contain current rectangle of the file names container area. */
      GRectangle filesRect;

   public:

      explicit LCmdFilePanelModeInfo ( class LCmdFilePanel& fpanel,
                                       const GString& winName );

      virtual ~LCmdFilePanelModeInfo ();

   private:

      virtual void allItemsHaveBeenRemoved ();

      void scrollHorizontal ( int add );
      void scrollVertical ( int add );
      void updateScrollBarPos ();
      void updateHScrollBarPos ();
      void updateVScrollBarPos ();
      void updateScrollBarRange ();

   protected:

      virtual bool onFontNameSizeChanged ( const GString& fontNameSize );

      virtual bool onHScrollLineUp ();
      virtual bool onHScrollLineDown ();
      virtual bool onHScrollPageUp ();
      virtual bool onHScrollPageDown ();
      virtual bool onHScrollSliderTrack ( int pos );

      virtual bool onVScrollLineUp ();
      virtual bool onVScrollLineDown ();
      virtual bool onVScrollPageUp ();
      virtual bool onVScrollPageDown ();
      virtual bool onVScrollSliderTrack ( int pos );

      virtual bool onPaint ( class GGraphics& g, const class GRectangle& rect );

   public:

      virtual int calcItemIdxFromPos ( int xpos, int ypos ) const;

      virtual bool calcItemRect ( int itemIndex, class GRectangle& rect ) const;

      virtual void drawItem ( int itemIndex );
      virtual void drawItem ( int itemIndex, class GGraphics& g, const class GRectangle& itemRect, bool isDragOver = false );

      virtual int getCurrentSelectedIndex () const;

      virtual int getFirstVisibleIndex () const;

      virtual void invalidateAll ( bool inclChildren ) const;

      virtual void invalidateRect ( const GRectangle& rect ) const;

      virtual bool isHorizontallyScrollable () const;

      virtual void itemsListHasBeenRefreshed ();

      virtual void layout ();

      virtual int navigateDown ();
      virtual int navigateUp ();
      virtual int navigateEnd ();
      virtual int navigateHome ();
      virtual int navigateLeft ();
      virtual int navigateRight ();
      virtual int navigatePageDown ();
      virtual int navigatePageUp ();
      virtual int navigateRandom ( int index );

      virtual void onViewHasBeenActivated ();
};

#endif // #ifndef __LCMD_FILEPANELMODEINFO
