/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_FILEPANELFRAME
#define __LCMD_FILEPANELFRAME

#include "lcmd/LCmdFilePanelHeader.h"
#include "lcmd/LCmdFilePanelInfoBar.h"
#include "lcmd/LCmdFilePanel.h"

/**
 * This is the window class that is used to contain all parts of a file panel.
 *
 * This includes the header window, the parent window of the file panel it
 * self, and the infobar window.
 *
 * @author  Leif Erik Larsen
 * @since   1998.10.11
 */
class LCmdFilePanelFrame : public GWindow
{
   public:

      /** A reference to the parent window. */
      class LCmdPanelsParent& panelsParent;

      LCmdFilePanelHeader headerWin;
      LCmdFilePanel fpanel;
      LCmdFilePanelInfoBar infoBar;

   public:

      LCmdFilePanelFrame ( const GString& name, 
                           const GString& constraints, 
                           class LCmdPanelsParent& parentWin );

      virtual ~LCmdFilePanelFrame ();

   protected:

      bool onButton1DblClk ( int xpos, int ypos, const GWindowMessage::InputFlags& flags );
      bool onButton1Down ( int xpos, int ypos, const GWindowMessage::InputFlags& flags );

      /**
       * Change the mouse cursor to west/east arrow in case it is
       * currently located above vertical split bar, between the two
       * file panels.
       *
       * @return True if and only if the mouse cursor was actually set.
       */
      bool onMouseMove ( int xpos, int ypos, const GWindowMessage::InputFlags& flags );

      bool onPaint ( GGraphics& g, const GRectangle& rect );

   public:

      /**
       * We overides this method from GWindow in order to respect
       * the current swapped state of the two file panels.
       *
       * @author  Leif Erik Larsen
       * @since   2001.04.16
       */
      virtual GString getName () const;

      /**
       * Get the preferred width of the window, in pixels.
       */
      int getPreferredWidth () const;

      bool isPosOnHSplit ( int xpos, int ypos );
      bool isPosOnVSplit ( int xpos, int ypos );


      /**
       * Will call the default super implementation and then also call 
       * {@link LCmdFilePanel#activatePanel} afterwards.
       *
       * @author  Leif Erik Larsen
       * @since   2005.12.11
       * @see     LCmdFilePanel#activatePanel
       */
      virtual void setActive ( bool force = false );

      void setWidth ( int width );
      void setHeight ( int height );
};

#endif // #ifndef __LCMD_FILEPANELFRAME
