/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_EXITWORKER
#define __LCMD_EXITWORKER

#include "glib/primitives/GAtomicCounter.h"
#include "glib/gui/GWorkerThread.h"

/**
 * A worker thread class that is used to detach or stop every child 
 * process of Larsen Commander, when Larsen Commander is about to exit. 
 *
 * The detachment or stopping of child processes must be performed by 
 * a separate background thread (and not the GUI-thread) in order to prevent 
 * deadlocks in the GUI-thread. Because the GUI-thread is needed to 
 * handle various events that are posted by the {@link LCmdProcessLauncher} 
 * when a child process is about to terminate.
 * 
 * @author  Leif Erik Larsen
 * @since   2004.09.16
 */
class LCmdExitWorker : public GWorkerThread
{

private:

   class LCmdCmdLineEntry& entry;
   GAtomicCounter<int> countStopped;
   GString nowStopping;

   /**
    * The number of child processes when the exit worker thread started.
    */
   int processCountStart;

   /** 
    * True if we should detach child processes, 
    * or else false if we should stop them. 
    */
   bool detach;

   /**
    * True if we should ignore any running child processes and exit 
    * without bothering at all.
    */
   bool ignore;

public:

   LCmdExitWorker ();
   virtual ~LCmdExitWorker ();

protected:

   virtual void onWorkerThreadInitDialog ( class GWorkerThread& worker, 
                                           class GDialogPanel& monitor );

   virtual void onWorkerThreadCommand ( class GWorkerThread& worker,
                                        class GDialogPanel& monitor, 
                                        const GString& cmdID );

   virtual void onWorkerThreadUpdateMonitor ( class GWorkerThread& worker,
                                              class GDialogPanel& monitor );

   virtual void runTheWorkerThread ( class GWorkerThread& worker );

public:

   void performExit ();
};

#endif // #ifndef __LCMD_EXITWORKER
