/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_DYNAFILESEARCH
#define __LCMD_DYNAFILESEARCH

#include "glib/gui/GMultiLineEditor.h"

/**
 * This is the dynamic filename search window that is to be contained
 * in the header bar window of a file panel.
 *
 * The header bar always contains three buttons that are all visible by
 * default; the Drive-, Up-Dir-, and the Root-Dir- buttons. In addition,
 * it contains a text entry window that is visible only when the user
 * is about to type in some dynamic filename search text.
 *
 * @author  Leif Erik Larsen
 * @since   1999.04.07
 */
class LCmdDynaFileSearch : public GMultiLineEditor
{
   private:

      class LCmdFilePanelHeader& header;

   public:

      explicit LCmdDynaFileSearch ( class LCmdFilePanelHeader& parentWin );
      virtual ~LCmdDynaFileSearch ();

   private:

      /** Disable the copy constructor. */
      LCmdDynaFileSearch ( const LCmdDynaFileSearch& );

      /** Disable the assignment operator. */
      void operator= ( const LCmdDynaFileSearch& );

   public:

      virtual bool onKeyDown ( const class GKeyMessage& key );
      virtual void onFocusKill ();
      virtual void onFocusSet ();
      virtual bool onUserMessage ( class GUserMessage& msg );

      /**
       * We override this method in order to do our own logic whenever 
       * the contained text of our subclassed {@link GMultiLineEditor} 
       * changes. When the contained text changes we will perform 
       * the dynamic filename searching, selecting the next filename 
       * item which name mathches the contained text of ours.
       *
       * @author  Leif Erik Larsen
       * @since   2004.09.06
       */
      virtual void fireValueChangeListeners ();
};

#endif // #ifndef __LCMD_DYNAFILESEARCH
