/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "lcmd/LCmdDlgSelectFiles.h"
#include "lcmd/LCmdFilePanel.h"

#include "glib/GProgram.h"
#include "glib/gui/GDialogPanel.h"
#include "glib/gui/GTextEntry.h"
#include "glib/gui/event/GDialogMessage.h"

LCmdDlgSelectFiles::LCmdDlgSelectFiles ( LCmdFilePanel& panel, 
                                         LCmdFilePanelSelectOptions& select, 
                                         GString title )
                   :panel(panel),
                    select(select),
                    title(title)
{
}

LCmdDlgSelectFiles::~LCmdDlgSelectFiles () 
{
}

bool LCmdDlgSelectFiles::execute ()
{
   GProgram& prg = GProgram::GetProgram();
   GString id = prg.executeDialog(&panel, "DlgSelectFiles", this);
   return id == "DLG_OK";
}

bool LCmdDlgSelectFiles::handleDialogMessage ( GDialogMessage& msg )
{
   GDialogPanel& dlg = msg.getDialog();
   switch (msg.getID())
   {
      case GM_INITDIALOG: 
      {
         dlg.getOwnerFrame().setText(title);
         GTextEntry& entry = dynamic_cast<GTextEntry&>(dlg.getComponentByID("101"));
         entry.setText(select.filter);
         entry.setSelectionAll();
         if (!select.inclFiles && !select.inclDirs)
            select.inclFiles = true; // One of the toggles must be on!
         dlg.setComponentValue("103", select.inclFiles);
         dlg.setComponentValue("104", select.inclDirs);
         return true; 
      }

      case GM_CTRLCHANGED: 
      {
         // Make sure at least one toggle is on (Files/Directories).
         GString compID = msg.getParam1String();
         if (compID == "103")
         {
            if (!dlg.getComponentBoolValue("103"))
               dlg.setComponentValue("104", true);
         }
         else
         if (compID == "104")
         {
            if (!dlg.getComponentBoolValue("104"))
               dlg.setComponentValue("103", true);
         }
         return true; 
      }

      case GM_COMMAND: 
      {
         GString cmdID = msg.getParam1String();
         if (cmdID == "DLG_OK")
         {
            // Get the content of the entry field containg filter.
            select.filter = dlg.getComponentValue("101");
            select.inclFiles = dlg.getComponentBoolValue("103");
            select.inclDirs = dlg.getComponentBoolValue("104");
            dlg.dismiss(cmdID);
         }
         else
         if (cmdID == "DLG_CANCEL")
         {
            dlg.dismiss(cmdID);
         }
         return true; 
      }

      default:
         return false;
   }
}

