/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_DLGGOTOLINE
#define __LCMD_DLGGOTOLINE

#include "glib/gui/event/GDialogMessageHandler.h"

/**
 * This dialog is used to let the user specify the line number of
 * which to goto. It used by the console monitor ({@link GTextViewer}.
 *
 * @since   2000.09.18
 * @author  Leif Erik Larsen
 */
class LCmdDlgGotoLine : public GDialogMessageHandler
{
   private:

      /** The lowest value that can be specified by the user. */
      int minLine;

      /** The largest value that can be specified by the user. */
      int maxLine;

      /** The value to return from {@link #execute} if user has cancelled. */
      int cancelLine;

      /** The line actually selected by the user. Valid only when the OK button was selected. */
      int selectedLine;

      /** The line to be initially selected by default (usually the "current" line). */
      int defaultLine;

   public:

      /**
       * @param  minLine     The lowest value that can be specified by the user.
       * @param  maxLine     The largest value that can be specified by the user.
       * @param  defaultLine The value to initially show in the entry field.
       * @param  cancelLine  The value to return from {@link #execute} if user
       *                     has cancelled.
       */
      LCmdDlgGotoLine ( int minLine, 
                        int maxLine, 
                        int defaultLine, 
                        int cancelLine );

      virtual ~LCmdDlgGotoLine ();

   private:

      /**
       * This is the message handler method that is called to handle
       * messages from the dialog box window.
       */
      bool handleDialogMessage ( class GDialogMessage& msg );

   public:

      /**
       * Called by the specified text viewer object when the user
       * has requested the search dialog to be executed (as a modal dialog).
       *
       * @author  Leif Erik Larsen
       * @since   2000.09.18
       */
      int execute ( class GWindow* parentWin );
};

#endif // #ifndef __LCMD_DLGGOTOLINE
