/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "lcmd/LCmdDlgFileTime.h"
#include "lcmd/LCmdFileItem.h"
#include "lcmd/LCmdFilePanel.h"

#include "glib/gui/GDialogPanel.h"
#include "glib/gui/event/GDialogMessage.h"

LCmdDlgFileTime::LCmdDlgFileTime ( LCmdFilePanel& panel )
                :LCmdDirProgressBase(panel.vfs.peek(), &panel)
{
}

LCmdDlgFileTime::~LCmdDlgFileTime ()
{
}

bool LCmdDlgFileTime::handleFileItem ( LCmdFileItem* pFile,
                                       int /*fileIndex*/,
                                       bool* bSkipped,
                                       bool* itemUpdated )
{
   pFile->timeWrite = timeWrite;
   return setPathInfo(*pFile, bSkipped, itemUpdated);
}

void LCmdDlgFileTime::execute ()
{
   // Execute the secondary thread as soon as the progress bar has been created
   startTheDirectoryProcessor("DlgFileTime", 
                              "%Txt_DlgFileTime_TitleProgBar");
}

bool LCmdDlgFileTime::handleDialogMessage ( GDialogMessage& msg )
{
   GDialogPanel& dlg = msg.getDialog();
   switch (msg.getID())
   {
      case GM_INITDIALOG:
      {
         LCmdDirProgressBase::handleDialogMessage(msg);
         int curSel = panel->getCurrentSelectedIndex();
         if (panel->markedFilesCount > 0)
         {
            // Initially suggest to perform something like a classic
            // "touch" command on all the current marked items.
            dlg.sendDialogMessage(GM_COMMAND, "118");
         }

         else
         if (curSel >= 0)
         {
            LCmdFileItem& pFile = panel->items.get(curSel);

            timeWrite = pFile.timeWrite;

            dlg.setComponentValue("110", timeWrite.getYear());
            dlg.setComponentValue("106", timeWrite.getMonth());
            dlg.setComponentValue("104", timeWrite.getDay());
            dlg.setComponentValue("112", timeWrite.getHours());
            dlg.setComponentValue("114", timeWrite.getMinutes());
            dlg.setComponentValue("116", timeWrite.getSeconds());
         }

         dlg.setComponentFocus("DLG_OK");
         return true;
      }

      case GM_COMMAND:
      {
         LCmdDirProgressBase::handleDialogMessage(msg);
         GString cmdID = msg.getParam1String();
         if (cmdID == "118") // Now!
         {
            GTimeStamp now;
            dlg.setComponentValue("110", now.getYear());
            dlg.setComponentValue("106", now.getMonth());
            dlg.setComponentValue("104", now.getDay());
            dlg.setComponentValue("112", now.getHours());
            dlg.setComponentValue("114", now.getMinutes());
            dlg.setComponentValue("116", now.getSeconds());
         }
         else
         if (cmdID == "DLG_OK")
         {
            timeWrite.setYear(dlg.getComponentIntValue("110"));
            timeWrite.setMonth(dlg.getComponentIntValue("106"));
            timeWrite.setDay(dlg.getComponentIntValue("104"));
            timeWrite.setHours(dlg.getComponentIntValue("112"));
            timeWrite.setMinutes(dlg.getComponentIntValue("114"));
            timeWrite.setSeconds(dlg.getComponentIntValue("116"));

            dlg.dismiss(cmdID);
         }
         return true;
      }

      default:
         return LCmdDirProgressBase::handleDialogMessage(msg);
   }
}

